/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector2;

import com.sas.codepolicy.SASScope;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@SASScope
public class FilterTypeCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "FilterTypeCommand.";
    private String actionClass;
    private BaseRemoteFileModelInterface model;
    private String selectedKey;
    private String path;
    private HashMap fileTypes;
    private boolean contentsChanged;
    private HashMap eventInfo = new HashMap(2);
    private Object eventSource;

    public FilterTypeCommand() {
    }

    public FilterTypeCommand(String name) {
        super(name);
    }

    public FilterTypeCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    public void execute(Object o) {
        this.model = this.getModel();
        this.setEventSource(this.model);
        this.fileTypes = this.getFilterTypes();
        this.selectedKey = this.getSelectedKey();
        this.path = this.getPath();
        List<Object> list = new ArrayList();
        Object types = this.fileTypes.get(this.selectedKey);
        if (types instanceof List) {
            list = (List)types;
        } else {
            list.add(types);
        }
        if (this.model instanceof RemoteFileModel2Interface) {
            ((RemoteFileModel2Interface)this.model).setFilterValues(list);
            ((RemoteFileModel2Interface)this.model).setRefreshNeeded(true);
        }
        this.contentsChanged = true;
        this.eventInfo.put("path", this.path);
    }

    public void setSelectedKey(String selectedKey) {
        this.selectedKey = selectedKey;
    }

    public String getSelectedKey() {
        return this.selectedKey;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setFilterTypes(HashMap filterTypes) {
        this.fileTypes = filterTypes;
    }

    public HashMap getFilterTypes() {
        return this.fileTypes;
    }

    public void setModel(BaseRemoteFileModelInterface model) {
        this.model = model;
    }

    public BaseRemoteFileModelInterface getModel() {
        return this.model;
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }
}

