/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector2;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.codepolicy.SASScope;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.DeleteFileInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import java.util.HashMap;

@SASScope
public class DeleteCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "DeleteCommand.";
    private BaseRemoteFileModelInterface remoteModel;
    private SortableTableModelAdapter tableModel;
    private int tableIndex;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo = new HashMap(2);
    private Object eventSource;
    private String newName;

    public DeleteCommand() {
        this(null);
    }

    public DeleteCommand(String name) {
        super(name);
    }

    public DeleteCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    public void execute(Object o) {
        this.tableModel = this.getTableModel();
        this.remoteModel = (BaseRemoteFileModelInterface)this.tableModel.getModel();
        this.setEventSource(this.remoteModel);
        this.tableIndex = this.getIndex();
        RemoteFileMetadataInterface directoryNode = this.remoteModel.getNodeAt(this.tableIndex);
        if (this.remoteModel instanceof DeleteFileInterface) {
            ((DeleteFileInterface)((Object)this.remoteModel)).deleteItem(directoryNode);
            this.remoteModel.setRefreshNeeded(true);
            this.contentsChanged = true;
            this.eventInfo.put("path", directoryNode.getLocation());
        }
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setTableModel(SortableTableModelAdapter tableModel) {
        this.tableModel = tableModel;
    }

    public SortableTableModelAdapter getTableModel() {
        return this.tableModel;
    }

    public void setIndex(int index) {
        this.tableIndex = index;
    }

    public int getIndex() {
        return this.tableIndex;
    }
}

