/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector.informationservices;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.ifileservice.IFileServiceModel;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesFileMetadata;
import java.rmi.RemoteException;
import java.util.HashMap;

public class RenameCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "RenameCommand.";
    private String path;
    private IFileServiceModel serviceModel;
    private RemoteFileServerModelInterface remoteModel;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;
    private String newName;
    private int tableIndex;

    public RenameCommand() {
    }

    public RenameCommand(String name) {
        super(name);
    }

    public RenameCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) {
        this.setEventSource(this.remoteModel);
        InformationServicesFileMetadata node = (InformationServicesFileMetadata)this.remoteModel.getNodeAt(this.tableIndex);
        MetadataInterface serviceObject = node.getServiceObject();
        try {
            serviceObject.setName(this.newName);
            serviceObject.update();
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.contentsChanged = true;
        this.eventInfo.put("path", this.remoteModel.getPath());
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setServiceModel(IFileServiceModel serviceModel) {
        this.serviceModel = serviceModel;
    }

    public IFileServiceModel getServiceModel() {
        return this.serviceModel;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setIndex(int index) {
        this.tableIndex = index;
    }

    public int getIndex() {
        return this.tableIndex;
    }

    public void setModel(RemoteFileServerModelInterface model) {
        this.remoteModel = model;
    }

    public RemoteFileServerModelInterface getModel() {
        return this.remoteModel;
    }
}

