/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector.informationservices;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesFileMetadata;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class DeleteCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "DeleteCommand.";
    private RemoteFileServerModelInterface remoteModel;
    private SortableTableModelAdapter tableModel;
    private int tableIndex;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;
    private String newName;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)DeleteCommand.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory());

    public DeleteCommand() {
    }

    public DeleteCommand(String name) {
        super(name);
    }

    public DeleteCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) {
        this.tableModel = this.getTableModel();
        this.remoteModel = (RemoteFileServerModelInterface)this.tableModel.getModel();
        this.setEventSource(this.remoteModel);
        this.tableIndex = this.getIndex();
        RemoteFileMetadataInterface directoryNode = this.remoteModel.getNodeAt(this.tableIndex);
        MetadataInterface serviceObject = ((InformationServicesFileMetadata)directoryNode).getServiceObject();
        try {
            serviceObject.delete();
            String path = this.remoteModel.getPath();
            DefaultMutableTreeNode parentNode = this.remoteModel.getCacheModel().findCurrentCacheNode(path);
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)parentNode.getChildAt(this.tableIndex);
            treeNode.removeFromParent();
            this.contentsChanged = true;
            this.eventInfo.put("path", path);
        }
        catch (ServiceException se) {
            this.log.error(se.getMessage(), (Throwable)se);
        }
        catch (RemoteException re) {
            this.log.error(re.getMessage(), (Throwable)re);
        }
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setTableModel(SortableTableModelAdapter tableModel) {
        this.tableModel = tableModel;
    }

    public SortableTableModelAdapter getTableModel() {
        return this.tableModel;
    }

    public void setIndex(int index) {
        this.tableIndex = index;
    }

    public int getIndex() {
        return this.tableIndex;
    }
}

