/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector.ifileservice;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.iom.SAS.IFileInfo;
import com.sas.iom.SAS.IFileInfoHelper;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.ifileservice.IFileServiceModel;
import com.sas.swing.visuals.remotefileselector.RB;
import java.util.HashMap;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class RenameCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "RenameCommand.";
    private String path;
    private RemoteFileServerModelInterface remoteModel;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private java.lang.Object eventSource;
    private String newName;
    private String oldName;

    public RenameCommand() {
    }

    public RenameCommand(String name) {
        super(name);
    }

    public RenameCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(java.lang.Object o) throws IllegalArgumentException {
        IFileService fileService = ((IFileServiceModel)this.remoteModel.getModel()).getWorkspace().FileService();
        this.setEventSource(this.remoteModel);
        try {
            StringHolder renameAssignedName = new StringHolder();
            String oldPath = this.remoteModel.combineDirectoryPathAndFileName(this.remoteModel.getPath(), this.oldName);
            String newPath = this.remoteModel.combineDirectoryPathAndFileName(this.remoteModel.getPath(), this.newName);
            boolean inSystem = true;
            try {
                IFileref fileRef = fileService.AssignFileref("a1", "DISK", newPath, "", renameAssignedName);
                IFileInfo fileInfo = IFileInfoHelper.narrow((Object)fileRef);
                if (fileInfo.StatusValue() == 0) {
                    this.contentsChanged = false;
                    fileService.DeassignFileref(renameAssignedName.value);
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "sameName.txt"));
                }
                inSystem = false;
                fileService.DeassignFileref(renameAssignedName.value);
            }
            catch (GenericError ge) {
                inSystem = false;
            }
            if (!inSystem) {
                ((IFileServiceModel)this.remoteModel.getModel()).getWorkspace().FileService().RenameFile(oldPath, newPath);
                this.contentsChanged = true;
                this.eventInfo.put("path", this.remoteModel.getPath());
            }
        }
        catch (GenericError genericError) {
            // empty catch block
        }
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public java.lang.Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(java.lang.Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getOldName() {
        return this.oldName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setModel(RemoteFileServerModelInterface model) {
        this.remoteModel = model;
    }

    public RemoteFileServerModelInterface getModel() {
        return this.remoteModel;
    }
}

