/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector.ifileservice;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.ifileservice.IFileServiceFileMetadata;
import com.sas.swing.models.remotefileselector.ifileservice.IFileServiceModel;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class PasteCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "PasteCommand.";
    private RemoteFileServerModelInterface remoteModel;
    private SortableTableModelAdapter tableModel;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;
    private String newName;
    private int tableIndex;

    public PasteCommand() {
    }

    public PasteCommand(String name) {
        super(name);
    }

    public PasteCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) {
        this.tableModel = this.getTableModel();
        this.remoteModel = (RemoteFileServerModelInterface)this.tableModel.getModel();
        IFileServiceModel serviceModel = (IFileServiceModel)this.remoteModel.getModel();
        this.setEventSource(this.remoteModel);
        this.tableIndex = this.getIndex();
        RemoteFileMetadataInterface directoryNode = null;
        RemoteFileMetadataInterface indexDirectoryNode = (RemoteFileMetadataInterface)this.remoteModel.getCacheModel().findCurrentCacheNode(this.remoteModel.getPath()).getUserObject();
        if (this.tableIndex != -1) {
            indexDirectoryNode = this.remoteModel.getNodeAt(this.tableIndex);
        }
        directoryNode = !indexDirectoryNode.isDrillable() ? (RemoteFileMetadataInterface)this.remoteModel.getCacheModel().findCurrentCacheNode(indexDirectoryNode.getPath()).getUserObject() : indexDirectoryNode;
        String newLocation = null;
        List elements = this.remoteModel.parseIntoPathElements(directoryNode.getPath());
        newLocation = elements.lastIndexOf(directoryNode.getName()) == 0 ? directoryNode.getPath() : serviceModel.combineDirectoryPathAndFileName(directoryNode.getPath(), directoryNode.getName());
        List pasteBuffer = this.remoteModel.getPasteBuffer();
        int commandType = this.remoteModel.getPasteBufferCommandType();
        for (int i = 0; i < pasteBuffer.size(); ++i) {
            IFileServiceFileMetadata node = (IFileServiceFileMetadata)pasteBuffer.get(i);
            String oldName = serviceModel.combineDirectoryPathAndFileName(node.getPath(), node.getName());
            String newName = serviceModel.combineDirectoryPathAndFileName(newLocation, node.getName());
            IWorkspace workspace = serviceModel.getWorkspace();
            if (commandType == 0) continue;
            try {
                if (!oldName.equals(newName)) {
                    workspace.FileService().RenameFile(oldName, newName);
                    workspace.FileService().DeleteFile(oldName);
                    if (node.getPath().equals(newLocation)) {
                        DefaultMutableTreeNode treeNode = this.remoteModel.getCacheModel().findCurrentCacheNode(oldName);
                        treeNode.removeFromParent();
                    } else {
                        this.remoteModel.refresh();
                    }
                }
                this.contentsChanged = true;
                this.eventInfo.put("path", newLocation);
                continue;
            }
            catch (GenericError genericError) {
                // empty catch block
            }
        }
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setTableModel(SortableTableModelAdapter tableModel) {
        this.tableModel = tableModel;
    }

    public SortableTableModelAdapter getTableModel() {
        return this.tableModel;
    }

    public void setIndex(int index) {
        this.tableIndex = index;
    }

    public int getIndex() {
        return this.tableIndex;
    }
}

