/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector;

import com.sas.actionprovider.BaseActionProvider;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.models.remotefileselector.RemoteFileSearchModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import java.util.Date;
import java.util.HashMap;

public class StartSearchCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "StartSearchCommand.";
    private String actionClass;
    private RemoteFileSearchModelInterface serviceModel;
    private RemoteFileServerModelInterface model;
    private String searchText;
    private String searchContext;
    private String startingPath;
    private boolean recursive;
    private Date startDate;
    private Date endDate;
    private BaseActionProvider actionProvider;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;

    public StartSearchCommand() {
    }

    public StartSearchCommand(String name) {
        super(name);
    }

    public StartSearchCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) {
        this.serviceModel = this.getServiceModel();
        this.searchText = this.getSearchText();
        this.searchContext = this.getSearchContext();
        this.startingPath = this.getStartingPath();
        this.recursive = this.getRecursive();
        this.startDate = this.getStartDateTime();
        this.endDate = this.getEndDateTime();
        this.model = this.getRemoteModel();
        this.actionProvider = this.getActionProvider();
        this.setEventSource(this.model);
        this.serviceModel.setSearchContext(this.searchContext);
        this.serviceModel.setSearchText(this.searchText);
        this.serviceModel.setStartingLocation(this.startingPath);
        this.serviceModel.setRecursive(this.recursive);
        this.serviceModel.setDateRange(this.startDate, this.endDate);
        this.serviceModel.startSearch(this.model, this.actionProvider);
        this.contentsChanged = true;
        this.eventInfo.put("path", this.startingPath);
        this.eventInfo.put("type", "SEARCH");
    }

    public void setSearchContext(String searchContext) {
        this.searchContext = searchContext;
    }

    public String getSearchContext() {
        return this.searchContext;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setStartingPath(String startingPath) {
        this.startingPath = startingPath;
    }

    public String getStartingPath() {
        return this.startingPath;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public void setStartDateTime(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDateTime() {
        return this.startDate;
    }

    public void setEndDateTime(Date endDate) {
        this.endDate = endDate;
    }

    public Date getEndDateTime() {
        return this.endDate;
    }

    public void setServiceModel(RemoteFileSearchModelInterface serviceModel) {
        this.serviceModel = serviceModel;
    }

    public RemoteFileSearchModelInterface getServiceModel() {
        return this.serviceModel;
    }

    public void setRemoteModel(RemoteFileServerModelInterface remoteModel) {
        this.model = remoteModel;
    }

    public RemoteFileServerModelInterface getRemoteModel() {
        return this.model;
    }

    public void setActionProvider(BaseActionProvider provider) {
        this.actionProvider = provider;
    }

    public BaseActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }
}

