/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector;

import com.sas.commands.relational.SortCommand;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import javax.swing.table.TableModel;

public class SortFoldersFirstCommand
extends SortCommand {
    public static final String RB_KEY = "SortFoldersFirstCommand.";
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)SortFoldersFirstCommand.class.getName(), null);

    public SortFoldersFirstCommand() {
        this(null);
    }

    public SortFoldersFirstCommand(int direction) {
        this(null, direction);
    }

    public SortFoldersFirstCommand(String name) {
        this(name, 0);
    }

    public SortFoldersFirstCommand(String name, int direction) {
        this.setName(name);
        this.setDirection(direction);
    }

    public void execute(Object o) {
        SortableInterface model = this.getModel();
        if (model != null) {
            String columnName = TableViewUtil.getColumnName((TableModel)((TableModel)model), (int)this.getColumn());
            boolean drillableColumn = false;
            int columnCount = ((TableModel)model).getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                if (!"drillable".equals(((TableModel)model).getColumnName(i))) continue;
                drillableColumn = true;
                break;
            }
            try {
                if (drillableColumn) {
                    model.sort(new String[]{"drillable", columnName}, new int[]{this.getDirection(), this.getDirection()});
                } else {
                    model.sort(new String[]{columnName}, new int[]{this.getDirection()});
                }
            }
            catch (SortException ex) {
                this.log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

