/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import java.util.HashMap;

public class OpenFolderCommand
extends BaseCommand
implements ContentsChangedInterface,
CommandSupportedInterface {
    public static final String RB_KEY = "OpenFolderCommand.";
    private String actionClass;
    private String path;
    private String folderName;
    private RemoteFileServerModelInterface model;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;

    public OpenFolderCommand() {
    }

    public OpenFolderCommand(String name) {
        super(name);
    }

    public OpenFolderCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) throws IllegalArgumentException {
        String folderName = this.getFolderName();
        if (folderName != null) {
            try {
                this.model = this.getModel();
                this.setEventSource(this.model);
                String newPath = this.model.combineDirectoryPathAndFileName(this.getPath(), this.getFolderName());
                this.model.setPath(newPath);
                this.contentsChanged = true;
                this.eventInfo.put("path", newPath);
                this.eventInfo.put("type", "NAVIGATE");
            }
            catch (IllegalArgumentException iae) {
                this.contentsChanged = false;
                throw iae;
            }
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setFolderName(String folder) {
        this.folderName = folder;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setModel(RemoteFileServerModelInterface model) {
        this.model = model;
    }

    public RemoteFileServerModelInterface getModel() {
        return this.model;
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }
}

