/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.util.remotefile2;

import com.sas.actionprovider.ActionStatusKeysInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.support.remotefileselector2.RemoteFileSelectorAreaInterface;
import com.sas.actionprovider.util.remotefile2.RemoteFileDynamicValueKeys;
import com.sas.codepolicy.SASScope;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.Location;
import com.sas.swing.models.remotefileselector2.LocationNode;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.WritePermissionsInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesSearchModel;
import java.util.List;

@SASScope(value="ALL")
public class RemoteFileActionUtil
implements RemoteFileSelectorAreaInterface,
RemoteFileDynamicValueKeys,
ActionStatusKeysInterface {
    static final String RB_KEY = "RemoteFileActionUtil.";

    public Object getSortModel(ActionSupportFilter filter) {
        return filter.getAttribute("model");
    }

    public Object getRemoteFileServerModel(ActionSupportFilter filter) {
        return ((SortableTableModelAdapter)filter.getAttribute("model")).getModel();
    }

    public Object getRemoteFileServerModelFromToolBarFilter(ActionSupportFilter filter) {
        return filter.getAttribute("model");
    }

    public Object getRemoteFileServerModelPath(ActionSupportFilter filter) {
        return ((BaseRemoteFileModelInterface)this.getRemoteFileServerModelFromToolBarFilter(filter)).getLocation();
    }

    public Object getRemoteFileServerModelParentPath(ActionSupportFilter filter) {
        String parentPath = "";
        BaseRemoteFileModelInterface model = (BaseRemoteFileModelInterface)this.getRemoteFileServerModelFromToolBarFilter(filter);
        String path = model.getLocation();
        if (model instanceof RemoteFileModel2Interface && ((RemoteFileModel2Interface)model).getLocations() != null) {
            List locations = ((RemoteFileModel2Interface)model).getLocations();
            if (locations != null && path != null) {
                boolean parentPathNotFound = true;
                int numOfLocations = locations.size();
                for (int locationsProcessed = 0; parentPathNotFound && locationsProcessed < numOfLocations; ++locationsProcessed) {
                    Location locationToProcess;
                    Object objectToProcess = locations.get(locationsProcessed);
                    if (!(objectToProcess instanceof Location) || !path.equals((locationToProcess = (Location)objectToProcess).getFullyQualifiedLocation())) continue;
                    parentPathNotFound = false;
                    LocationNode parentLocationNode = locationToProcess.getParentLocationNode(path);
                    if (parentLocationNode != null) {
                        parentPath = parentLocationNode.getLocation();
                    }
                    if (parentPath != null) continue;
                    parentPath = "";
                }
            } else {
                parentPath = path == null ? "" : this.getParentPath_singleRoot(model, path);
            }
        } else {
            parentPath = this.getParentPath_singleRoot(model, path);
        }
        return parentPath;
    }

    private String getParentPath_singleRoot(BaseRemoteFileModelInterface model, String path) {
        String[][] foldersAndLocations = model.parseIntoFoldersAndLocations(path);
        String parentPath_singleRoot = "";
        if (foldersAndLocations.length > 1 && (parentPath_singleRoot = foldersAndLocations[1][0]) != null && parentPath_singleRoot.trim().equals("")) {
            return "";
        }
        return parentPath_singleRoot;
    }

    public Object isFolder(ActionSupportFilter filter) {
        return this.getNode(filter).isFolder() ? Boolean.TRUE : Boolean.FALSE;
    }

    public RemoteFileMetadataInterface getNode(ActionSupportFilter filter) {
        return null;
    }

    public Object getFullyQualifiedLocation(ActionSupportFilter filter) {
        return this.getNode(filter).getLocation();
    }

    @SASScope
    public Object getFileName(ActionSupportFilter filter) {
        if (this.isFolder(filter) == Boolean.TRUE) {
            return null;
        }
        return this.getNode(filter).getName();
    }

    @SASScope
    public Object getFolderName(ActionSupportFilter filter) {
        if (this.isFolder(filter) == Boolean.FALSE) {
            return null;
        }
        return this.getNode(filter).getName();
    }

    public static Object getAreaValue(ActionSupportFilter filter) {
        return null;
    }

    public int getDisabledIfUpRestricted(ActionSupportFilter filter, int currentStatus) {
        Object rfsModel;
        Object model = filter.getAttribute("model");
        if (model != null && model instanceof BaseRemoteFileModelInterface) {
            if (((BaseRemoteFileModelInterface)model).isUpwardPathRestricted()) {
                currentStatus |= 2;
            }
        } else if (model != null && model instanceof SortableTableModelAdapter && ((BaseRemoteFileModelInterface)(rfsModel = this.getRemoteFileServerModel(filter))).isUpwardPathRestricted()) {
            currentStatus |= 2;
        }
        return currentStatus;
    }

    @SASScope
    public int getOpenFolderStatus(ActionSupportFilter filter, int currentStatus) {
        currentStatus = this.getAreaDisabledIfNotFirstColumn(filter, currentStatus);
        RemoteFileMetadataInterface node = this.getNode(filter);
        if (node != null) {
            BaseRemoteFileModelInterface rfsModel;
            if (!node.isFolder()) {
                currentStatus |= 4;
            } else if (node.isFolder() && (rfsModel = (BaseRemoteFileModelInterface)this.getRemoteFileServerModel(filter)) instanceof InformationServicesSearchModel) {
                currentStatus |= 2;
            }
        } else {
            currentStatus |= 4;
        }
        return currentStatus;
    }

    @SASScope
    public int getAreaDisabledIfNotFirstColumn(ActionSupportFilter filter, int currentStatus) {
        return currentStatus;
    }

    @SASScope
    public Object getCurrentLocation(ActionSupportFilter filter) {
        Object model = filter.getAttribute("model");
        if (model instanceof BaseRemoteFileModelInterface) {
            return ((BaseRemoteFileModelInterface)model).getLocation();
        }
        return null;
    }

    @SASScope
    public int getDisabledIfPasteBufferIsEmpty(ActionSupportFilter filter, int actionStatus) {
        List pasteBuffer;
        int upStatus = this.getDisabledIfUpRestricted(filter, actionStatus);
        BaseRemoteFileModelInterface rfsModel = (BaseRemoteFileModelInterface)this.getRemoteFileServerModel(filter);
        if (upStatus != 2 && ((pasteBuffer = rfsModel.getPasteBuffer()) == null || pasteBuffer.isEmpty())) {
            return 2;
        }
        return upStatus;
    }

    public int getDisabledIfNoWritePermissions(String path, WritePermissionsInterface model, int actionStatus) {
        if (!model.canWrite(path)) {
            return 2;
        }
        return actionStatus;
    }
}

