/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.util.olap;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.dataitems.OLAPTableRoles;
import com.sas.dataselectors.dataitems.RB;
import com.sas.dataselectors.dataitems.TableRoles;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataNotChangeableException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.util.RoleInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class OLAPRoles
extends OLAPTableRoles {
    private static String COLUMN_LABEL = "Columns";
    private static String ROW_LABEL = "Rows";
    private static String SLICER_LABEL = "Slicer";
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory());

    public OLAPRoles(BusinessQuery arg0) {
        super(arg0);
    }

    public List getAvailableDataItems(BusinessQuery bq) {
        if (bq == null || bq.getInputStructure().isRelational()) {
            return new ArrayList();
        }
        List swappableDataItems = null;
        try {
            TableRoles tableRoles = OLAPRoles.createTableRoles(bq);
            OLAPRoles.updateRoleItems(bq, tableRoles);
            RoleInterface[] tableRoleArray = tableRoles.getRoles();
            RoleInterface[] rolesUsed = this.removeSlicerRole(tableRoleArray);
            swappableDataItems = this.getSwappableDataItems(this.getDimensionsUsed(rolesUsed));
            this.removeItemsThatShareDimensionWithItemsOnSlicerAxis(tableRoleArray, swappableDataItems);
            this.removeDuplicateItems(swappableDataItems);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        return swappableDataItems;
    }

    private void removeItemsThatShareDimensionWithItemsOnSlicerAxis(RoleInterface[] tableRoleArray, List swappableDataItems) {
        RoleInterface slicerRole = this.getSlicerRole(tableRoleArray);
        List slicerRoleItems = slicerRole.getRoleItems();
        int num = slicerRoleItems.size();
        for (int i = 0; i < num; ++i) {
            String dimensionName = this.getDimensionName(slicerRoleItems.get(i));
            if (dimensionName == null) continue;
            Iterator iterator = swappableDataItems.iterator();
            while (iterator.hasNext()) {
                DataItem dataItem = (DataItem)iterator.next();
                if (this.listContainsDataItemOrReferencesToDataItem(slicerRoleItems, dataItem) || !dimensionName.equals(this.getDimensionName(dataItem))) continue;
                iterator.remove();
            }
        }
    }

    public List getSwappableDataItems(List dimensionsUsed) {
        if (this._businessModel == null) {
            return new ArrayList();
        }
        List dataItems = this._businessModel.getObjects(true, DataItem.class);
        Iterator iterator = dataItems.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (item instanceof DataItemReference) {
                iterator.remove();
                continue;
            }
            if (!(item instanceof DataItem)) {
                iterator.remove();
                continue;
            }
            if (this.isMeasure((DataItem)item)) {
                iterator.remove();
                continue;
            }
            if (!(item instanceof DataItem)) {
                iterator.remove();
                continue;
            }
            if (!((DataItem)item).isUsableInQuery()) {
                iterator.remove();
                continue;
            }
            String dimensionName = this.getDimensionName(item);
            if (!dimensionsUsed.contains(dimensionName)) continue;
            iterator.remove();
        }
        return dataItems;
    }

    private RoleInterface[] removeSlicerRole(RoleInterface[] roles) {
        int slicerRuleIndex = -1;
        for (int i = 0; i < roles.length; ++i) {
            if (!roles[i].getRoleLabel().equals(SLICER_LABEL)) continue;
            slicerRuleIndex = i;
            break;
        }
        if (slicerRuleIndex == -1) {
            return roles;
        }
        int newRoleIndex = 0;
        RoleInterface[] newRoles = new RoleInterface[roles.length - 1];
        for (int i = 0; i < roles.length; ++i) {
            if (i == slicerRuleIndex) continue;
            newRoles[newRoleIndex] = roles[i];
            ++newRoleIndex;
        }
        return newRoles;
    }

    private RoleInterface getSlicerRole(RoleInterface[] roles) {
        for (int i = 0; i < roles.length; ++i) {
            if (!roles[i].getRoleLabel().equals(SLICER_LABEL)) continue;
            return roles[i];
        }
        return null;
    }

    private boolean isMeasure(DataItem di) {
        StructureOfDataItem dataItemStructure = di.getStructure();
        if (dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            return true;
        }
        return dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN && di.getExpressionType() == 2 && di.getUsage() != DataItemActionType.USAGE_CATEGORY;
    }

    private List getDimensionsUsed(RoleInterface[] roles) {
        ArrayList<String> dimensions = new ArrayList<String>();
        int count = roles.length;
        for (int i = 0; i < count; ++i) {
            List roleItems = roles[i].getRoleItems();
            int count2 = roleItems.size();
            for (int j = 0; j < count2; ++j) {
                if (!(roleItems.get(j) instanceof DataItem)) continue;
                DataItem di = (DataItem)roleItems.get(j);
                String dimension = null;
                try {
                    dimension = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)this._businessModel, (DataItem)di);
                    if (dimension == null || dimensions.contains(dimension)) continue;
                    dimensions.add(dimension);
                    continue;
                }
                catch (MetadataException ex) {
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error("Exception", (Throwable)ex);
                }
            }
        }
        return dimensions;
    }

    private static TableRoles createTableRoles(BusinessQuery query) throws MetadataException {
        OLAPRoles tableRoles = null;
        try {
            StructureOfData sod = query.getInputStructure();
            if (sod.isOLAP()) {
                tableRoles = new OLAPRoles(query);
                ((OLAPTableRoles)tableRoles).addRole("row", ROW_LABEL, ROW_LABEL, 1, 0);
                ((OLAPTableRoles)tableRoles).addRole("column", COLUMN_LABEL, COLUMN_LABEL, 1, 0);
                ((OLAPTableRoles)tableRoles).addRole("slicer", SLICER_LABEL, SLICER_LABEL, 1, 0);
            } else {
                tableRoles = new TableRoles(query);
                tableRoles.setQueryType("group");
                tableRoles.addRole("column", COLUMN_LABEL, COLUMN_LABEL, 1, 0);
            }
        }
        catch (Exception ex) {
            return tableRoles;
        }
        return tableRoles;
    }

    private static void updateRoleItems(BusinessQuery query, TableRoles tableRoles) {
        if (query == null || tableRoles == null) {
            throw new IllegalArgumentException("Null arguments invalid.");
        }
        RoleInterface[] rolesUsed = tableRoles.getRoles();
        List resultItems = null;
        try {
            int count = rolesUsed.length;
            for (int i = 0; i < count; ++i) {
                rolesUsed[i].removeAllRoleItems();
                if (rolesUsed[i].getRoleName().equalsIgnoreCase("column")) {
                    resultItems = query.getResultItems(com.sas.iquery.metadata.business.Role.COLUMN);
                } else if (rolesUsed[i].getRoleName().equalsIgnoreCase("row")) {
                    resultItems = query.getResultItems(com.sas.iquery.metadata.business.Role.ROW);
                } else if (rolesUsed[i].getRoleName().equalsIgnoreCase("slicer")) {
                    resultItems = query.getResultItems(com.sas.iquery.metadata.business.Role.BACKGROUND);
                }
                if (resultItems == null) continue;
                rolesUsed[i].addRoleItems(resultItems);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    private String getDimensionName(Object obj) {
        String dimensionName = null;
        if (obj instanceof DataItem) {
            DataItem di = (DataItem)obj;
            try {
                dimensionName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)this._businessModel, (DataItem)di);
            }
            catch (MetadataException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return dimensionName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRole(String name, String label, String description, int minRoleItemCount, int maxRoleItemCount) {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)"TableRoles.", (String)"nullRoleName.txt", (Locale)this.getLocale()));
        }
        if (label == null) {
            label = name;
        }
        if (description == null) {
            description = label;
        }
        if (!this.isValidRole(name)) throw new IllegalArgumentException(RB.getStringResource((String)"TableRoles.", (String)"invalidRoleType.txt", (Locale)this.getLocale()));
        if (this.getRole(name, label) != null) throw new IllegalStateException(RB.getStringResource((String)"TableRoles.", (String)"duplicateRole.txt", (Locale)this.getLocale()));
        try {
            Role role = new Role(name, label, description, minRoleItemCount, maxRoleItemCount);
            this.getRolesList().add(role);
            return;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean listContainsDataItemOrReferencesToDataItem(List list, Object dataItem) {
        if (list == null || dataItem == null) {
            return false;
        }
        int numItems = list.size();
        for (int i = 0; i < numItems; ++i) {
            DataItem listItem = (DataItem)list.get(i);
            if (listItem == dataItem) {
                return true;
            }
            if (!(listItem instanceof DataItemReference) || ((DataItemReference)listItem).getBaseDataItem() != dataItem) continue;
            return true;
        }
        return false;
    }

    @SASScope
    protected class Role
    extends TableRoles.Role {
        public Role(String name, String label, String description, int minCount, int maxCount) {
            super((TableRoles)OLAPRoles.this, name, label, description, minCount, maxCount);
        }

        public void addRoleItem(Object item, List availableRoleItems) {
            Map _dataItemMap = OLAPRoles.this.getDataItemMap();
            if (availableRoleItems == null) {
                availableRoleItems = this.getAvailableRoleItems();
            }
            RoleInterface[] roles = OLAPRoles.this.getRoles();
            int numroles = roles.length;
            List lastObjectsAdded = OLAPRoles.this._businessModel.getObjects(false, DataItem.class);
            List allObjects = OLAPRoles.this._businessModel.getObjects(true, DataItem.class);
            boolean inAvailableItems = false;
            if (availableRoleItems.contains(item)) {
                inAvailableItems = true;
            }
            if (inAvailableItems) {
                try {
                    boolean lastObjectsAddedListContainsItem = OLAPRoles.this.listContainsDataItemOrReferencesToDataItem(lastObjectsAdded, item);
                    boolean allObjectsListContainsItem = OLAPRoles.this.listContainsDataItemOrReferencesToDataItem(allObjects, item);
                    if (!lastObjectsAddedListContainsItem || lastObjectsAddedListContainsItem && (this._roleItems.contains(item) || !allObjectsListContainsItem)) {
                        DataItemReference ref = OLAPRoles.this._businessModel.newDataItemReference((DataItem)item);
                        OLAPRoles.this.dataItemRefList.add(ref);
                        this._roleItems.add(ref);
                        OLAPRoles.this._businessModel.addBusinessItem((BusinessItem)ref);
                        _dataItemMap.put(ref.getID(), ref);
                    } else if (allObjectsListContainsItem) {
                        this._roleItems.add(item);
                    }
                }
                catch (MetadataNotChangeableException e) {
                    OLAPRoles.this.log.error(e.getMessage(), (Throwable)e);
                }
                catch (MetadataException e) {
                    OLAPRoles.this.log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new IllegalArgumentException(RB.getStringResource((String)"TableRoles.", (String)"itemNotAvailable.txt", (Locale)OLAPRoles.this.getLocale()));
            }
        }
    }
}

