/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.util.olap;

import com.sas.actionprovider.ActionStatusKeysInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.support.olaptableview.OLAPTableViewAreaInterface;
import com.sas.actionprovider.util.ActionUtil;
import com.sas.actionprovider.util.olap.OLAPActionProviderUtil;
import com.sas.actionprovider.util.olap.OLAPDynamicValueKeys;
import com.sas.actionprovider.util.olap.RB;
import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
public class OLAPActionUtil
implements OLAPTableViewAreaInterface,
OLAPDynamicValueKeys,
ActionStatusKeysInterface {
    static final String RB_KEY = "OLAPDynamicValuesUtil.";

    @SASScope
    public String getSwapDataItemNameForDifferentDimension(ActionSupportFilter filter) {
        List availableItems = (List)filter.getAttribute("availableDataItems");
        if (availableItems == null || availableItems.isEmpty()) {
            return null;
        }
        DataItem dataItem = (DataItem)availableItems.get(filter.getActionIndex() - 1);
        return dataItem.getLabel();
    }

    @SASScope
    public String getSwapDataItemIdForDifferentDimension(ActionSupportFilter filter) {
        List availableItems = (List)filter.getAttribute("availableDataItems");
        if (availableItems == null || availableItems.isEmpty()) {
            return null;
        }
        DataItem dataItem = (DataItem)availableItems.get(filter.getActionIndex() - 1);
        return dataItem.getResultSetID();
    }

    @SASScope
    public String getSwapDataItemNameForSameDimension(ActionSupportFilter filter) {
        List availableItemsSameDimension = (List)filter.getAttribute("availableDataItemsSameDimension");
        if (availableItemsSameDimension == null || availableItemsSameDimension.isEmpty()) {
            return null;
        }
        DataItem dataItem = (DataItem)availableItemsSameDimension.get(filter.getActionIndex() - 1);
        return dataItem.getLabel();
    }

    @SASScope
    public String getSwapDataItemIdForSameDimension(ActionSupportFilter filter) {
        List availableItemsSameDimension = (List)filter.getAttribute("availableDataItemsSameDimension");
        if (availableItemsSameDimension == null || availableItemsSameDimension.isEmpty()) {
            return null;
        }
        DataItem dataItem = (DataItem)availableItemsSameDimension.get(filter.getActionIndex() - 1);
        return dataItem.getResultSetID();
    }

    public String getTupleElementLabel(ActionSupportFilter filter) {
        String label = null;
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement != null) {
            try {
                label = tupleElement.getLabel();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return label;
    }

    @SASScope
    public String getDataItemLabel(ActionSupportFilter filter) {
        String label = null;
        DataItem dataItem = (DataItem)filter.getAttribute("dataItem");
        if (dataItem != null) {
            label = dataItem.getLabel();
        }
        return label;
    }

    public String getStringAxisIndexFromAxis(ActionSupportFilter filter) {
        String axisIndex = null;
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        if (axis != null) {
            try {
                axisIndex = this.getStringFromIndex(axis.getAxisNumber());
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return axisIndex;
    }

    public String getStringAxisIndexFromTupleElement(ActionSupportFilter filter) {
        String axisIndex = null;
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement != null) {
            try {
                axisIndex = this.getStringFromIndex(tupleElement.getTuple().getAxis().getAxisNumber());
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return axisIndex;
    }

    public String getTitleAreaValue(ActionSupportFilter filter) {
        boolean isMeasure = false;
        if (filter.getAreaType().equals("ROW_TITLE_AREA")) {
            isMeasure = this.isMeasure(filter);
        }
        return isMeasure ? "&nbsp" : (String)filter.getAttribute("levelLabel");
    }

    public String getHeaderAreaValue(ActionSupportFilter filter) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        String areaValue = null;
        try {
            areaValue = tupleElement.getLabel();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return areaValue;
    }

    public String getStringTupleElementIndex(ActionSupportFilter filter) {
        String tupleElementIndex = null;
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement != null) {
            try {
                tupleElementIndex = this.getStringFromIndex(tupleElement.getTupleElementIndex());
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return tupleElementIndex;
    }

    public String getStringTupleIndex(ActionSupportFilter filter) {
        String tupleIndex = null;
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement != null) {
            try {
                TupleInterface tuple = tupleElement.getTuple();
                tupleIndex = String.valueOf(tuple.getTupleIndex());
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return tupleIndex;
    }

    public String getAxisLabel(ActionSupportFilter filter) {
        String moveAxis = null;
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        if (axis != null) {
            try {
                int axisNumber = axis.getAxisNumber();
                if (axisNumber == 1) {
                    moveAxis = RB.getStringResource(RB_KEY, "columnsLabel.txt", filter.getLocale());
                } else if (axisNumber == 0) {
                    moveAxis = RB.getStringResource(RB_KEY, "rowsLabel.txt", filter.getLocale());
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return moveAxis;
    }

    public String getOtherAxisLabel(ActionSupportFilter filter) {
        String moveAxis = null;
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        if (axis != null) {
            try {
                int axisNumber = axis.getAxisNumber();
                if (axisNumber == 1) {
                    moveAxis = RB.getStringResource(RB_KEY, "rowsLabel.txt", filter.getLocale());
                } else if (axisNumber == 0) {
                    moveAxis = RB.getStringResource(RB_KEY, "columnsLabel.txt", filter.getLocale());
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return moveAxis;
    }

    public String getAxisMoveLabel(ActionSupportFilter filter) {
        String axisMoveLabel = null;
        boolean isMeasure = this.isMeasure(filter);
        if (isMeasure) {
            axisMoveLabel = RB.getStringResource(RB_KEY, "measures.txt", filter.getLocale());
        } else {
            TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
            if (tupleElement != null) {
                try {
                    int index = OLAPActionProviderUtil.getIndexOnAxis(tupleElement);
                    String[] axisHeaders = tupleElement.getTuple().getAxis().getAxisHeaders();
                    if (axisHeaders != null && axisHeaders.length > index && index != -1) {
                        axisMoveLabel = axisHeaders[index];
                    }
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
            }
        }
        return axisMoveLabel;
    }

    public String getMoveOutDirection(ActionSupportFilter filter) {
        String direction = null;
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        if (axis != null) {
            try {
                int axisNumber = axis.getAxisNumber();
                if (axisNumber == 1) {
                    direction = RB.getStringResource(RB_KEY, "leftLabel.txt", filter.getLocale());
                } else if (axisNumber == 0) {
                    direction = RB.getStringResource(RB_KEY, "upLabel.txt", filter.getLocale());
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return direction;
    }

    public String getMoveInDirection(ActionSupportFilter filter) {
        String direction = null;
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        if (axis != null) {
            try {
                int axisNumber = axis.getAxisNumber();
                if (axisNumber == 1) {
                    direction = RB.getStringResource(RB_KEY, "rightLabel.txt", filter.getLocale());
                } else if (axisNumber == 0) {
                    direction = RB.getStringResource(RB_KEY, "downLabel.txt", filter.getLocale());
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return direction;
    }

    public String getMeasureMoveOutDirection(ActionSupportFilter filter) {
        String direction = null;
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        if (axis != null) {
            try {
                int axisNumber = axis.getAxisNumber();
                if (axisNumber == 1) {
                    direction = RB.getStringResource(RB_KEY, "downLabel.txt", filter.getLocale());
                } else if (axisNumber == 0) {
                    direction = RB.getStringResource(RB_KEY, "rightLabel.txt", filter.getLocale());
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return direction;
    }

    public String getMeasureMoveInDirection(ActionSupportFilter filter) {
        String direction = null;
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        if (axis != null) {
            try {
                int axisNumber = axis.getAxisNumber();
                if (axisNumber == 1) {
                    direction = RB.getStringResource(RB_KEY, "upLabel.txt", filter.getLocale());
                } else if (axisNumber == 0) {
                    direction = RB.getStringResource(RB_KEY, "leftLabel.txt", filter.getLocale());
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return direction;
    }

    public String getDrillUpLevelLabel(ActionSupportFilter filter) {
        String drillUpLevelLabel = null;
        String uniqueLvlName = (String)filter.getAttribute("uniqueLevelName");
        if (uniqueLvlName != null) {
            OLAPDataSetInterface model = (OLAPDataSetInterface)filter.getAttribute("model");
            List labels = OLAPActionProviderUtil.getAncestorAxisHeaders(uniqueLvlName, model);
            int levelDepth = OLAPActionProviderUtil.getLevelDepth(uniqueLvlName, model) - 1;
            if (labels != null) {
                if (labels.size() > levelDepth && levelDepth >= 0) {
                    drillUpLevelLabel = (String)labels.get(levelDepth);
                } else if (labels.size() > 0) {
                    drillUpLevelLabel = (String)labels.get(0);
                }
            }
        }
        return drillUpLevelLabel;
    }

    private String getStringFromIndex(int index) {
        return ActionUtil.getStringFromIndex((int)index);
    }

    public Map getNewStyleMap(String areaType, Class strategyClass) {
        return null;
    }

    public int getDisabledIfLastElement(ActionSupportFilter filter, int currentStatus) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement != null) {
            try {
                TupleInterface tuple = tupleElement.getTuple();
                int tupleDepth = tuple.getTupleDepth();
                int tupleElementIndex = tupleElement.getTupleElementIndex();
                if (tupleDepth - 1 == tupleElementIndex) {
                    currentStatus |= 4;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return currentStatus;
    }

    public int getDisabledIfNotLastElement(ActionSupportFilter filter, int currentStatus) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement != null) {
            try {
                TupleInterface tuple = tupleElement.getTuple();
                int tupleDepth = tuple.getTupleDepth();
                int tupleElementIndex = tupleElement.getTupleElementIndex();
                if (tupleDepth - 1 != tupleElementIndex) {
                    currentStatus |= 4;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return currentStatus;
    }

    public int getViewerDisabledIfNotLastElement(ActionSupportFilter filter, int currentStatus) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement != null) {
            try {
                TupleInterface tuple = tupleElement.getTuple();
                int tupleDepth = tuple.getTupleDepth();
                int tupleElementIndex = tupleElement.getTupleElementIndex();
                if (tupleDepth - 1 != tupleElementIndex) {
                    currentStatus |= 0x20;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return currentStatus;
    }

    public int getDisabledIfNotMeasure(ActionSupportFilter filter, int currentStatus) {
        boolean isMeasure = this.isMeasure(filter);
        if (!isMeasure) {
            currentStatus |= 4;
        }
        return currentStatus;
    }

    public int getViewerDisabledIfNotMeasure(ActionSupportFilter filter, int currentStatus) {
        boolean isMeasure = this.isMeasure(filter);
        if (!isMeasure) {
            currentStatus |= 0x20;
        }
        return currentStatus;
    }

    public int getDisabledIfNotMeasureAndNotLastElement(ActionSupportFilter filter, int currentStatus) {
        TupleElementInterface tupleElement;
        boolean isMeasure = this.isMeasure(filter);
        if (!isMeasure && (tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement")) != null) {
            try {
                int labelLength = this.getTupleElementLabelLength(tupleElement);
                TupleInterface tuple = tupleElement.getTuple();
                int tupleDepth = tuple.getTupleDepth();
                int tupleElementIndex = tupleElement.getTupleElementIndex();
                if (tupleDepth - 1 != tupleElementIndex && labelLength > 0) {
                    currentStatus |= 4;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return currentStatus;
    }

    private boolean isMeasure(ActionSupportFilter filter) {
        Boolean attr = (Boolean)filter.getAttribute("isMeasure");
        if (attr != null) {
            return attr;
        }
        return false;
    }

    private int getTupleElementLabelLength(TupleElementInterface tupleElement) throws OLAPException {
        String label = tupleElement.getLabel();
        if (label == null) {
            return 0;
        }
        return label.trim().length();
    }

    public int getDisabledIfMeasure(ActionSupportFilter filter, int currentStatus) {
        boolean isMeasure = this.isMeasure(filter);
        if (isMeasure) {
            currentStatus |= 4;
        }
        return currentStatus;
    }

    @SASScope
    public int getDisabledIfMeasureOrTotal(ActionSupportFilter filter, int currentStatus) {
        boolean isMeasure = this.isMeasure(filter);
        if (isMeasure) {
            currentStatus |= 0x10;
        }
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        try {
            if (tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                currentStatus |= 4;
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return currentStatus;
    }

    public int getDisabledIfOneAxisHeader(ActionSupportFilter filter, int currentStatus) {
        AxisInterface axis = (AxisInterface)filter.getAttribute("axis");
        OLAPDataSetInterface model = (OLAPDataSetInterface)filter.getAttribute("model");
        if (model != null && axis != null) {
            try {
                String[] axisHeaders = axis.getAxisHeaders();
                if (axisHeaders != null && axisHeaders.length == 1) {
                    currentStatus |= 0x10;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return currentStatus;
    }

    public int getDisabledIfEmptyElementLabel(ActionSupportFilter filter, int currentStatus) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement != null) {
            try {
                int labelLength = this.getTupleElementLabelLength(tupleElement);
                if (labelLength == 0) {
                    currentStatus |= 0x10;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return currentStatus;
    }

    public int getDisabledIfNotEmptyElementLabel(ActionSupportFilter filter, int currentStatus) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        if (tupleElement != null) {
            try {
                int labelLength = this.getTupleElementLabelLength(tupleElement);
                if (labelLength > 0) {
                    currentStatus |= 0x10;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return currentStatus;
    }

    public int getDisabledIfNoCellOrdinal(ActionSupportFilter filter, int currentStatus) {
        if (filter.getAttribute("cellOrdinal") == null) {
            currentStatus = 32;
        }
        return currentStatus;
    }

    public void initializeMoveMeasureLabelAction(BaseAction action, String areaType, Locale locale) {
    }

    public static int validateDataCellArea(ActionSupportFilter filter) {
        return 0;
    }

    public static int validateHeaderArea(ActionSupportFilter filter) {
        return 0;
    }

    public static int validateTitleArea(ActionSupportFilter filter) {
        return 0;
    }
}

