/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.util.olap;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.OLAPDataSet;
import java.util.ArrayList;
import java.util.List;

@SASScope(value="ALL")
public class OLAPActionProviderUtil {
    public static boolean isMeasure(String uniqueLevelName, OLAPDataSetInterface model, AxisInterface axis) {
        Filter metadataFilter = new Filter();
        return OLAPActionProviderUtil.isMeasure(uniqueLevelName, model, axis, metadataFilter);
    }

    public static boolean isMeasure(String uniqueLevelName, OLAPDataSetInterface model, AxisInterface axis, Filter metadataFilter) {
        if (uniqueLevelName != null && model != null) {
            try {
                MetadataInterface metadata;
                String cubeName = model.getCubeName();
                int index = OLAPActionProviderUtil.getIndexOnAxis(uniqueLevelName, model, axis);
                String[] dimNames = axis.getDimensionNames();
                if (cubeName != null && dimNames != null && index >= 0 && dimNames.length > index && (metadata = model.getDatabaseMetadata()) != null) {
                    metadataFilter.setCubeName(cubeName);
                    metadataFilter.setDimensionName(dimNames[index]);
                    DimensionInterface[] dims = metadata.getDimensions(metadataFilter);
                    for (int i = 0; i < dims.length; ++i) {
                        if (dims[i].getType() != 2) continue;
                        return true;
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isMeasure(TupleElementInterface tupleElement, OLAPDataSetInterface model, AxisInterface axis) {
        Filter metadataFilter = new Filter();
        return OLAPActionProviderUtil.isMeasure(tupleElement, model, axis, metadataFilter);
    }

    public static boolean isMeasure(TupleElementInterface tupleElement, OLAPDataSetInterface model, AxisInterface axis, Filter metadataFilter) {
        if (tupleElement != null) {
            try {
                return tupleElement.getType() == TupleElementType.MEASURE;
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int getIndexOnAxis(String uniqueLevelName, OLAPDataSetInterface model) {
        if (uniqueLevelName != null && model != null) {
            try {
                ResultSetMetadataInterface rsm = model.getResultSetMetadata();
                AxisInterface[] axes = rsm.getAxes(0, -1);
                for (int i = 0; i < axes.length; ++i) {
                    String[] uniqueLevelNames = axes[i].getUniqueLevelNames();
                    for (int j = 0; j < uniqueLevelNames.length; ++j) {
                        if (!uniqueLevelName.equals(uniqueLevelNames[j])) continue;
                        return j;
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getIndexOnAxis(TupleElementInterface tupleElement) {
        int index = -1;
        try {
            TupleInterface tuple = tupleElement.getTuple();
            index = OLAPActionProviderUtil.getIndexOnAxis(tupleElement, tuple.getElements(0, tuple.getTupleDepth()));
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return index;
    }

    public static int getIndexOnAxis(TupleElementInterface tupleElement, TupleElementInterface[] tupleElements) {
        int index = -1;
        try {
            int sss = 0;
            for (int y = 0; y < tupleElements.length; ++y) {
                sss = y == 0 ? 0 : (sss += tupleElements[y - 1].getSpan());
                if (!tupleElements[y].getLabel().equals(tupleElement.getLabel())) continue;
                index = sss;
                break;
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return index;
    }

    public static int getIndexOnAxis(String uniqueLevelName, OLAPDataSetInterface model, AxisInterface axis) {
        if (uniqueLevelName != null && model != null && axis != null) {
            try {
                String[] uniqueLevelNames = axis.getUniqueLevelNames();
                for (int j = 0; j < uniqueLevelNames.length; ++j) {
                    if (!uniqueLevelName.equals(uniqueLevelNames[j])) continue;
                    return j;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static List getAncestorAxisHeaders(String uniqueLvlName, OLAPDataSetInterface model) {
        ArrayList<String> ancestorLabels = new ArrayList<String>();
        if (model != null && uniqueLvlName != null && !(model instanceof OLAPDataSet)) {
            try {
                MetadataInterface metadata = model.getDatabaseMetadata();
                String cubeName = model.getCubeName();
                if (cubeName != null && metadata != null) {
                    TupleInterface[] tuples;
                    BusinessQuery bq;
                    if (model instanceof BusinessQueryProviderInterface && ((bq = ((BusinessQueryProviderInterface)model).getBusinessQuery()) == null || bq.getInputStructure().isRelational())) {
                        return ancestorLabels;
                    }
                    AxisInterface axis = OLAPActionProviderUtil.getLevelAxis(model, uniqueLvlName);
                    String uniqueName = null;
                    String dimName = null;
                    String hierName = null;
                    String[] levelNames = axis.getUniqueLevelNames();
                    String[] dimNames = axis.getDimensionNames();
                    for (int i = 0; i < levelNames.length; ++i) {
                        if (!levelNames[i].equals(uniqueLvlName)) continue;
                        dimName = dimNames[i];
                        hierName = axis.getHierarchyNames()[i];
                        break;
                    }
                    if (axis != null && (tuples = axis.getTuples(0, 1)) != null && tuples.length > 0) {
                        TupleElementInterface[] elements = tuples[0].getElements(0, -1);
                        block3: for (int i = elements.length - 1; i >= 0; --i) {
                            if (elements[i].isContextual()) continue;
                            String levelName = elements[i].getUniqueLevelName();
                            for (int j = 0; j < levelNames.length; ++j) {
                                if (!levelNames[j].equals(levelName)) continue;
                                if (!dimName.equals(dimNames[j])) continue block3;
                                uniqueName = elements[i].getName();
                                i = 0;
                                continue block3;
                            }
                        }
                    }
                    Filter filter = new Filter();
                    filter.setCubeName(cubeName);
                    filter.setDimensionName(dimName);
                    filter.setUniqueMemberName(uniqueName);
                    filter.setUniqueHierarchyName(hierName);
                    HierarchyInterface[] hiers = metadata.getHierarchies(filter);
                    int structure = hiers[0].getStructure();
                    if (structure == 2 || structure == 3) {
                        filter.setTreeOperator(Filter.PARENT_TREE_OPERATOR);
                        MemberInterface[] parents = metadata.getMembers(filter, 0, 1);
                        ancestorLabels.add(parents[0].getLevel().getLabel());
                    } else {
                        filter.setUniqueLevelName(uniqueLvlName);
                        LevelInterface[] levels = metadata.getLevels(filter);
                        int depth = levels[0].getDepth();
                        LevelInterface[] dimLevels = levels[0].getHierarchy().getLevels();
                        if (depth > 0 && depth < dimLevels.length) {
                            ancestorLabels.add(dimLevels[depth - 1].getLabel());
                        }
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return ancestorLabels;
    }

    public static int getLevelDepth(String uniqueLvlName, OLAPDataSetInterface model) {
        int depth = -1;
        if (uniqueLvlName != null && model != null) {
            try {
                String[] lvls;
                AxisInterface axis = OLAPActionProviderUtil.getLevelAxis(model, uniqueLvlName);
                if (axis != null && (lvls = axis.getUniqueLevelNames()) != null) {
                    for (int i = 0; i < lvls.length; ++i) {
                        if (!lvls[i].equals(uniqueLvlName)) continue;
                        return i;
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return depth;
    }

    public static AxisInterface getLevelAxis(OLAPDataSetInterface model, String uniqueLevelName) {
        try {
            int levelIndex = -1;
            if (uniqueLevelName != null) {
                ResultSetMetadataInterface rsm = model.getResultSetMetadata();
                AxisInterface[] axes = rsm.getAxes(0, -1);
                for (int i = 0; i < axes.length; ++i) {
                    String[] uniqueLevelNames = axes[i].getUniqueLevelNames();
                    for (int j = 0; j < uniqueLevelNames.length; ++j) {
                        if (!uniqueLevelName.equals(uniqueLevelNames[j])) continue;
                        levelIndex = j;
                        break;
                    }
                    if (levelIndex < 0) continue;
                    return axes[i];
                }
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return null;
    }

    @SASScope
    public static List getAvailableItemsInSameDimension(BusinessQuery bq, DataItem dataItem) {
        ArrayList<DataItem> availableItemsInSameDimension = new ArrayList<DataItem>();
        if (dataItem == null || bq == null || bq.getInputStructure().isRelational()) {
            return availableItemsInSameDimension;
        }
        try {
            String dataItemDimensionName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)bq.getBusinessModel(), (DataItem)dataItem);
            List allDataItems = Utils.filterObjects((BusinessModel)bq.getBusinessModel(), (boolean)true, DataItem.class);
            int numDataItems = allDataItems.size();
            for (int i = 0; i < numDataItems; ++i) {
                String itemDimensionName;
                DataItem item = (DataItem)allDataItems.get(i);
                if (dataItem.equals(item) || item instanceof DataItemReference && dataItem.equals(((DataItemReference)item).getBaseDataItem()) || !dataItemDimensionName.equals(itemDimensionName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)bq.getBusinessModel(), (DataItem)item))) continue;
                availableItemsInSameDimension.add(item);
            }
            return availableItemsInSameDimension;
        }
        catch (MetadataException metadataException) {
            return availableItemsInSameDimension;
        }
    }
}

