/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.olaptableview;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.support.BaseActionProviderSupport;
import com.sas.actionprovider.support.DynamicActionCountInterface;
import com.sas.codepolicy.SASScope;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import java.util.List;

@SASScope(value="ALL")
public abstract class BaseOLAPDrillStateSupport
extends BaseActionProviderSupport
implements DynamicActionCountInterface {
    static final String RB_KEY = "BaseOLAPDrillStateSupport.";
    public static final String DRILL_STATE_AREA = "DRILL_STATE_AREA";
    public static final String DRILL_TO_LEVEL_ACTION = "DRILL_TO_LEVEL_ACTION";
    public static final String DRILL_DOWN_MEMBER_ACTION = "DRILL_DOWN_MEMBER_ACTION";

    public BaseOLAPDrillStateSupport(Class actionClass) {
        super(actionClass);
    }

    public void initialize() {
        this.createDefaultActions();
    }

    protected void createDefaultActions() {
        this.addDefaultAction(this.newActionInstance(DRILL_STATE_AREA, DRILL_TO_LEVEL_ACTION), DRILL_STATE_AREA);
        this.addDefaultAction(this.newActionInstance(DRILL_STATE_AREA, DRILL_DOWN_MEMBER_ACTION), DRILL_STATE_AREA);
    }

    public int getActionCount(ActionSupportFilter actionFilter, String actionType) {
        int actionCount = 0;
        boolean isAllLevelCase = (Boolean)actionFilter.getAttribute("isAllLevel");
        List drillStateLabels = (List)actionFilter.getAttribute("drillStateLabels");
        if (drillStateLabels != null && !drillStateLabels.isEmpty()) {
            if (actionType == DRILL_TO_LEVEL_ACTION) {
                actionCount = isAllLevelCase ? 2 : 1;
            } else if (actionType == DRILL_DOWN_MEMBER_ACTION) {
                actionCount = isAllLevelCase ? drillStateLabels.size() - 2 : drillStateLabels.size() - 1;
            }
        }
        return actionCount;
    }

    protected boolean isNavigatable(Object model, TupleElementInterface tupleElement) {
        if (model instanceof BusinessQueryProviderInterface && tupleElement != null) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            BusinessModel businessModel = businessQuery.getBusinessModel();
            if (businessModel == null) {
                return false;
            }
            StructureOfData structure = businessModel.getStructure();
            if (structure.isOLAP()) {
                try {
                    DataItem dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, null, (Object)tupleElement, (int)1);
                    if (dataItem != null) {
                        return dataItem.isActionSupported(DataItemActionType.STEP_NAVIGATE);
                    }
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

