/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.strategies.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.strategies.olap.BaseOLAPStrategy;
import com.sas.actionprovider.strategies.olap.RB;
import com.sas.actionprovider.util.olap.OLAPActionProviderUtil;
import com.sas.actionprovider.util.olap.OLAPActionUtil;
import com.sas.actionprovider.util.olap.OLAPRoles;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import java.util.List;
import java.util.Locale;

@SASScope
public class SwapDataItemLabelStrategy
extends BaseOLAPStrategy {
    static final String RB_KEY = "OLAPStrategy.";

    public SwapDataItemLabelStrategy() {
    }

    public SwapDataItemLabelStrategy(boolean swing, OLAPActionUtil util) {
        super(swing, util);
    }

    @Override
    protected void initializeActionAttributes(BaseAction action, String areaType, Locale locale) {
        super.initializeActionAttributes(action, areaType, locale);
        action.putValue("Name", null);
    }

    public void setLocaleDependentDefaultAttributes(BaseAction action, String areaType, Locale locale) {
        super.setLocaleDependentDefaultAttributes(action, areaType, locale);
        action.putValue("Name", (Object)RB.getStringResource(RB_KEY, "changeDataItem.txt", locale));
    }

    public int getActionStatus(BaseAction action, ActionSupportFilter filter) {
        if (filter.getAttribute("isMeasure") == Boolean.TRUE) {
            return 16;
        }
        Object model = filter.getAttribute("model");
        if (!(model instanceof BusinessQueryProviderInterface)) {
            return 16;
        }
        BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        DataItem dataItem = (DataItem)filter.getAttribute("dataItem");
        if (businessQuery == null || dataItem == null) {
            return 16;
        }
        try {
            OLAPRoles olapRoles = new OLAPRoles(businessQuery);
            List availableItems = olapRoles.getAvailableDataItems(businessQuery);
            filter.setAttribute("availableDataItems", (Object)availableItems);
            List availableItemsSameDimension = OLAPActionProviderUtil.getAvailableItemsInSameDimension(businessQuery, dataItem);
            filter.setAttribute("availableDataItemsSameDimension", (Object)availableItemsSameDimension);
            if (availableItems != null && !availableItems.isEmpty() || availableItemsSameDimension != null && !availableItemsSameDimension.isEmpty()) {
                return 0;
            }
        }
        catch (AttributeSetException attributeSetException) {
            // empty catch block
        }
        return 16;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addDynamicValueInfo("dataItemLabel", "getDataItemLabel", null);
    }
}

