/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.strategies.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.strategies.olap.BaseOLAPModelStrategy;
import com.sas.actionprovider.util.olap.OLAPActionUtil;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import java.util.Locale;

@SASScope(value="ALL")
public abstract class BaseDataCellStrategy
extends BaseOLAPModelStrategy {
    public static final String TUPLE_ELEMENT = "tupleElement";
    public static final String CELL_ORDINAL = "cellOrdinal";
    public static final String TUPLE_ELEMENTS = "tupleElements";
    public static final String COLUMN_AXIS = "columnAxis";
    public static final String ROW_AXIS = "rowAxis";
    public static final String ROW_TUPLES = "rowTuples";
    public static final String COLUMN_TUPLES = "columnTuples";
    public static final String ROW_INDEX = "rowIndex";
    public static final String COLUMN_INDEX = "columnIndex";
    public static final String DATA_VALUE = "dataValue";

    public BaseDataCellStrategy() {
    }

    public BaseDataCellStrategy(boolean swing, OLAPActionUtil util) {
        super(swing, util);
    }

    @Override
    protected void initializeActionAttributes(BaseAction action, String areaType, Locale locale) {
        super.initializeActionAttributes(action, areaType, locale);
        if (this.isSwing()) {
            action.putValue(TUPLE_ELEMENT, null);
        } else {
            action.putValue(ROW_TUPLES, null);
            AttributeDescriptorInterface descriptor = action.getAttributeDescriptor(ROW_TUPLES);
            descriptor.setVisible(false);
            action.putValue(COLUMN_TUPLES, null);
            descriptor = action.getAttributeDescriptor(COLUMN_TUPLES);
            descriptor.setVisible(false);
            action.putValue(ROW_INDEX, null);
            descriptor = action.getAttributeDescriptor(ROW_INDEX);
            descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
            action.putValue(COLUMN_INDEX, null);
            descriptor = action.getAttributeDescriptor(COLUMN_INDEX);
            descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
            action.putValue(DATA_VALUE, null);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addDynamicValueInfo(ROW_AXIS, null, null);
        this.addDynamicValueInfo(COLUMN_AXIS, null, null);
        if (this.isSwing()) {
            this.addDynamicValueInfo(TUPLE_ELEMENT, null, null);
            this.addDynamicValueInfo(CELL_ORDINAL, null, null);
            this.addDynamicValueInfo(TUPLE_ELEMENTS, null, null);
        } else {
            this.addDynamicValueInfo(ROW_TUPLES, null, null);
            this.addDynamicValueInfo(COLUMN_TUPLES, null, null);
            this.addDynamicValueInfo(ROW_INDEX, "getStringRowIndex", null);
            this.addDynamicValueInfo(COLUMN_INDEX, "getStringColumnIndex", null);
        }
    }

    public int getActionStatus(BaseAction action, ActionSupportFilter filter) {
        int status = super.getActionStatus(action, filter);
        return status |= OLAPActionUtil.validateDataCellArea(filter);
    }
}

