/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.JobDefinitionInfo;
import com.sas.scheduler.model.JobDependency;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLFactory {
    public static final String XML_TAG_TOP = "xmlFlowDef";
    public static final String XML_Name_Tag = "Name";
    public static final String XML_Id_Tag = "Id";
    public static final String XML_Description_Tag = "Description";
    public static final String XML_Type_Tag = "Type";
    public static final String XML_Value_Tag = "Value";
    public static final String XML_TAG_FLOW = "FlowDef";
    public static final String XML_TAG_SCHEDULER = "Scheduler";
    public static final String XML_TAG_TRIGGERS = "TriggerEvents";
    public static final String XML_TAG_DEPENDENCY = "Dependencies";
    public static final String XML_TAG_PROPERTIES = "Properties";
    public static final String XML_ClassId_Tag = "ClassId";
    public static final String XML_Host_Tag = "Host";
    public static final String XML_Port_Tag = "Port";
    public static final String XML_JobExecutionProviderType_Tag = "JobExecutionProvider";
    public static final String XML_RestAPIPath_Tag = "RestAPIPath";
    public static final String XML_FlowOrchHost_Tag = "FlowOrchHost";
    public static final String XML_FlowOrchPort_Tag = "FlowOrchPort";
    public static final String XML_FlowOrchCommand_Tag = "FlowOrchCommand";
    public static final String XML_TriggerCommand_Tag = "TriggerCommand";
    public static final String XML_AuthInfoPath_Tag = "AuthInfoPath";
    public static final String XML_FlowDefId_Tag = "FlowDefId";
    public static final String XML_Type_JobDef_Tag = "JobDef";
    public static final String XML_Type_JobDef_Cmd_Tag = "JobCmdLine";
    public static final String XML_Type_JobDef_User_Tag = "UserName";
    public static final String XML_Dependency_Tag = "Dependencies";
    public static final String XML_Reference_Tag = "Reference";
    public static final String XML_Events_Tag = "Events";
    public static final String XML_Combination_Tag = "CombinationType";
    public static final String XML_Event_Tag = "Event";
    public static final String XML_Type_Successor_Tag = "Successor";
    public static final String XML_Type_Job_Tag = "Job";
    public static final String XML_Type_Time_Tag = "Time";
    public static final String XML_Type_File_Tag = "File";
    public static final String XML_Job_Tag = "job";
    public static final String XML_Time_Tag = "time";
    public static final String XML_File_Tag = "expression";
    public static final String XML_StartDate_Tag = "startDate";
    public static final String XML_StartDate = "start";
    public static final String XML_EndDate_Tag = "endDate";
    public static final String XML_EndDate = "end";
    public static final String XML_SkipCount_Tag = "skipCount";
    public static final String XML_SkipCount = "count";
    public static final String XML_DateList_Tag = "dateList";
    public static final String XML_Date_Year = "year";
    public static final String XML_Date_Month = "month";
    public static final String XML_Date_Day = "day";
    public static final String XML_Date_Tag = "date";
    public static final String XML_Minute_Tag = "minutely";
    public static final String XML_Hourly_Tag = "hourly";
    public static final String XML_Daily_Tag = "daily";
    public static final String XML_Only_Weekdays = "onlyWeekDays";
    public static final String XML_Weekly_Tag = "weekly";
    public static final String XML_Days_To_Run = "daysToRun";
    public static final String XML_Monthly_Tag = "monthly";
    public static final String XML_Day_Of_Week = "dayOfWeek";
    public static final String XML_Which_Week = "whichWeek";
    public static final String XML_Yearly_Tag = "yearly";
    public static final String XML_Month_of_Year = "month";
    public static final String XML_Day_of_Month = "day";
    public static final String XML_Opaque_Tag = "opaque";
    public static final String XML_Scheduler = "scheduler";
    public static final String XML_Display = "display";
    public static final String XML_Name = "name";
    public static final String XML_Expression = "expression";
    public static final String XML_Properties_Flow_Tag = "flowproperties";
    public static final String XML_emailNotification_Tag = "emailNotification";
    public static final String XML_emailAddress_Tag = "emailAddress";
    public static final String XML_completionLevel_Tag = "completionLevel";
    public static final String XML_completionSelectedJobNames_Tag = "completionSelectedJobNames";
    public static final String XML_endBehavior_Tag = "endBehavior";
    public static final String XML_exitcodeBehavior_Tag = "exitcodeBehavior";
    public static final String XML_exclusive_Tag = "exclusive";
    public static final String XML_schedulerQueue_Tag = "schedulerQueue";
    public static final String XML_Properties_DefaultJob_Tag = "defaultjobproperties";
    public static final String XML_jobDefaultEmailNotification_Tag = "emailNotification";
    public static final String XML_jobDefaultEmailAddress_Tag = "emailAddress";
    public static final String XML_jobDefaultPriority_Tag = "priority";
    public static final String XML_jobDefaultEnvironmentVariables_Tag = "environmentVariables";
    public static final String XML_jobDefaultExceptionHandlers_Tag = "exceptionHandlers";

    public static String generateXML(FlowInfo info) {
        return XMLFactory.generateXML(info, true, false, false);
    }

    public static String generateXML(FlowInfo info, boolean exportFormat) {
        return XMLFactory.generateXML(info, true, false, exportFormat);
    }

    public static String generateXML(FlowInfo info, boolean topDef, boolean provideTrigger) {
        return XMLFactory.generateXML(info, topDef, provideTrigger, false);
    }

    public static String generateXML(FlowInfo info, boolean topDef, boolean provideTrigger, boolean exportFormat) {
        int i;
        StringBuffer xmlbuffer = new StringBuffer();
        if (topDef) {
            xmlbuffer.append("<xmlFlowDef>\n");
        }
        xmlbuffer.append("<FlowDef Name=\"" + info.getName() + "\" " + XML_Id_Tag + "=\"" + info.getId() + "\" " + XML_FlowDefId_Tag + "=\"" + info.getFlowDefinitionIdDataBinding() + "\" " + XML_Description_Tag + "=\"" + GeneralUtilities.replaceString(info.getDescription(), "\"", "'") + "\" >\n");
        if (topDef) {
            SchedulerServerInfo sinfo = info.getScheduler();
            if (sinfo.nameDataBinding != null && sinfo.classidDataBinding != null) {
                xmlbuffer.append("<Scheduler Name=\"" + sinfo.nameDataBinding + "\" " + XML_ClassId_Tag + "=\"" + sinfo.classidDataBinding + "\" " + XML_Id_Tag + "=\"" + sinfo.getId() + "\" ");
                xmlbuffer.append("/>\n");
            }
        }
        if (provideTrigger) {
            String xml;
            TriggerEventInfo trigger = info.getActiveTriggerDataBinding();
            String triggerId = info.getTriggerId() != null ? info.getTriggerId() : "";
            xmlbuffer.append("<TriggerEvents Value=\"" + info.getTriggerType() + "\" " + XML_Id_Tag + "=\"" + triggerId + "\">\n");
            if (trigger != null && (xml = trigger.generateXML()) != null) {
                xmlbuffer.append(xml);
            }
            xmlbuffer.append("</TriggerEvents>\n");
        }
        Vector<JobDefinitionInfo> jobDefs = new Vector<JobDefinitionInfo>();
        List<DisplayInfo> jobs = info.getJobs();
        int numSteps = jobs == null ? 0 : jobs.size();
        for (int i2 = 0; i2 < numSteps; ++i2) {
            DisplayInfo j = jobs.get(i2);
            JobDefinitionInfo definition = null;
            DisplayInfo deps = null;
            if (j instanceof FlowInfo || j instanceof JobInfo && ((JobInfo)j).isSubflow()) {
                FlowInfo subflow = (FlowInfo)j;
                xmlbuffer.append(XMLFactory.generateXML(subflow, false, false, exportFormat));
                deps = info.getEvent(subflow);
                definition = new JobDefinitionInfo(subflow.getName(), subflow.getId(), 1, "", null);
                definition.setDescription(subflow.getDescription());
            } else if (j instanceof JobInfo) {
                JobInfo job = (JobInfo)j;
                deps = info.getEvent(job);
                definition = new JobDefinitionInfo(job.getName(), job.getId(), 0, job.getCommandLine(), job.getRunAsDataBinding());
                definition.setDescription(job.getDescription());
            }
            if (definition == null) continue;
            if (deps != null && deps instanceof AbstractEventInterface) {
                definition.addDependency((AbstractEventInterface)((Object)deps));
            }
            jobDefs.add(definition);
        }
        int jobDefsize = jobDefs.size();
        for (i = 0; i < jobDefsize; ++i) {
            String xml = ((JobDefinitionInfo)jobDefs.get(i)).generateXML();
            if (xml == null) continue;
            xmlbuffer.append(xml);
        }
        for (i = 0; i < jobDefsize; ++i) {
            JobDefinitionInfo jobdef = (JobDefinitionInfo)jobDefs.get(i);
            String xml = jobdef.generateDependenciesXML(exportFormat);
            if (xml == null) continue;
            xmlbuffer.append(xml);
        }
        xmlbuffer.append("<Properties>\n");
        String emailNotification_xml = "";
        String emailAddress_xml = "";
        String completionLevel_xml = "";
        String completionSelectedJobNames_xml = "";
        String endBehavior_xml = "";
        String exitcodeBehavior_xml = "";
        String exclusive_xml = "";
        String schedulerQueue_xml = "";
        if (info.isNotifyEmail()) {
            emailNotification_xml = " emailNotification=\"" + info.getEmailNotificationDataBinding() + "\"";
            emailAddress_xml = " emailAddress=\"" + info.getEmailAddressDataBinding() + "\"";
        }
        if (info.completionLevel() != 1) {
            completionLevel_xml = " completionLevel=\"" + info.getCompletionLevelDataBinding() + "\"";
            String value = null;
            List<String> cjobs = info.getCompletionSelectedJobNamesDataBinding();
            for (int i3 = 0; i3 < cjobs.size(); ++i3) {
                String o = cjobs.get(i3);
                value = value == null ? o : value + ";" + o;
            }
            completionSelectedJobNames_xml = " completionSelectedJobNames=\"" + value + "\"";
        }
        if (info.getEndBehaviorDataBinding() != 0) {
            endBehavior_xml = " endBehavior=\"" + info.getEndBehaviorDataBinding() + "\"";
        }
        exitcodeBehavior_xml = " exitcodeBehavior=\"" + info.getExitcodeBehaviorDataBinding() + "\"";
        if (info.isExclusiveDataBinding()) {
            exclusive_xml = " exclusive=\"" + info.getExitcodeBehaviorDataBinding() + "\"";
        }
        if (info.getSchedulerQueue() != null) {
            schedulerQueue_xml = " schedulerQueue=\"" + info.getSchedulerQueue() + "\"";
        }
        xmlbuffer.append("<flowproperties" + emailNotification_xml + emailAddress_xml + completionLevel_xml + completionSelectedJobNames_xml + endBehavior_xml + exitcodeBehavior_xml + exclusive_xml + schedulerQueue_xml + " />\n");
        String jobDefaultEmailNotification_xml = "";
        String jobDefaultEmailAddress_xml = "";
        String jobDefaultPriority_xml = "";
        String jobDefaultEnvironmentVariables_xml = "";
        if (info.isJobDefaultNotifyEmail()) {
            jobDefaultEmailNotification_xml = " emailNotification=\"" + info.getJobDefaultEmailNotificationDataBinding() + "\"";
            jobDefaultEmailAddress_xml = " emailAddress=\"" + info.getJobDefaultEmailAddressDataBinding() + "\"";
        }
        if (info.getJobDefaultPriority() != -1) {
            jobDefaultPriority_xml = " priority=\"" + info.getJobDefaultPriority() + "\"";
        }
        if (info.getJobDefaultEnvironmentVariables() != null) {
            jobDefaultEnvironmentVariables_xml = " environmentVariables=\"" + info.getJobDefaultEnvironmentVariables() + "\"";
        }
        xmlbuffer.append("<defaultjobproperties" + jobDefaultEmailNotification_xml + jobDefaultEmailAddress_xml + jobDefaultPriority_xml + jobDefaultEnvironmentVariables_xml + " />\n");
        xmlbuffer.append("</Properties>\n");
        xmlbuffer.append("</FlowDef>\n");
        if (topDef) {
            xmlbuffer.append("</xmlFlowDef>\n");
        }
        return xmlbuffer.toString();
    }

    public static FlowInfo initFlowInfoFromXML(String flowXML) throws SchedulerException {
        Vector<FlowInfo> flows = new Vector<FlowInfo>();
        Document doc = GeneralUtilities.parseXML(flowXML);
        Node mainNode = doc.getElementsByTagName(XML_TAG_TOP).item(0);
        NodeList nodes = null;
        nodes = mainNode != null ? mainNode.getChildNodes() : doc.getElementsByTagName(XML_TAG_FLOW);
        int numNodes = nodes.getLength();
        for (int j = 0; j < numNodes; ++j) {
            Node node = nodes.item(j);
            if (node.getNodeName().compareTo(XML_TAG_FLOW) != 0) continue;
            FlowInfo flow = XMLFactory.parseFlowInfoFromNode(node);
            flows.add(flow);
        }
        return flows.size() > 0 ? (FlowInfo)flows.get(0) : null;
    }

    private static FlowInfo parseFlowInfoFromNode(Node node) throws SchedulerException {
        boolean embeddedSubflow = false;
        FlowInfo info = new FlowInfo();
        ArrayList<DisplayInfo> jobList = new ArrayList<DisplayInfo>();
        HashMap<String, DisplayInfo> jobs = new HashMap<String, DisplayInfo>();
        ArrayList<JobDependency> jobDepList = new ArrayList<JobDependency>();
        NamedNodeMap map = node.getAttributes();
        info.setName(map.getNamedItem(XML_Name_Tag).getNodeValue());
        info.setId(map.getNamedItem(XML_Id_Tag).getNodeValue());
        Node n = map.getNamedItem(XML_FlowDefId_Tag);
        if (n != null) {
            info.setFlowDefinitionIdDataBinding(n.getNodeValue());
        }
        info.setDescription(map.getNamedItem(XML_Description_Tag).getNodeValue());
        NodeList cnodes = node.getChildNodes();
        int numCNodes = cnodes.getLength();
        for (int x = 0; x < numCNodes; ++x) {
            Node cnode = cnodes.item(x);
            String tagname = cnode.getNodeName();
            NamedNodeMap cmap = cnode.getAttributes();
            if (tagname.compareTo(XML_TAG_SCHEDULER) == 0) {
                String value;
                String schName = cmap.getNamedItem(XML_Name_Tag).getNodeValue();
                String schClassID = cmap.getNamedItem(XML_ClassId_Tag).getNodeValue();
                String schID = cmap.getNamedItem(XML_Id_Tag).getNodeValue();
                SchedulerServerInfo sch = new SchedulerServerInfo(schName, schClassID);
                sch.setId(schID);
                Node attr = cmap.getNamedItem(XML_Description_Tag);
                if (attr != null && (value = attr.getNodeValue()) != null) {
                    sch.setDescription(XMLFactory.formatQuoteString(value));
                }
                if ((attr = cmap.getNamedItem(XML_Host_Tag)) != null && (value = attr.getNodeValue()) != null) {
                    sch.setHostDataBinding(XMLFactory.formatQuoteString(value));
                }
                if ((attr = cmap.getNamedItem(XML_Port_Tag)) != null && (value = attr.getNodeValue()) != null) {
                    sch.setPortDataBinding(XMLFactory.formatQuoteString(value));
                }
                if ((attr = cmap.getNamedItem(XML_RestAPIPath_Tag)) != null && (value = attr.getNodeValue()) != null) {
                    sch.setRestAPIPathDataBinding(XMLFactory.formatQuoteString(value));
                }
                if ((attr = cmap.getNamedItem(XML_FlowOrchHost_Tag)) != null && (value = attr.getNodeValue()) != null) {
                    sch.setFlowOrchHostDataBinding(XMLFactory.formatQuoteString(value));
                }
                if ((attr = cmap.getNamedItem(XML_FlowOrchPort_Tag)) != null && (value = attr.getNodeValue()) != null) {
                    sch.setFlowOrchPortDataBinding(XMLFactory.formatQuoteString(value));
                }
                if ((attr = cmap.getNamedItem(XML_FlowOrchCommand_Tag)) != null && (value = attr.getNodeValue()) != null) {
                    sch.setFlowOrchCommandDataBinding(XMLFactory.formatQuoteString(value));
                }
                if ((attr = cmap.getNamedItem(XML_AuthInfoPath_Tag)) != null && (value = attr.getNodeValue()) != null) {
                    sch.setAuthInfoDataBinding(XMLFactory.formatQuoteString(value));
                }
                if ((attr = cmap.getNamedItem(XML_JobExecutionProviderType_Tag)) != null && (value = attr.getNodeValue()) != null) {
                    sch.setJobExecutionProvider(XMLFactory.formatQuoteString(value));
                }
                info.setScheduler(sch);
                continue;
            }
            if (tagname.compareTo(XML_TAG_TRIGGERS) == 0) {
                ArrayList<TriggerEventInfo> triggerEventInfoList = new ArrayList<TriggerEventInfo>();
                NodeList jnodes = cnode.getChildNodes();
                int numJNodes = jnodes.getLength();
                for (int i = 0; i < numJNodes; ++i) {
                    TriggerEventInfo triggerEventInfo;
                    Node jnode = jnodes.item(i);
                    if (jnode.getNodeName().equals(XML_Event_Tag)) {
                        triggerEventInfo = new TriggerEventInfo();
                        triggerEventInfo.initFromNode(jnode);
                        triggerEventInfoList.add(triggerEventInfo);
                        continue;
                    }
                    if (!jnode.getNodeName().equals(XML_Events_Tag)) continue;
                    triggerEventInfo = new TriggerEventInfo();
                    NamedNodeMap jmap = jnode.getAttributes();
                    String combo = jmap.getNamedItem(XML_Combination_Tag).getNodeValue();
                    triggerEventInfo.initFromNode(jnode, combo);
                    triggerEventInfoList.add(triggerEventInfo);
                }
                if (triggerEventInfoList.size() <= 0) continue;
                info.setAvailableTriggersDataBinding(triggerEventInfoList);
                continue;
            }
            if (tagname.compareTo(XML_TAG_FLOW) == 0) {
                embeddedSubflow = true;
                FlowInfo subflow = XMLFactory.parseFlowInfoFromNode(cnode);
                jobList.add(subflow);
                jobs.put(subflow.getName(), subflow);
                continue;
            }
            if (tagname.compareTo(XML_Type_JobDef_Tag) == 0) {
                JobInfo job = JobDefinitionInfo.initJobFromNode(cnode);
                if (embeddedSubflow && job.isSubflow()) continue;
                jobList.add(job);
                jobs.put(job.getName(), job);
                continue;
            }
            if (tagname.compareTo("Dependencies") == 0) {
                JobDependency dep = JobDefinitionInfo.initDepFromNode(jobs, cnode);
                jobDepList.add(dep);
                continue;
            }
            if (tagname.compareTo(XML_TAG_PROPERTIES) != 0) continue;
            NodeList snodes = cnode.getChildNodes();
            int numSNodes = snodes.getLength();
            for (int y = 0; y < numSNodes; ++y) {
                Node t;
                NamedNodeMap sattrs;
                Node snode = snodes.item(y);
                String stagname = snode.getNodeName();
                if (stagname.compareTo(XML_Properties_Flow_Tag) == 0) {
                    String sj;
                    sattrs = snode.getAttributes();
                    t = sattrs.getNamedItem("emailNotification");
                    if (t != null) {
                        info.setEmailNotificationDataBinding(Integer.valueOf(t.getNodeValue()));
                    }
                    if ((t = sattrs.getNamedItem("emailAddress")) != null) {
                        info.setEmailAddressDataBinding(t.getNodeValue());
                    }
                    if ((t = sattrs.getNamedItem(XML_completionLevel_Tag)) != null) {
                        info.setCompletionLevelDataBinding(Integer.valueOf(t.getNodeValue()));
                    }
                    if ((t = sattrs.getNamedItem(XML_completionSelectedJobNames_Tag)) != null && (sj = t.getNodeValue()) != null) {
                        info.setCompletionSelectedJobNamesDataBinding(Arrays.asList(sj.split(";")));
                    }
                    if ((t = sattrs.getNamedItem(XML_endBehavior_Tag)) != null) {
                        info.setEndBehaviorDataBinding(Integer.valueOf(t.getNodeValue()));
                    }
                    if ((t = sattrs.getNamedItem(XML_exitcodeBehavior_Tag)) != null) {
                        info.setExitcodeBehaviorDataBinding(Integer.valueOf(t.getNodeValue()));
                    }
                    if ((t = sattrs.getNamedItem(XML_exclusive_Tag)) != null) {
                        info.setExclusive(Boolean.valueOf(t.getNodeValue()));
                    }
                    if ((t = sattrs.getNamedItem(XML_schedulerQueue_Tag)) == null) continue;
                    info.setSchedulerQueue(t.getNodeValue());
                    continue;
                }
                if (stagname.compareTo(XML_Properties_DefaultJob_Tag) != 0) continue;
                sattrs = snode.getAttributes();
                t = sattrs.getNamedItem("emailNotification");
                if (t != null) {
                    info.setJobDefaultEmailNotificationDataBinding(Integer.valueOf(t.getNodeValue()));
                }
                if ((t = sattrs.getNamedItem("emailAddress")) != null) {
                    info.setJobDefaultEmailAddressDataBinding(t.getNodeValue());
                }
                if ((t = sattrs.getNamedItem(XML_jobDefaultPriority_Tag)) != null) {
                    info.setJobDefaultPriority(Integer.valueOf(t.getNodeValue()));
                }
                if ((t = sattrs.getNamedItem(XML_jobDefaultEnvironmentVariables_Tag)) == null) continue;
                info.setJobDefaultEnvironmentVariables(t.getNodeValue());
            }
        }
        info.setJobsDataBinding(jobList);
        info.setJobDependenciesDataBinding(jobDepList);
        return info;
    }

    private static String formatQuoteString(String origString) {
        return origString.replace("&quot;", "\"").replace("\\'", "'");
    }
}

