/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="WeeklyRecurrence", propOrder={"dayOfWeekDataBinding"})
public class WeeklyRecurrence
extends AbstractRecurrence
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="DayOfWeek")
    protected int dayOfWeekDataBinding = 1;
    public static final int DAY_MONDAY = 1;
    public static final int DAY_TUESDAY = 2;
    public static final int DAY_WEDNESDAY = 4;
    public static final int DAY_THURSDAY = 8;
    public static final int DAY_FRIDAY = 16;
    public static final int DAY_SATURDAY = 32;
    public static final int DAY_SUNDAY = 64;
    static final String XML_Weekly_Tag = "weekly";
    static final String XML_Days_To_Run = "daysToRun";

    public int getDayOfWeekDataBinding() {
        return this.dayOfWeekDataBinding;
    }

    public void setDayOfWeekDataBinding(int value) {
        this.dayOfWeekDataBinding = value;
    }

    public boolean setDaysToRun(int dayMask) {
        if (dayMask < 1 || dayMask > 127) {
            return false;
        }
        this.dayOfWeekDataBinding = dayMask;
        return true;
    }

    public int getDaysToRun() {
        return this.dayOfWeekDataBinding;
    }

    @Override
    public String toString(Locale locale) {
        String strClassName = WeeklyRecurrence.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        ResourceBundle bundle = ResourceBundle.getBundle(strBundlePath, locale);
        String expression = "";
        Calendar startTime = this.getStartDate();
        Calendar endTime = this.getEndDate();
        int skip = this.getSkipCount();
        List<String> days = this.getDayList(bundle);
        String[] dayStrings = new String[days.size()];
        int index = 0;
        Iterator<String> iter = days.iterator();
        while (iter.hasNext()) {
            String runDay;
            dayStrings[index] = runDay = iter.next();
            ++index;
        }
        String dayListString = AbstractRecurrence.generateLocaleStringFromList(locale, dayStrings, "WeeklyRecurrence.toString.List.First.fmt.txt", "WeeklyRecurrence.toString.List.Middle.fmt.txt", "WeeklyRecurrence.toString.List.Last.fmt.txt");
        int count = this.getDaysCount();
        if (skip == 1) {
            if (startTime == null) {
                if (endTime == null) {
                    if (count == 7) {
                        expression = bundle.getString("WeeklyRecurrence.toString.All.txt");
                    } else {
                        Object[] args = new Object[]{dayListString};
                        expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.List.Days.fmt.txt", (Object[])args);
                    }
                } else if (count == 7) {
                    Object[] args = new Object[]{WeeklyRecurrence.dateToString(endTime, locale)};
                    expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.All.End.fmt.txt", (Object[])args);
                } else {
                    Object[] args = new Object[]{dayListString, WeeklyRecurrence.dateToString(endTime, locale)};
                    expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.List.DaysEnd.fmt.txt", (Object[])args);
                }
            } else if (endTime == null) {
                if (count == 7) {
                    Object[] args = new Object[]{WeeklyRecurrence.dateToString(startTime, locale)};
                    expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.All.Start.fmt.txt", (Object[])args);
                } else {
                    Object[] args = new Object[]{dayListString, WeeklyRecurrence.dateToString(startTime, locale)};
                    expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.List.DaysStart.fmt.txt", (Object[])args);
                }
            } else if (count == 7) {
                Object[] args = new Object[]{WeeklyRecurrence.dateToString(startTime, locale), WeeklyRecurrence.dateToString(endTime, locale)};
                expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.All.StartEnd.fmt.txt", (Object[])args);
            } else {
                Object[] args = new Object[]{dayListString, WeeklyRecurrence.dateToString(startTime, locale), WeeklyRecurrence.dateToString(endTime, locale)};
                expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.List.DaysStartEnd.fmt.txt", (Object[])args);
            }
        } else if (endTime == null) {
            if (count == 7) {
                Object[] args = new Object[]{String.valueOf(skip), WeeklyRecurrence.dateToString(startTime, locale)};
                expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.All.SkipStart.fmt.txt", (Object[])args);
            } else {
                Object[] args = new Object[]{String.valueOf(skip), dayListString, WeeklyRecurrence.dateToString(startTime, locale)};
                expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.List.SkipDaysStart.fmt.txt", (Object[])args);
            }
        } else if (count == 7) {
            Object[] args = new Object[]{String.valueOf(skip), WeeklyRecurrence.dateToString(startTime, locale), WeeklyRecurrence.dateToString(endTime, locale)};
            expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.All.SkipStartEnd.fmt.txt", (Object[])args);
        } else {
            Object[] args = new Object[]{String.valueOf(skip), dayListString, WeeklyRecurrence.dateToString(startTime, locale), WeeklyRecurrence.dateToString(endTime, locale)};
            expression = Message.format((ResourceBundle)bundle, (String)"WeeklyRecurrence.toString.List.SkipDaysStartEnd.fmt.txt", (Object[])args);
        }
        return expression;
    }

    @Override
    public List<Calendar> getNextDates(Calendar queryDate, Calendar endQueryDate, int count) {
        ArrayList<Calendar> results;
        block11: {
            results = new ArrayList<Calendar>();
            if (endQueryDate == null || queryDate == null || count < 0) {
                return results;
            }
            Calendar calStart = this.getStartDate();
            Calendar currentDate = (Calendar)queryDate.clone();
            int firstDayOfWeek = currentDate.getFirstDayOfWeek();
            if (calStart != null) {
                if (AbstractRecurrence.isBeforeByDay(currentDate, calStart)) {
                    currentDate = (Calendar)calStart.clone();
                } else if (this.getSkipCount() > 1) {
                    currentDate = (Calendar)calStart.clone();
                    while (currentDate.get(7) != firstDayOfWeek) {
                        currentDate.add(5, -1);
                    }
                    this.moveCurrentDateJustBeforeQueryDate(currentDate, queryDate, this.getSkipCount() * 7, 5);
                }
            }
            while (currentDate.get(7) != firstDayOfWeek) {
                currentDate.add(5, -1);
            }
            do {
                for (int i = 0; i < 7; ++i) {
                    if (AbstractRecurrence.isAfterByDay(currentDate, endQueryDate)) break block11;
                    int currentCalendarDay = currentDate.get(7);
                    int myDayOfWeek = WeeklyRecurrence.getWeekDayFromCalendarDay(currentCalendarDay);
                    if ((this.dayOfWeekDataBinding & myDayOfWeek) > 0 && !AbstractRecurrence.isBeforeByDay(currentDate, queryDate) && this.isDateInRange(currentDate)) {
                        results.add((Calendar)currentDate.clone());
                        if (count > 0 && results.size() >= count) break block11;
                    }
                    currentDate.add(5, 1);
                }
                currentDate.add(5, 7 * (this.getSkipCount() - 1));
            } while (!this.isDateAfterRange(currentDate));
        }
        return results;
    }

    @Override
    public boolean includesDate(Calendar queryDate) throws InvalidRecurrenceException {
        if (!this.isDateInRange(queryDate)) {
            return false;
        }
        int dayOfWeek = queryDate.get(7);
        if ((this.dayOfWeekDataBinding & (dayOfWeek = WeeklyRecurrence.getWeekDayFromCalendarDay(dayOfWeek))) == 0) {
            return false;
        }
        if (this.getSkipCount() > 1) {
            return super.includesDate(queryDate);
        }
        return true;
    }

    @Override
    public IRecurrenceInfo copy() {
        WeeklyRecurrence recurrence = new WeeklyRecurrence();
        recurrence.copyFrom(this);
        return recurrence;
    }

    protected static int getCalendarWeekDay(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 16: {
                return 6;
            }
            case 32: {
                return 7;
            }
            case 64: {
                return 1;
            }
        }
        return -1;
    }

    private static int getWeekDayFromCalendarDay(int calendarDay) {
        switch (calendarDay) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 7: {
                return 32;
            }
            case 1: {
                return 64;
            }
        }
        return 64;
    }

    @Override
    public void copyFrom(IRecurrenceInfo source) {
        if (source instanceof WeeklyRecurrence) {
            WeeklyRecurrence recurrence = (WeeklyRecurrence)source;
            super.copyFrom(recurrence);
            this.dayOfWeekDataBinding = recurrence.dayOfWeekDataBinding;
        }
    }

    @Override
    public void toXML(StringBuffer buffer) {
        buffer.append("<");
        buffer.append(XML_Weekly_Tag);
        buffer.append(' ');
        buffer.append(XML_Days_To_Run);
        buffer.append("=");
        buffer.append('\"');
        buffer.append(this.dayOfWeekDataBinding);
        buffer.append('\"');
        buffer.append(">");
        super.toXML(buffer);
        buffer.append("</");
        buffer.append(XML_Weekly_Tag);
        buffer.append(">");
    }

    @Override
    public void injectXML(Document doc, Element parent) {
        Element tag = doc.createElement(XML_Weekly_Tag);
        parent.appendChild(tag);
        tag.setAttribute(XML_Days_To_Run, Integer.toString(this.dayOfWeekDataBinding));
        super.injectXML(doc, tag);
    }

    @Override
    public void toShortUniqueString(StringBuffer buffer) {
        buffer.append("WE_");
        buffer.append("dm" + this.dayOfWeekDataBinding + '_');
        super.toShortUniqueString(buffer);
    }

    private int getDaysCount() {
        int count = 0;
        if ((0x40 & this.dayOfWeekDataBinding) != 0) {
            ++count;
        }
        if ((1 & this.dayOfWeekDataBinding) != 0) {
            ++count;
        }
        if ((2 & this.dayOfWeekDataBinding) != 0) {
            ++count;
        }
        if ((4 & this.dayOfWeekDataBinding) != 0) {
            ++count;
        }
        if ((8 & this.dayOfWeekDataBinding) != 0) {
            ++count;
        }
        if ((0x10 & this.dayOfWeekDataBinding) != 0) {
            ++count;
        }
        if ((0x20 & this.dayOfWeekDataBinding) != 0) {
            ++count;
        }
        return count;
    }

    private List<String> getDayList(ResourceBundle bundle) {
        Vector<String> days = new Vector<String>();
        if ((0x40 & this.dayOfWeekDataBinding) != 0) {
            days.add(bundle.getString("Recurrence.toString.DayOfWeek.Sunday.txt"));
        }
        if ((1 & this.dayOfWeekDataBinding) != 0) {
            days.add(bundle.getString("Recurrence.toString.DayOfWeek.Monday.txt"));
        }
        if ((2 & this.dayOfWeekDataBinding) != 0) {
            days.add(bundle.getString("Recurrence.toString.DayOfWeek.Tuesday.txt"));
        }
        if ((4 & this.dayOfWeekDataBinding) != 0) {
            days.add(bundle.getString("Recurrence.toString.DayOfWeek.Wednesday.txt"));
        }
        if ((8 & this.dayOfWeekDataBinding) != 0) {
            days.add(bundle.getString("Recurrence.toString.DayOfWeek.Thursday.txt"));
        }
        if ((0x10 & this.dayOfWeekDataBinding) != 0) {
            days.add(bundle.getString("Recurrence.toString.DayOfWeek.Friday.txt"));
        }
        if ((0x20 & this.dayOfWeekDataBinding) != 0) {
            days.add(bundle.getString("Recurrence.toString.DayOfWeek.Saturday.txt"));
        }
        return days;
    }
}

