/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SASAppServer", propOrder={"directoriesDataBinding"})
public class SASAppServer
extends DisplayInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Directory")
    protected List<DirectoryInfo> directoriesDataBinding;
    private static final ResourceBundle m_bundle;
    public static final String IconName;

    public SASAppServer() {
        this.directoriesDataBinding = new ArrayList<DirectoryInfo>();
    }

    public SASAppServer(String serverName, String serverId, List<DirectoryInfo> directories) {
        super(serverName, null, IconName);
        this.setId(serverId);
        this.directoriesDataBinding = directories;
    }

    public List<DirectoryInfo> getDirectoriesDataBinding() {
        if (this.directoriesDataBinding == null) {
            this.directoriesDataBinding = new ArrayList<DirectoryInfo>();
        }
        return this.directoriesDataBinding;
    }

    public void setDirectoriesDataBinding(List<DirectoryInfo> directoriesDataBinding) {
        this.directoriesDataBinding = directoriesDataBinding;
    }

    public boolean addDirectory(DirectoryInfo directory) {
        return this.directoriesDataBinding.add(directory);
    }

    public String getDirectoryName(int nIndex) throws RemoteException {
        return this.directoriesDataBinding.get(nIndex).getName();
    }

    public void deleteDirectory(int nIndex) {
        this.directoriesDataBinding.remove(nIndex);
    }

    public int getDirectoryCount() {
        return this.directoriesDataBinding.size();
    }

    public DirectoryInfo getDirectory(int nIndex) {
        return this.directoriesDataBinding.get(nIndex);
    }

    public List<DirectoryInfo> getDirectories() {
        return this.directoriesDataBinding;
    }

    static {
        String strClassName = DirectoryInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("AppServer.image");
    }
}

