/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.AndRecurrence;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.DateList;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.NotRecurrence;
import com.sas.scheduler.model.OpaqueRecurrence;
import com.sas.scheduler.model.OrRecurrence;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.scheduler.model.YearlyRecurrence;
import com.sas.text.Message;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RecurrenceBaseClass")
@XmlSeeAlso(value={OrRecurrence.class, AndRecurrence.class, OpaqueRecurrence.class, NotRecurrence.class, AbstractRecurrence.class})
public abstract class RecurrenceBaseClass
implements Serializable,
IRecurrenceInfo {
    private static final long serialVersionUID = 1L;
    public static final String XML_Schedule_Tag = "schedule";
    public static final Comparator<Calendar> MyCalendarComparator = new CalendarComparator();
    public static final Comparator<XMLGregorianCalendar> MyXMLGregorianCalendarComparator = new XMLGregorianCalendarComparator();
    public static final Comparator<Date> MyDateComparator = new DateComparator();

    @Override
    public final String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(XML_Schedule_Tag);
        buffer.append(">");
        this.toXML(buffer);
        buffer.append("</");
        buffer.append(XML_Schedule_Tag);
        buffer.append(">");
        return buffer.toString();
    }

    @Override
    public final void serialize(Document doc, Node parent) {
        Element schedElement = doc.createElement(XML_Schedule_Tag);
        parent.appendChild(schedElement);
        this.injectXML(doc, schedElement);
    }

    public abstract void injectXML(Document var1, Element var2);

    public static String dateToString(Calendar cal, Locale locale) {
        return DateFormat.getDateInstance(3, locale).format(cal.getTime());
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    @Override
    public abstract void toXML(StringBuffer var1);

    @Override
    public final String toShortUniqueString() {
        StringBuffer buffer = new StringBuffer();
        this.toShortUniqueString(buffer);
        return buffer.toString();
    }

    public static boolean isEqualByMinute(Calendar date1, Calendar date2) {
        int year1 = date1.get(1);
        int month1 = date1.get(2);
        int day1 = date1.get(5);
        int hour1 = date1.get(11);
        int minute1 = date1.get(12);
        int year2 = date2.get(1);
        int month2 = date2.get(2);
        int day2 = date2.get(5);
        int hour2 = date2.get(11);
        int minute2 = date2.get(12);
        return year1 == year2 && month1 == month2 && day1 == day2 && hour1 == hour2 && minute1 == minute2;
    }

    public static boolean isAfterByMinute(Calendar date1, Calendar date2) {
        int year1 = date1.get(1);
        int month1 = date1.get(2);
        int day1 = date1.get(5);
        int hour1 = date1.get(11);
        int minute1 = date1.get(12);
        int year2 = date2.get(1);
        int month2 = date2.get(2);
        int day2 = date2.get(5);
        int hour2 = date2.get(11);
        int minute2 = date2.get(12);
        if (year1 > year2) {
            return true;
        }
        if (year1 == year2) {
            if (month1 > month2) {
                return true;
            }
            if (month1 == month2) {
                if (day1 > day2) {
                    return true;
                }
                if (day1 == day2) {
                    if (hour1 > hour2) {
                        return true;
                    }
                    if (hour1 == hour2 && minute1 > minute2) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isBeforeByMinute(Calendar date1, Calendar date2) {
        int year1 = date1.get(1);
        int month1 = date1.get(2);
        int day1 = date1.get(5);
        int hour1 = date1.get(11);
        int minute1 = date1.get(12);
        int year2 = date2.get(1);
        int month2 = date2.get(2);
        int day2 = date2.get(5);
        int hour2 = date2.get(11);
        int minute2 = date2.get(12);
        if (year1 < year2) {
            return true;
        }
        if (year1 == year2) {
            if (month1 < month2) {
                return true;
            }
            if (month1 == month2) {
                if (day1 < day2) {
                    return true;
                }
                if (day1 == day2) {
                    if (hour1 < hour2) {
                        return true;
                    }
                    if (hour1 == hour2 && minute1 < minute2) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isAfterByDay(Calendar date1, Calendar date2) {
        int year1 = date1.get(1);
        int month1 = date1.get(2);
        int day1 = date1.get(5);
        int year2 = date2.get(1);
        int month2 = date2.get(2);
        int day2 = date2.get(5);
        if (year1 > year2) {
            return true;
        }
        if (year1 == year2 && month1 > month2) {
            return true;
        }
        return year1 == year2 && month1 == month2 && day1 > day2;
    }

    public static boolean isBeforeByDay(Calendar date1, Calendar date2) {
        int year1 = date1.get(1);
        int month1 = date1.get(2);
        int day1 = date1.get(5);
        int year2 = date2.get(1);
        int month2 = date2.get(2);
        int day2 = date2.get(5);
        if (year1 < year2) {
            return true;
        }
        if (year1 == year2 && month1 < month2) {
            return true;
        }
        return year1 == year2 && month1 == month2 && day1 < day2;
    }

    public static boolean isEqualByDay(Calendar date1, Calendar date2) {
        int year1 = date1.get(1);
        int month1 = date1.get(2);
        int day1 = date1.get(5);
        int year2 = date2.get(1);
        int month2 = date2.get(2);
        int day2 = date2.get(5);
        return year1 == year2 && month1 == month2 && day1 == day2;
    }

    public static String toStringByDay(Calendar date) {
        StringBuffer buffer = new StringBuffer();
        int year1 = date.get(1);
        int month1 = date.get(2);
        int day1 = date.get(5);
        buffer.append(year1);
        buffer.append('/');
        buffer.append(month1 + 1);
        buffer.append('/');
        buffer.append(day1);
        return buffer.toString();
    }

    public boolean equals(Object calendar) {
        boolean equal = false;
        if (calendar instanceof IRecurrenceInfo && this.toXML().compareTo(((IRecurrenceInfo)calendar).toXML()) == 0) {
            equal = true;
        }
        return equal;
    }

    @Override
    public abstract void toShortUniqueString(StringBuffer var1);

    protected String calendarToShortString(Calendar date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        int singleNumber = year * 10000 + month * 100 + day;
        return Integer.toString(singleNumber);
    }

    protected abstract void copyFrom(IRecurrenceInfo var1);

    protected static String generateLocaleStringFromList(Locale locale, String[] items, String firstItemPropertyString, String middleItemPropertyString, String lastItemPropertyString) {
        String strClassName = IRecurrenceInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        ResourceBundle bundle = ResourceBundle.getBundle(strBundlePath, locale);
        StringBuffer result = new StringBuffer();
        Object[] args = new Object[1];
        for (int i = 0; i < items.length; ++i) {
            String itemString;
            args[0] = items[i];
            if (i == 0) {
                itemString = Message.format((ResourceBundle)bundle, (String)firstItemPropertyString, (Object[])args);
                result.append(itemString);
                continue;
            }
            if (i == items.length - 1) {
                itemString = Message.format((ResourceBundle)bundle, (String)lastItemPropertyString, (Object[])args);
                result.append(itemString);
                continue;
            }
            itemString = Message.format((ResourceBundle)bundle, (String)middleItemPropertyString, (Object[])args);
            result.append(itemString);
        }
        return result.toString();
    }

    public static IRecurrenceInfo createFromXML(String xmlString) throws SchedulerException {
        InputSource source = new InputSource(new StringReader(xmlString));
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
            NodeList nl = doc.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!node.getNodeName().equals(XML_Schedule_Tag)) continue;
                IRecurrenceInfo info = RecurrenceBaseClass.processScheduleTag(node);
                return info;
            }
        }
        catch (SAXException doc) {
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException();
            se.initCause(e);
            throw se;
        }
        catch (ParserConfigurationException e) {
            SchedulerException se = new SchedulerException();
            se.initCause(e);
            throw se;
        }
        catch (FactoryConfigurationError e) {
            SchedulerException se = new SchedulerException();
            se.initCause(e);
            throw se;
        }
        return null;
    }

    public static IRecurrenceInfo createFromNode(Node node) throws SchedulerException {
        try {
            while (node != null) {
                if (node.getNodeName().equals(XML_Schedule_Tag)) {
                    IRecurrenceInfo info = RecurrenceBaseClass.processScheduleTag(node);
                    return info;
                }
                node = node.getNextSibling();
            }
        }
        catch (FactoryConfigurationError e) {
            SchedulerException se = new SchedulerException();
            se.initCause(e);
            throw se;
        }
        return null;
    }

    public static IRecurrenceInfo processScheduleTag(Node scheduleNode) throws SchedulerException {
        NodeList children = scheduleNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processSubRecurrenceTag(child);
            if (recurrence == null) continue;
            return recurrence;
        }
        return null;
    }

    private static IRecurrenceInfo processSubRecurrenceTag(Node child) throws SchedulerException {
        if (child.getNodeName().equals("daily")) {
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processDailyTag(child);
            return recurrence;
        }
        if (child.getNodeName().equals("weekly")) {
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processWeeklyTag(child);
            return recurrence;
        }
        if (child.getNodeName().equals("yearly")) {
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processYearlyTag(child);
            return recurrence;
        }
        if (child.getNodeName().equals("monthly")) {
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processMonthlyTag(child);
            return recurrence;
        }
        if (child.getNodeName().equals("dateList")) {
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processDateListTag(child);
            return recurrence;
        }
        if (child.getNodeName().equals("ANDRecurrence")) {
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processAndTag(child);
            return recurrence;
        }
        if (child.getNodeName().equals("ORRecurrence")) {
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processOrTag(child);
            return recurrence;
        }
        if (child.getNodeName().equals("NOTRecurrence")) {
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processNotTag(child);
            return recurrence;
        }
        if (child.getNodeName().equals("opaque")) {
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processOpaque(child);
            return recurrence;
        }
        return null;
    }

    private static IRecurrenceInfo processWeeklyTag(Node child) throws SchedulerException {
        WeeklyRecurrence recurrence = new WeeklyRecurrence();
        NamedNodeMap attributes = child.getAttributes();
        Node dayMaskNode = attributes.getNamedItem("daysToRun");
        if (dayMaskNode != null) {
            try {
                String dayMaskString = dayMaskNode.getNodeValue();
                int dayMask = Integer.parseInt(dayMaskString);
                recurrence.setDaysToRun(dayMask);
            }
            catch (NumberFormatException e) {
                SchedulerException se = new SchedulerException();
                se.initCause(e);
                throw se;
            }
        } else {
            throw new SchedulerException();
        }
        RecurrenceBaseClass.processCommonRecurrenceItems(recurrence, child);
        return recurrence;
    }

    private static IRecurrenceInfo processMonthlyTag(Node child) throws SchedulerException {
        Node dayOfMonthNode;
        MonthlyRecurrence recurrence = new MonthlyRecurrence();
        NamedNodeMap attributes = child.getAttributes();
        Node dayOfWeekNode = attributes.getNamedItem("dayOfWeek");
        Node whichWeekNode = attributes.getNamedItem("whichWeek");
        if (dayOfWeekNode != null && whichWeekNode != null) {
            try {
                String dayOfWeekString = dayOfWeekNode.getNodeValue();
                String whichWeekString = whichWeekNode.getNodeValue();
                int dayOfWeek = Integer.parseInt(dayOfWeekString);
                int whichWeek = Integer.parseInt(whichWeekString);
                recurrence.setRecurringDay(dayOfWeek, whichWeek);
            }
            catch (NumberFormatException e) {
                SchedulerException se = new SchedulerException();
                se.initCause(e);
                throw se;
            }
        }
        if ((dayOfMonthNode = attributes.getNamedItem("dayOfMonth")) != null) {
            try {
                String dayOfMonthString = dayOfMonthNode.getNodeValue();
                int dayOfMonth = Integer.parseInt(dayOfMonthString);
                recurrence.setDayOfMonth(dayOfMonth);
            }
            catch (NumberFormatException e) {
                SchedulerException se = new SchedulerException();
                se.initCause(e);
                throw se;
            }
        }
        RecurrenceBaseClass.processCommonRecurrenceItems(recurrence, child);
        return recurrence;
    }

    private static IRecurrenceInfo processYearlyTag(Node child) throws SchedulerException {
        YearlyRecurrence recurrence;
        block8: {
            recurrence = new YearlyRecurrence();
            NamedNodeMap attributes = child.getAttributes();
            Node monthNode = attributes.getNamedItem("month");
            Node dayNode = attributes.getNamedItem("day");
            Node dayOfWeekNode = attributes.getNamedItem("dayOfWeek");
            Node whichWeekNode = attributes.getNamedItem("whichWeek");
            try {
                String monthString = null;
                if (monthNode != null) {
                    monthString = monthNode.getNodeValue();
                }
                String dayString = null;
                if (dayNode != null) {
                    dayString = dayNode.getNodeValue();
                }
                String dayOfWeekString = null;
                if (dayOfWeekNode != null) {
                    dayOfWeekString = dayOfWeekNode.getNodeValue();
                }
                String whichWeekString = null;
                if (whichWeekNode != null) {
                    whichWeekString = whichWeekNode.getNodeValue();
                }
                if (monthString != null && dayString != null) {
                    recurrence.setDate(Integer.parseInt(monthString), Integer.parseInt(dayString));
                    break block8;
                }
                if (monthString != null && dayOfWeekString != null && whichWeekString != null) {
                    recurrence.setFloatingDay(Integer.parseInt(monthString), Integer.parseInt(dayOfWeekString), Integer.parseInt(whichWeekString));
                    break block8;
                }
                throw new SchedulerException();
            }
            catch (NumberFormatException e) {
                SchedulerException se = new SchedulerException();
                se.initCause(e);
                throw se;
            }
        }
        RecurrenceBaseClass.processCommonRecurrenceItems(recurrence, child);
        return recurrence;
    }

    private static IRecurrenceInfo processDateListTag(Node recurrenceNode) throws SchedulerException {
        DateList recurrence = new DateList();
        Calendar date = null;
        boolean first = true;
        NodeList dateNodes = recurrenceNode.getChildNodes();
        for (int i = 0; i < dateNodes.getLength(); ++i) {
            Node dateNode = dateNodes.item(i);
            date = RecurrenceBaseClass.processDateTag(dateNode);
            if (date == null) continue;
            if (first) {
                recurrence.setStartDate(date);
                first = false;
            }
            recurrence.addDate(date);
        }
        if (date != null) {
            recurrence.setEndDate(date);
        }
        return recurrence;
    }

    private static IRecurrenceInfo processDailyTag(Node child) throws SchedulerException {
        Node hourlyNode;
        DailyRecurrence recurrence = new DailyRecurrence();
        NamedNodeMap attrs = child.getAttributes();
        Node weekdaysNode = attrs.getNamedItem("onlyWeekDays");
        if (weekdaysNode != null) {
            String text = weekdaysNode.getNodeValue();
            recurrence.setWeekDays(Boolean.valueOf(text));
        }
        if ((hourlyNode = attrs.getNamedItem("hourly")) != null) {
            String text = hourlyNode.getNodeValue();
            int skipcount = Integer.parseInt(text.substring(0, text.indexOf(58)));
            int offset = Integer.parseInt(text.substring(text.indexOf(58) + 1));
            recurrence.setHourly(skipcount, offset);
        }
        RecurrenceBaseClass.processCommonRecurrenceItems(recurrence, child);
        return recurrence;
    }

    private static void processCommonRecurrenceItems(AbstractRecurrence recurrence, Node recurrenceNode) throws SchedulerException {
        NodeList children = recurrenceNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Calendar time;
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (tagName.equals("skipCount")) {
                NamedNodeMap attrs = child.getAttributes();
                Node skipNode = attrs.getNamedItem("count");
                if (skipNode == null) continue;
                String countString = skipNode.getNodeValue();
                try {
                    int count = Integer.parseInt(countString);
                    recurrence.setSkipCount(count);
                    continue;
                }
                catch (NumberFormatException e) {
                    SchedulerException se = new SchedulerException();
                    se.initCause(e);
                    throw se;
                }
            }
            if (tagName.equals("startTime")) {
                time = RecurrenceBaseClass.processDateTag(child);
                recurrence.setStartDate(time);
                continue;
            }
            if (!tagName.equals("endTime")) continue;
            time = RecurrenceBaseClass.processDateTag(child);
            recurrence.setEndDate(time);
        }
    }

    private static IRecurrenceInfo processAndTag(Node andNode) throws SchedulerException {
        AndRecurrence recurrence = new AndRecurrence();
        NodeList children = andNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            IRecurrenceInfo subRecurrence = RecurrenceBaseClass.processSubRecurrenceTag(child);
            if (subRecurrence == null) continue;
            recurrence.add(subRecurrence);
        }
        return recurrence;
    }

    private static IRecurrenceInfo processOrTag(Node andNode) throws SchedulerException {
        OrRecurrence recurrence = new OrRecurrence();
        NodeList children = andNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            IRecurrenceInfo subRecurrence = RecurrenceBaseClass.processSubRecurrenceTag(child);
            if (subRecurrence == null) continue;
            recurrence.add(subRecurrence);
        }
        return recurrence;
    }

    private static IRecurrenceInfo processNotTag(Node andNode) throws SchedulerException {
        NotRecurrence recurrence = new NotRecurrence();
        NodeList children = andNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            IRecurrenceInfo subRecurrence = RecurrenceBaseClass.processSubRecurrenceTag(child);
            if (subRecurrence == null) continue;
            recurrence.setRecurrence(subRecurrence);
            return recurrence;
        }
        return recurrence;
    }

    private static IRecurrenceInfo processOpaque(Node opaqueNode) throws SchedulerException {
        NamedNodeMap attrs = opaqueNode.getAttributes();
        Node schedulerNode = attrs.getNamedItem("scheduler");
        Node displayNode = attrs.getNamedItem("display");
        Node valueNode = attrs.getNamedItem("data");
        Node expressionNode = attrs.getNamedItem("expression");
        if (schedulerNode != null && displayNode != null && valueNode != null) {
            OpaqueRecurrence recurrence = null;
            String schedulerString = schedulerNode.getNodeValue();
            String displayString = displayNode.getNodeValue();
            String valueString = valueNode.getNodeValue();
            recurrence = expressionNode != null ? new OpaqueRecurrence(schedulerString, displayString, valueString, expressionNode.getNodeValue()) : new OpaqueRecurrence(schedulerString, displayString, valueString);
            return recurrence;
        }
        throw new SchedulerException();
    }

    private static Calendar processDateTag(Node dateNode) throws SchedulerException {
        NamedNodeMap attrs = dateNode.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node yearNode = attrs.getNamedItem("year");
        Node monthNode = attrs.getNamedItem("month");
        Node dayNode = attrs.getNamedItem("day");
        if (yearNode != null && monthNode != null && dayNode != null) {
            try {
                String yearString = yearNode.getNodeValue();
                String monthString = monthNode.getNodeValue();
                String dayString = dayNode.getNodeValue();
                int year = Integer.parseInt(yearString);
                int month = Integer.parseInt(monthString) - 1;
                int day = Integer.parseInt(dayString);
                GregorianCalendar calendar = new GregorianCalendar(Locale.getDefault());
                calendar.set(year, month, day);
                return calendar;
            }
            catch (NumberFormatException e) {
                SchedulerException se = new SchedulerException();
                se.initCause(e);
                throw se;
            }
        }
        throw new SchedulerException();
    }

    public static XMLGregorianCalendar convertCalendarToXMLGregorianCalendar(Calendar inCal) {
        XMLGregorianCalendar outCal = null;
        if (inCal != null) {
            Date date = inCal.getTime();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            try {
                DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
                outCal = datatypeFactory.newXMLGregorianCalendar(cal);
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        return outCal;
    }

    public static Calendar convertXMLGregorianCalendarToCalendar(XMLGregorianCalendar inCal) {
        GregorianCalendar outCal = null;
        if (inCal != null) {
            outCal = inCal.toGregorianCalendar();
        }
        return outCal;
    }

    private static class DateComparator
    implements Comparator<Date> {
        private DateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            long cal2Time;
            long cal1Time = o1.getTime();
            if (cal1Time > (cal2Time = o2.getTime())) {
                return 1;
            }
            if (cal1Time < cal2Time) {
                return -1;
            }
            return 0;
        }
    }

    private static class XMLGregorianCalendarComparator
    implements Comparator<XMLGregorianCalendar> {
        private XMLGregorianCalendarComparator() {
        }

        @Override
        public int compare(XMLGregorianCalendar o1, XMLGregorianCalendar o2) {
            long cal2Time;
            long cal1Time = RecurrenceBaseClass.convertXMLGregorianCalendarToCalendar(o1).getTimeInMillis();
            if (cal1Time > (cal2Time = RecurrenceBaseClass.convertXMLGregorianCalendarToCalendar(o2).getTimeInMillis())) {
                return 1;
            }
            if (cal1Time < cal2Time) {
                return -1;
            }
            return 0;
        }
    }

    private static class CalendarComparator
    implements Comparator<Calendar> {
        private CalendarComparator() {
        }

        @Override
        public int compare(Calendar o1, Calendar o2) {
            long cal2Time;
            long cal1Time = o1.getTimeInMillis();
            if (cal1Time > (cal2Time = o2.getTimeInMillis())) {
                return 1;
            }
            if (cal1Time < cal2Time) {
                return -1;
            }
            return 0;
        }
    }
}

