/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.RecurrenceBaseClass;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OrRecurrence", propOrder={"combinedRecurrencesDataBinding"})
public class OrRecurrence
extends RecurrenceBaseClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="CombinedRecurrences", required=true)
    protected List<AbstractRecurrence> combinedRecurrencesDataBinding = new ArrayList<AbstractRecurrence>();
    public static final String XML_OR_Tag = "ORRecurrence";

    public List<AbstractRecurrence> getCombinedRecurrencesDataBinding() {
        if (this.combinedRecurrencesDataBinding == null) {
            this.combinedRecurrencesDataBinding = new ArrayList<AbstractRecurrence>();
        }
        return this.combinedRecurrencesDataBinding;
    }

    public void setCombinedRecurrencesDataBinding(List<AbstractRecurrence> combinedRecurrencesDataBinding) {
        this.combinedRecurrencesDataBinding = combinedRecurrencesDataBinding;
    }

    public void add(IRecurrenceInfo recurrence) {
        if (recurrence != null) {
            this.combinedRecurrencesDataBinding.add((AbstractRecurrence)recurrence);
        }
    }

    @Override
    public String toString(Locale locale) {
        String strClassName = OrRecurrence.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        ResourceBundle bundle = ResourceBundle.getBundle(strBundlePath, locale);
        IRecurrenceInfo recurrence = this.combinedRecurrencesDataBinding.get(0);
        String buffer = recurrence != null ? recurrence.toString(locale) : "";
        for (int i = 1; i < this.combinedRecurrencesDataBinding.size(); ++i) {
            recurrence = this.combinedRecurrencesDataBinding.get(i);
            Object[] args = new Object[]{buffer, recurrence.toString(locale)};
            if (i >= this.combinedRecurrencesDataBinding.size() - 1) continue;
            buffer = Message.format((ResourceBundle)bundle, (String)"OrRecurrence.toString.combiner.fmt", (Object[])args);
        }
        return buffer.toString();
    }

    @Override
    public boolean includesDate(Calendar queryDate) throws InvalidRecurrenceException {
        if (this.combinedRecurrencesDataBinding.isEmpty()) {
            return false;
        }
        for (IRecurrenceInfo iRecurrenceInfo : this.combinedRecurrencesDataBinding) {
            boolean included = iRecurrenceInfo.includesDate(queryDate);
            if (!included) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Calendar> getNextDates(Calendar queryDate, Calendar endQueryDate, int count) throws InvalidRecurrenceException {
        ArrayList<Calendar> returnList = new ArrayList<Calendar>();
        HashMap<String, Calendar> resultsMap = new HashMap<String, Calendar>();
        for (IRecurrenceInfo iRecurrenceInfo : this.combinedRecurrencesDataBinding) {
            List<Calendar> results = iRecurrenceInfo.getNextDates(queryDate, endQueryDate, count);
            for (Calendar date : results) {
                String dateString = RecurrenceBaseClass.toStringByDay(date);
                resultsMap.put(dateString, date);
            }
        }
        returnList.addAll(resultsMap.values());
        Collections.sort(returnList, RecurrenceBaseClass.MyCalendarComparator);
        if (count > 0 && returnList.size() > count) {
            void var7_9;
            ArrayList<Calendar> tempList = new ArrayList<Calendar>(count);
            boolean bl = false;
            while (var7_9 < count) {
                tempList.add((Calendar)returnList.get((int)var7_9));
                ++var7_9;
            }
            returnList = tempList;
        }
        return returnList;
    }

    @Override
    public IRecurrenceInfo copy() {
        OrRecurrence recurrence = new OrRecurrence();
        recurrence.copyFrom(this);
        return recurrence;
    }

    @Override
    public void toXML(StringBuffer buffer) {
        buffer.append("<ORRecurrence>");
        for (IRecurrenceInfo iRecurrenceInfo : this.combinedRecurrencesDataBinding) {
            iRecurrenceInfo.toXML(buffer);
        }
        buffer.append("</ORRecurrence>");
    }

    @Override
    public void injectXML(Document doc, Element parent) {
        Element tag = doc.createElement(XML_OR_Tag);
        parent.appendChild(tag);
        for (IRecurrenceInfo iRecurrenceInfo : this.combinedRecurrencesDataBinding) {
            iRecurrenceInfo.serialize(doc, tag);
        }
    }

    @Override
    public void toShortUniqueString(StringBuffer buffer) {
        Iterator<AbstractRecurrence> iter = this.combinedRecurrencesDataBinding.iterator();
        while (iter.hasNext()) {
            IRecurrenceInfo recurrence = iter.next();
            recurrence.toShortUniqueString(buffer);
            if (!iter.hasNext()) continue;
            buffer.append("_OR_");
        }
    }

    public List<IRecurrenceInfo> getCombinedItems() {
        ArrayList<IRecurrenceInfo> recurrences = new ArrayList<IRecurrenceInfo>();
        for (IRecurrenceInfo iRecurrenceInfo : this.combinedRecurrencesDataBinding) {
            recurrences.add(iRecurrenceInfo);
        }
        return recurrences;
    }

    @Override
    protected void copyFrom(IRecurrenceInfo source) {
        if (source instanceof OrRecurrence) {
            OrRecurrence recurrence = (OrRecurrence)source;
            this.combinedRecurrencesDataBinding.clear();
            for (IRecurrenceInfo iRecurrenceInfo : recurrence.combinedRecurrencesDataBinding) {
                this.add(iRecurrenceInfo.copy());
            }
        }
    }
}

