/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.RecurrenceBaseClass;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NotRecurrence", propOrder={"recurrenceDataBinding"})
public class NotRecurrence
extends RecurrenceBaseClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Recurrence", required=true)
    protected AbstractRecurrence recurrenceDataBinding;
    public static final String XML_NOT_Tag = "NOTRecurrence";

    public NotRecurrence() {
        this.recurrenceDataBinding = null;
    }

    public NotRecurrence(IRecurrenceInfo recurrence) {
        this.recurrenceDataBinding = (AbstractRecurrence)recurrence;
    }

    public AbstractRecurrence getRecurrenceDataBinding() {
        return this.recurrenceDataBinding;
    }

    public void setRecurrenceDataBinding(AbstractRecurrence value) {
        this.recurrenceDataBinding = value;
    }

    @Override
    public String toString(Locale locale) {
        String buffer = "";
        if (this.recurrenceDataBinding != null) {
            String strClassName = NotRecurrence.class.getName();
            String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
            String strBundlePath = strPackageName + ".PropertyBundle";
            ResourceBundle bundle = ResourceBundle.getBundle(strBundlePath, locale);
            Object[] args = new Object[]{this.recurrenceDataBinding.toString(locale)};
            buffer = Message.format((ResourceBundle)bundle, (String)"NotRecurrence.toString.fmt", (Object[])args);
        }
        return buffer.toString();
    }

    public IRecurrenceInfo getRecurrence() {
        return this.recurrenceDataBinding;
    }

    @Override
    public boolean includesDate(Calendar queryDate) throws InvalidRecurrenceException {
        if (this.recurrenceDataBinding == null) {
            return false;
        }
        boolean includesDate = this.recurrenceDataBinding.includesDate(queryDate);
        return !includesDate;
    }

    @Override
    public List<Calendar> getNextDates(Calendar queryDate, Calendar endQueryDate, int count) throws InvalidRecurrenceException {
        ArrayList<Calendar> returnList = new ArrayList<Calendar>();
        if (this.recurrenceDataBinding == null) {
            return returnList;
        }
        Calendar testDate = (Calendar)queryDate.clone();
        while (!RecurrenceBaseClass.isAfterByDay(testDate, endQueryDate)) {
            boolean included = this.recurrenceDataBinding.includesDate(testDate);
            if (!included) {
                returnList.add((Calendar)testDate.clone());
                if (count > 0 && returnList.size() >= count) break;
            }
            testDate.add(5, 1);
        }
        return returnList;
    }

    @Override
    public IRecurrenceInfo copy() {
        NotRecurrence recurrence = new NotRecurrence();
        recurrence.copyFrom(this);
        return recurrence;
    }

    public void setRecurrence(IRecurrenceInfo recurrence) {
        this.recurrenceDataBinding = (AbstractRecurrence)recurrence;
    }

    @Override
    public void toXML(StringBuffer buffer) {
        buffer.append("<NOTRecurrence>");
        if (this.recurrenceDataBinding != null) {
            this.recurrenceDataBinding.toXML(buffer);
        }
        buffer.append("</NOTRecurrence>");
    }

    @Override
    public void injectXML(Document doc, Element parent) {
        Element tag = doc.createElement(XML_NOT_Tag);
        parent.appendChild(tag);
        if (this.recurrenceDataBinding != null) {
            this.recurrenceDataBinding.serialize(doc, tag);
        }
    }

    @Override
    public void toShortUniqueString(StringBuffer buffer) {
        buffer.append("_NOT_");
        if (this.recurrenceDataBinding != null) {
            this.recurrenceDataBinding.toShortUniqueString(buffer);
        }
    }

    @Override
    protected void copyFrom(IRecurrenceInfo source) {
        if (source instanceof NotRecurrence) {
            NotRecurrence recurrence = (NotRecurrence)source;
            this.recurrenceDataBinding = null;
            if (recurrence.recurrenceDataBinding != null) {
                this.setRecurrence(recurrence.recurrenceDataBinding.copy());
            }
        }
    }
}

