/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MonthlyRecurrence", propOrder={"dayOfMonthDataBinding", "dayOfWeekDataBinding", "whichWeekDataBinding"})
public class MonthlyRecurrence
extends AbstractRecurrence
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="DayOfMonth")
    protected int dayOfMonthDataBinding = 1;
    @XmlElement(name="DayOfWeek")
    protected int dayOfWeekDataBinding = -1;
    @XmlElement(name="WhichWeek")
    protected int whichWeekDataBinding = -1;
    public static final int OCCURRENCE_FIRST = 1;
    public static final int OCCURRENCE_SECOND = 2;
    public static final int OCCURRENCE_THIRD = 3;
    public static final int OCCURRENCE_FOURTH = 4;
    public static final int OCCURRENCE_LAST = 6;
    public static final int DAY = 128;
    static final String XML_Month_Tag = "monthly";
    static final String XML_Day_Of_Month = "dayOfMonth";
    static final String XML_Day_Of_Week = "dayOfWeek";
    static final String XML_Which_Week = "whichWeek";

    public int getDayOfMonthDataBinding() {
        return this.dayOfMonthDataBinding;
    }

    public void setDayOfMonthDataBinding(int value) {
        this.dayOfMonthDataBinding = value;
    }

    public int getDayOfWeekDataBinding() {
        return this.dayOfWeekDataBinding;
    }

    public void setDayOfWeekDataBinding(int value) {
        this.dayOfWeekDataBinding = value;
    }

    public int getWhichWeekDataBinding() {
        return this.whichWeekDataBinding;
    }

    public void setWhichWeekDataBinding(int value) {
        this.whichWeekDataBinding = value;
    }

    public boolean setDayOfMonth(int dayIndex) {
        if (dayIndex >= 1 && dayIndex <= 31) {
            this.dayOfMonthDataBinding = dayIndex;
            this.dayOfWeekDataBinding = -1;
            this.whichWeekDataBinding = -1;
            return true;
        }
        return false;
    }

    public int getDayOfMonth() {
        return this.dayOfMonthDataBinding;
    }

    public int getDayOfWeek() {
        return this.dayOfWeekDataBinding;
    }

    public int getWhichWeek() {
        return this.whichWeekDataBinding;
    }

    public boolean setRecurringDay(int dayConstant, int occurrenceConstant) {
        if (!(occurrenceConstant != 1 && occurrenceConstant != 2 && occurrenceConstant != 3 && occurrenceConstant != 4 && occurrenceConstant != 6 || dayConstant != 1 && dayConstant != 2 && dayConstant != 4 && dayConstant != 8 && dayConstant != 16 && dayConstant != 32 && dayConstant != 64 && dayConstant != 128)) {
            this.dayOfWeekDataBinding = dayConstant;
            this.whichWeekDataBinding = occurrenceConstant;
            this.dayOfMonthDataBinding = 0;
            return true;
        }
        return false;
    }

    @Override
    public String toString(Locale locale) {
        String strClassName = MonthlyRecurrence.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        ResourceBundle bundle = ResourceBundle.getBundle(strBundlePath, locale);
        String expression = "";
        Calendar startTime = this.getStartDate();
        Calendar endTime = this.getEndDate();
        String startTimeString = null;
        if (startTime != null) {
            startTimeString = AbstractRecurrence.dateToString(startTime, locale);
        }
        String endTimeString = null;
        if (endTime != null) {
            endTimeString = AbstractRecurrence.dateToString(endTime, locale);
        }
        if (this.dayOfMonthDataBinding >= 1) {
            if (this.getSkipCount() > 1) {
                if (startTimeString != null) {
                    if (endTimeString == null) {
                        Object[] args = new Object[]{String.valueOf(this.dayOfMonthDataBinding), String.valueOf(this.getSkipCount()), startTimeString};
                        expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OffsetSkipStart.fmt.txt", (Object[])args);
                    } else {
                        Object[] args = new Object[]{String.valueOf(this.dayOfMonthDataBinding), String.valueOf(this.getSkipCount()), startTimeString, endTimeString};
                        expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OffsetSkipStartEnd.fmt.txt", (Object[])args);
                    }
                }
            } else if (startTimeString == null && endTimeString == null) {
                Object[] args = new Object[]{String.valueOf(this.dayOfMonthDataBinding)};
                expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.Offset.fmt.txt", (Object[])args);
            } else if (endTimeString == null) {
                Object[] args = new Object[]{String.valueOf(this.dayOfMonthDataBinding), startTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OffsetStart.fmt.txt", (Object[])args);
            } else if (startTimeString == null) {
                Object[] args = new Object[]{String.valueOf(this.dayOfMonthDataBinding), endTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OffsetEnd.fmt.txt", (Object[])args);
            } else {
                Object[] args = new Object[]{String.valueOf(this.dayOfMonthDataBinding), startTimeString, endTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OffsetStartEnd.fmt.txt", (Object[])args);
            }
        } else if (this.dayOfWeekDataBinding >= 0 && this.whichWeekDataBinding >= 0) {
            String dayOfWeekString = "";
            switch (this.dayOfWeekDataBinding) {
                case 1: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Monday.txt");
                    break;
                }
                case 16: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Friday.txt");
                    break;
                }
                case 32: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Saturday.txt");
                    break;
                }
                case 64: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Sunday.txt");
                    break;
                }
                case 8: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Thursday.txt");
                    break;
                }
                case 2: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Tuesday.txt");
                    break;
                }
                case 4: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Wednesday.txt");
                    break;
                }
                case 128: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.Anyday.txt");
                }
            }
            String whichWeekString = "";
            switch (this.whichWeekDataBinding) {
                case 1: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.First.txt");
                    break;
                }
                case 4: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.Fourth.txt");
                    break;
                }
                case 6: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.Last.txt");
                    break;
                }
                case 2: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.Second.txt");
                    break;
                }
                case 3: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.Third.txt");
                }
            }
            if (this.getSkipCount() > 1) {
                if (startTimeString != null) {
                    if (endTimeString == null) {
                        Object[] args = new Object[]{whichWeekString, dayOfWeekString, String.valueOf(this.getSkipCount()), startTimeString};
                        expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OrdinalDaySkipStart.fmt.txt", (Object[])args);
                    } else {
                        Object[] args = new Object[]{whichWeekString, dayOfWeekString, String.valueOf(this.getSkipCount()), startTimeString, endTimeString};
                        expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OrdinalDaySkipStartEnd.fmt.txt", (Object[])args);
                    }
                }
            } else if (startTimeString == null && endTimeString == null) {
                Object[] args = new Object[]{whichWeekString, dayOfWeekString};
                expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OrdinalDay.fmt.txt", (Object[])args);
            } else if (endTimeString == null) {
                Object[] args = new Object[]{whichWeekString, dayOfWeekString, startTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OrdinalDayStart.fmt.txt", (Object[])args);
            } else if (startTimeString == null) {
                Object[] args = new Object[]{whichWeekString, dayOfWeekString, endTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OrdinalDayEnd.fmt.txt", (Object[])args);
            } else {
                Object[] args = new Object[]{whichWeekString, dayOfWeekString, startTimeString, endTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"MonthlyRecurrence.toString.OrdinalDayStartEnd.fmt.txt", (Object[])args);
            }
        }
        return expression;
    }

    @Override
    public boolean includesDate(Calendar queryDate) throws InvalidRecurrenceException {
        boolean okay;
        if (!this.isDateInRange(queryDate)) {
            return false;
        }
        if (this.getDayOfMonth() > 0 ? queryDate.get(5) != this.getDayOfMonth() : !(okay = MonthlyRecurrence.isDateAllowedUnderOrdinalSettings(queryDate, this.getDayOfWeek(), this.getWhichWeek()))) {
            return false;
        }
        if (this.getSkipCount() > 1) {
            return super.includesDate(queryDate);
        }
        return true;
    }

    @Override
    public IRecurrenceInfo copy() {
        MonthlyRecurrence recurrence = new MonthlyRecurrence();
        recurrence.copyFrom(this);
        return recurrence;
    }

    @Override
    public List<Calendar> getNextDates(Calendar queryDate, Calendar endQueryDate, int count) throws InvalidRecurrenceException {
        ArrayList<Calendar> results = new ArrayList<Calendar>();
        if (endQueryDate == null || queryDate == null || count < 0) {
            return results;
        }
        Calendar calStart = this.getStartDate();
        Calendar currentDate = (Calendar)queryDate.clone();
        if (calStart != null) {
            if (AbstractRecurrence.isBeforeByDay(currentDate, calStart)) {
                currentDate = (Calendar)calStart.clone();
            } else if (this.getSkipCount() > 1) {
                currentDate = (Calendar)calStart.clone();
                currentDate.set(5, 1);
                this.moveCurrentDateJustBeforeQueryDate(currentDate, queryDate, this.getSkipCount(), 2);
            }
        }
        int dayOfMonth = this.getDayOfMonth();
        int dayOfWeek = this.getDayOfWeek();
        int whichWeek = this.getWhichWeek();
        while (!AbstractRecurrence.isAfterByDay(currentDate, endQueryDate)) {
            boolean useThisDay = true;
            if (dayOfMonth > 0) {
                int maxDay = currentDate.getActualMaximum(5);
                if (maxDay >= dayOfMonth) {
                    currentDate.set(5, dayOfMonth);
                } else {
                    useThisDay = false;
                }
            } else if (dayOfWeek == 128) {
                int ordinalIndex = MonthlyRecurrence.getDayOfMonthFromOrdinal(currentDate, whichWeek);
                currentDate.set(5, ordinalIndex);
            } else {
                int calendarWeekDay = WeeklyRecurrence.getCalendarWeekDay(dayOfWeek);
                currentDate.set(7, calendarWeekDay);
                int ordinalIndex = MonthlyRecurrence.getWeekOfMonthFromOrdinal(whichWeek);
                currentDate.set(8, ordinalIndex);
            }
            if (useThisDay && !AbstractRecurrence.isBeforeByDay(currentDate, queryDate) && this.isDateInRange(currentDate)) {
                if (AbstractRecurrence.isAfterByDay(currentDate, endQueryDate)) break;
                results.add((Calendar)currentDate.clone());
                if (count > 0 && results.size() >= count) break;
            }
            currentDate.add(2, this.getSkipCount());
            currentDate.set(5, 1);
            if (!this.isDateAfterRange(currentDate)) continue;
            break;
        }
        return results;
    }

    protected static int getDayOfMonthFromOrdinal(Calendar currentDate, int ordinal) throws InvalidRecurrenceException {
        switch (ordinal) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return currentDate.getActualMaximum(5);
            }
        }
        throw new InvalidRecurrenceException();
    }

    protected static int getWeekOfMonthFromOrdinal(int ordinal) throws InvalidRecurrenceException {
        switch (ordinal) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return -1;
            }
        }
        throw new InvalidRecurrenceException();
    }

    protected static boolean isDateAllowedUnderOrdinalSettings(Calendar queryDate, int dayOfWeek, int whichWeek) throws InvalidRecurrenceException {
        int queryDayOfWeek = queryDate.get(7);
        if (MonthlyRecurrence.matchesCalendarDay(queryDayOfWeek, dayOfWeek)) {
            int ordinalIndex;
            int queryDay = queryDate.get(5);
            int ordinal = whichWeek;
            if (ordinal == 6 ? queryDay <= queryDate.getActualMaximum(5) - 7 : queryDay <= ((ordinalIndex = MonthlyRecurrence.getWeekOfMonthFromOrdinal(ordinal)) - 1) * 7 || queryDay > ordinalIndex * 7) {
                return false;
            }
        } else if (dayOfWeek == 128) {
            int ordinalIndex = MonthlyRecurrence.getDayOfMonthFromOrdinal(queryDate, whichWeek);
            int queryDay = queryDate.get(5);
            if (queryDay != ordinalIndex) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected static boolean matchesCalendarDay(int queryDayOfWeek, int calDayOfWeek) {
        int calendarClassDay = WeeklyRecurrence.getCalendarWeekDay(calDayOfWeek);
        return queryDayOfWeek == calendarClassDay;
    }

    @Override
    public void copyFrom(IRecurrenceInfo source) {
        if (source instanceof MonthlyRecurrence) {
            MonthlyRecurrence recurrence = (MonthlyRecurrence)source;
            super.copyFrom(recurrence);
            this.dayOfMonthDataBinding = recurrence.dayOfMonthDataBinding;
            this.dayOfWeekDataBinding = recurrence.dayOfWeekDataBinding;
            this.whichWeekDataBinding = recurrence.whichWeekDataBinding;
        }
    }

    @Override
    public void toXML(StringBuffer buffer) {
        buffer.append("<");
        buffer.append(XML_Month_Tag);
        if (this.dayOfMonthDataBinding >= 1) {
            buffer.append(' ');
            buffer.append(XML_Day_Of_Month);
            buffer.append('=');
            buffer.append('\"');
            buffer.append(this.dayOfMonthDataBinding);
            buffer.append('\"');
        }
        if (this.dayOfWeekDataBinding >= 0 && this.whichWeekDataBinding >= 0) {
            buffer.append(' ');
            buffer.append(XML_Day_Of_Week);
            buffer.append("=");
            buffer.append('\"');
            buffer.append(this.dayOfWeekDataBinding);
            buffer.append('\"');
            buffer.append(' ');
            buffer.append(XML_Which_Week);
            buffer.append("=");
            buffer.append('\"');
            buffer.append(this.whichWeekDataBinding);
            buffer.append('\"');
        }
        buffer.append(">");
        super.toXML(buffer);
        buffer.append("</");
        buffer.append(XML_Month_Tag);
        buffer.append(">");
    }

    @Override
    public void injectXML(Document doc, Element parent) {
        Element tag = doc.createElement(XML_Month_Tag);
        parent.appendChild(tag);
        if (this.dayOfMonthDataBinding >= 1) {
            tag.setAttribute(XML_Day_Of_Month, Integer.toString(this.dayOfMonthDataBinding));
        }
        if (this.dayOfWeekDataBinding >= 0 && this.whichWeekDataBinding >= 0) {
            tag.setAttribute(XML_Day_Of_Week, Integer.toString(this.dayOfWeekDataBinding));
            tag.setAttribute(XML_Which_Week, Integer.toString(this.whichWeekDataBinding));
        }
        super.injectXML(doc, tag);
    }

    @Override
    public void toShortUniqueString(StringBuffer buffer) {
        buffer.append("MO_");
        if (this.dayOfMonthDataBinding >= 1) {
            buffer.append("dm" + this.dayOfMonthDataBinding + '_');
        }
        if (this.dayOfWeekDataBinding >= 0 && this.whichWeekDataBinding >= 0) {
            buffer.append("dw" + this.dayOfWeekDataBinding + "ww" + this.whichWeekDataBinding + '_');
        }
        super.toShortUniqueString(buffer);
    }
}

