/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileInfo;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="JobInfo", propOrder={"batchServerDataBinding", "jobDataBinding", "originalSourceFileDataBinding", "sourceDirDataBinding", "sourceFileDataBinding", "commandLineDataBinding", "commandLineDerivedDataBinding", "rawCommandLineDataBinding", "jclDataBinding", "jobPriorityDataBinding", "responsiblePartyDataBinding", "runAsDataBinding", "schedulerPropertiesDataBinding", "schedulerResourcesDataBinding", "subFlowDataBinding", "subFlowJobIdsDataBinding", "jobArgsDataBinding", "encodedJobArgsDataBinding"})
public class JobInfo
extends DisplayInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="BatchServer", required=true)
    protected BatchServerInfo batchServerDataBinding;
    @XmlElement(name="Job", required=true)
    protected DisplayInfo jobDataBinding;
    @XmlElement(name="OriginalSourceFile")
    protected FileInfo originalSourceFileDataBinding;
    @XmlElement(name="SourceDirectory")
    protected DirectoryInfo sourceDirDataBinding;
    @XmlElement(name="SourceFile")
    protected String sourceFileDataBinding;
    @XmlElement(name="CommandLine", required=true)
    protected String commandLineDataBinding;
    @XmlElement(name="CommandLineDerived")
    protected boolean commandLineDerivedDataBinding;
    @XmlElement(name="RawCommandLine")
    protected String rawCommandLineDataBinding;
    @XmlElement(name="JCL")
    protected String jclDataBinding;
    @XmlElement(name="JobPriority")
    protected Integer jobPriorityDataBinding;
    @XmlElement(name="ResponsibleParty")
    protected String responsiblePartyDataBinding;
    @XmlElement(name="RunAs")
    protected String runAsDataBinding;
    @XmlElement(name="SchedulerProperties")
    protected String schedulerPropertiesDataBinding;
    @XmlElement(name="SchedulerResources")
    protected String schedulerResourcesDataBinding;
    @XmlElement(name="SubFlow")
    protected boolean subFlowDataBinding;
    @XmlElement(name="SubFlowJobIds")
    protected List<String> subFlowJobIdsDataBinding;
    @XmlElement(name="JobArgs")
    protected String jobArgsDataBinding;
    @XmlElement(name="EncodedJobArgs")
    protected String encodedJobArgsDataBinding;
    private static final ResourceBundle m_bundle;
    @XmlTransient
    private boolean m_hasErrors;
    public static final String ReplaceTag_JFJobID = "%%JFJobID%%";
    public static final String IconName;
    public static final String IconError;
    public static final int ANY_BATCH_SERVER = -1;
    public static final int GENERIC_BATCH_SERVER = 0;
    public static final int DATA_STEP_BATCH_SERVER = 1;
    public static final int JAVA_BATCH_SERVER = 2;
    public static final int JAVA_BATCH_CampaignManager = 10;
    public static final int JAVA_BATCH_BusinessReportManager = 11;

    public BatchServerInfo getBatchServerDataBinding() {
        return this.batchServerDataBinding;
    }

    public void setBatchServerDataBinding(BatchServerInfo value) {
        this.batchServerDataBinding = value;
    }

    public DisplayInfo getJobDataBinding() {
        return this.jobDataBinding;
    }

    public void setJobDataBinding(DisplayInfo value) {
        this.jobDataBinding = value;
    }

    public FileInfo getOriginalSourceFileDataBinding() {
        return this.originalSourceFileDataBinding;
    }

    public void setOriginalSourceFileDataBinding(FileInfo value) {
        this.originalSourceFileDataBinding = value;
    }

    public DirectoryInfo getSourceDirDataBinding() {
        return this.sourceDirDataBinding;
    }

    public void setSourceDirDataBinding(DirectoryInfo value) {
        this.sourceDirDataBinding = value;
    }

    public String getSourceFileDataBinding() {
        return this.sourceFileDataBinding;
    }

    public void setSourceFileDataBinding(String value) {
        this.sourceFileDataBinding = value;
    }

    public String getCommandLineDataBinding() {
        return this.commandLineDataBinding;
    }

    public void setCommandLineDataBinding(String value) {
        this.commandLineDataBinding = value;
    }

    public boolean isCommandLineDerivedDataBinding() {
        return this.commandLineDerivedDataBinding;
    }

    public void setCommandLineDerivedDataBinding(boolean value) {
        this.commandLineDerivedDataBinding = value;
    }

    public String getRawCommandLineDataBinding() {
        return this.rawCommandLineDataBinding;
    }

    public void setRawCommandLineDataBinding(String value) {
        this.rawCommandLineDataBinding = value;
    }

    public String getJclDataBinding() {
        return this.jclDataBinding;
    }

    public void setJclDataBinding(String value) {
        this.jclDataBinding = value;
    }

    public Integer getJobPriorityDataBinding() {
        return this.jobPriorityDataBinding;
    }

    public void setJobPriorityDataBinding(Integer value) {
        this.jobPriorityDataBinding = value;
    }

    public String getResponsiblePartyDataBinding() {
        return this.responsiblePartyDataBinding;
    }

    public void setResponsiblePartyDataBinding(String value) {
        this.responsiblePartyDataBinding = value;
    }

    public String getRunAsDataBinding() {
        return this.runAsDataBinding;
    }

    public void setRunAsDataBinding(String value) {
        this.runAsDataBinding = value;
    }

    public String getSchedulerPropertiesDataBinding() {
        return this.schedulerPropertiesDataBinding;
    }

    public void setSchedulerPropertiesDataBinding(String value) {
        this.schedulerPropertiesDataBinding = value;
    }

    public String getSchedulerResourcesDataBinding() {
        return this.schedulerResourcesDataBinding;
    }

    public void setSchedulerResourcesDataBinding(String value) {
        this.schedulerResourcesDataBinding = value;
    }

    public boolean isSubFlowDataBinding() {
        return this.subFlowDataBinding;
    }

    public void setSubFlowDataBinding(boolean value) {
        this.subFlowDataBinding = value;
    }

    public List<String> getSubFlowJobIdsDataBinding() {
        if (this.subFlowJobIdsDataBinding == null) {
            this.subFlowJobIdsDataBinding = new ArrayList<String>();
        }
        return this.subFlowJobIdsDataBinding;
    }

    public String getJobArgsDataBinding() {
        return this.jobArgsDataBinding;
    }

    public void setJobArgsDataBinding(String value) {
        this.jobArgsDataBinding = value;
    }

    public String getEncodedJobArgsDataBinding() {
        return this.encodedJobArgsDataBinding;
    }

    public void setEncodedJobArgsDataBinding(String value) {
        this.encodedJobArgsDataBinding = value;
    }

    public void setSubFlowJobIdsDataBinding(List<String> subFlowJobIdsDataBinding) {
        this.subFlowJobIdsDataBinding = subFlowJobIdsDataBinding;
    }

    public JobInfo() {
        this.subFlowJobIdsDataBinding = new ArrayList<String>();
        this.jobPriorityDataBinding = -1;
    }

    public JobInfo(String name, String id, int batchserver) {
        super(name, null, IconName);
        this.setId(id);
        try {
            if (batchserver >= 10 && batchserver <= 26) {
                this.setBatchServer(2, batchserver);
            } else {
                this.setBatchServer(batchserver, -1);
            }
        }
        catch (InvalidParameterException ipe) {
            this.m_hasErrors = true;
        }
        this._init();
    }

    public JobInfo(String name, String id, BatchServerInfo batchserver) {
        super(name, null, IconName);
        this.setId(id);
        this.batchServerDataBinding = batchserver;
        this._init();
    }

    private void _init() {
        this.subFlowJobIdsDataBinding = new ArrayList<String>();
        this.commandLineDerivedDataBinding = true;
        this.jobPriorityDataBinding = -1;
    }

    public boolean hasErrors() {
        return this.m_hasErrors;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String toString(Locale locale) {
        return this.getName();
    }

    public static String getIconName(boolean errors) {
        if (errors) {
            return m_bundle.getString("JobErrorsNode.image");
        }
        return m_bundle.getString("JobNode.image");
    }

    public String getUniqueName() {
        return this.getName() + this.getId();
    }

    public String getType() {
        return "JOB";
    }

    public String getCommandLine() {
        return this.commandLineDataBinding;
    }

    public boolean isCommandLineDerived() {
        return this.commandLineDerivedDataBinding;
    }

    public boolean setCommandLineDerived(boolean flag) {
        this.commandLineDerivedDataBinding = flag;
        return true;
    }

    public boolean setCommandLine(String cmd) {
        this.commandLineDataBinding = cmd;
        return true;
    }

    public boolean setCommandLine(String cmd, boolean flag) {
        this.commandLineDataBinding = cmd;
        this.commandLineDerivedDataBinding = flag;
        return true;
    }

    public boolean setCommandLine(String cmd, String rawCmd, boolean flag) {
        this.commandLineDataBinding = cmd;
        this.rawCommandLineDataBinding = rawCmd;
        this.commandLineDerivedDataBinding = flag;
        return true;
    }

    public String getRawCommandLine() {
        if (this.rawCommandLineDataBinding == null) {
            return this.getCommandLine();
        }
        return this.rawCommandLineDataBinding;
    }

    public boolean setRawCommandLine(String cmd) {
        this.rawCommandLineDataBinding = cmd;
        return true;
    }

    public String getJCL() {
        return this.jclDataBinding;
    }

    public boolean setJCL(String jcl) {
        this.jclDataBinding = jcl;
        return true;
    }

    public int getJobPriority() {
        return this.jobPriorityDataBinding;
    }

    public boolean setJobPriority(int id) {
        this.jobPriorityDataBinding = id;
        return true;
    }

    public String getUserId() {
        return this.runAsDataBinding;
    }

    public boolean setUserId(String runas) {
        this.runAsDataBinding = runas;
        return true;
    }

    public String getSourceFile() {
        return this.sourceFileDataBinding;
    }

    public boolean setSourceFile(String sourcefile) {
        this.sourceFileDataBinding = sourcefile;
        return true;
    }

    public DirectoryInfo getSourceDir() {
        return this.sourceDirDataBinding;
    }

    public boolean setSourceDir(DirectoryInfo directory) {
        this.sourceDirDataBinding = directory;
        return true;
    }

    public DisplayInfo getJob() {
        return this.jobDataBinding;
    }

    public boolean setJob(DisplayInfo job) {
        this.jobDataBinding = job;
        return true;
    }

    public boolean isSubflow() {
        return this.subFlowDataBinding;
    }

    public void setAsSubflow() {
        this.subFlowDataBinding = true;
    }

    public void setSubflowJobIDs(List<String> ids) {
        this.subFlowJobIdsDataBinding.addAll(ids);
        this.subFlowDataBinding = true;
    }

    public List<String> getSubflowJobIDs() {
        return this.subFlowJobIdsDataBinding;
    }

    public void setAsJob() {
        this.subFlowDataBinding = false;
    }

    public String getSchedulerResources() {
        return this.schedulerResourcesDataBinding;
    }

    public boolean setSchedulerResources(String resource) {
        this.schedulerResourcesDataBinding = resource;
        return true;
    }

    public String getSchedulerProperties() {
        return this.schedulerPropertiesDataBinding;
    }

    public boolean setSchedulerProperties(String properties) {
        this.schedulerPropertiesDataBinding = properties;
        return true;
    }

    public String getJobArgs() {
        return this.jobArgsDataBinding;
    }

    public void setJobArgs(String args) {
        this.jobArgsDataBinding = args;
    }

    public String getEncodedArgs() {
        return this.encodedJobArgsDataBinding;
    }

    public void setEncodedArgs(String args) {
        this.encodedJobArgsDataBinding = args;
    }

    public BatchServerInfo getBatchServer() {
        return this.batchServerDataBinding;
    }

    public int getBatchServerType() {
        if (this.batchServerDataBinding != null) {
            return this.batchServerDataBinding.getType();
        }
        return -2;
    }

    public int getBatchServerSubtype() {
        if (this.batchServerDataBinding != null) {
            return this.batchServerDataBinding.getSubType();
        }
        return -2;
    }

    public boolean setBatchServer(BatchServerInfo batchserver) {
        this.batchServerDataBinding = batchserver;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setBatchServer(int batchserver, int subtype) throws InvalidParameterException {
        block5: {
            if (batchserver == -1) {
                this.batchServerDataBinding = new BatchServerInfo(null, batchserver, subtype);
            } else {
                if (batchserver >= 0 && batchserver <= 2) {
                    if (batchserver != 2 || subtype >= 10 && subtype <= 26) {
                        this.batchServerDataBinding = new BatchServerInfo(null, batchserver, subtype);
                        break block5;
                    } else {
                        this.batchServerDataBinding = null;
                        this.m_hasErrors = true;
                        String message = m_bundle.getString("JobInfo.InvalidJavaBatchSubTypeServer.txt");
                        InvalidParameterException ex = new InvalidParameterException(message);
                        throw ex;
                    }
                }
                this.batchServerDataBinding = null;
                this.m_hasErrors = true;
                String message = m_bundle.getString("JobInfo.InvalidBatchServer.txt");
                InvalidParameterException ex = new InvalidParameterException(message);
                throw ex;
            }
        }
        this.m_hasErrors = false;
        return true;
    }

    public void setError() {
        this.m_hasErrors = true;
    }

    public void clearError() {
        this.m_hasErrors = false;
    }

    static {
        String strClassName = JobInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("JobNode.image");
        IconError = m_bundle.getString("JobErrorsNode.image");
    }
}

