/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowEventInterface;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.JobDependency;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.TimeEventInfo;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JobDefinitionInfo
implements FlowEventInterface,
AbstractEventInterface {
    public static final int JOB_TYPE = 0;
    public static final int FLOW_TYPE = 1;
    protected static final String JobDefTag = "PlatformIndependentTimeEventV1:";
    protected static final String JobDefDefinitionSeparator = "||";
    protected static final String JobDefName = "Name:";
    protected static final String JobDefCommand = "Command:";
    protected static final String JobDefUser = "User:";
    protected String m_type;
    protected String m_command;
    protected String m_username;
    protected AbstractEventInterface m_dependency;
    protected String m_name;
    protected String m_description;
    protected String m_id;
    protected boolean m_depCheckAlwaysFalse;
    public static final String TYPE_JOB = "Job";
    public static final String TYPE_SUBFLOW = "subFlow";

    public JobDefinitionInfo(String name, int type, String command, String username) {
        this.m_name = name;
        this.m_type = type == 1 ? TYPE_SUBFLOW : TYPE_JOB;
        this.m_command = this.quoteIt(command);
        this.m_username = username;
    }

    public JobDefinitionInfo(String name, String id, int type, String command, String username) {
        this.m_name = name;
        this.m_id = id;
        this.m_type = type == 1 ? TYPE_SUBFLOW : TYPE_JOB;
        this.m_command = this.quoteIt(command);
        this.m_username = username;
    }

    public boolean addDependency(AbstractEventInterface event) {
        this.m_dependency = event;
        return true;
    }

    public AbstractEventInterface getDependency() {
        return this.m_dependency;
    }

    public String getName() {
        return this.m_name;
    }

    public String getCommand() {
        return this.m_command;
    }

    public String getUsername() {
        return this.m_username;
    }

    @Override
    public String generateXML() {
        if (this.m_name == null) {
            return "";
        }
        if (this.m_command == null) {
            return "";
        }
        StringBuffer jobXML = new StringBuffer();
        jobXML.append("<JobDef Name=\"" + this.m_name + "\" " + "Id" + "=\"" + this.m_id + "\" " + "Type" + "=\"" + this.m_type + "\">\n");
        jobXML.append("<JobCmdLine Value=\"" + this.m_command + "\"/>\n");
        if (this.m_username != null) {
            jobXML.append("<UserName Value=\"" + this.m_username + "\"/>\n");
        }
        jobXML.append("</JobDef>\n");
        return jobXML.toString();
    }

    public static JobInfo initJobFromNode(Node cnode) throws SchedulerException {
        JobInfo job = null;
        try {
            NamedNodeMap attrs = cnode.getAttributes();
            String jobName = attrs.getNamedItem("Name").getNodeValue();
            Node tnode2 = attrs.getNamedItem("Id");
            String jobId = null;
            if (tnode2 != null && tnode2.getNodeValue().length() > 0) {
                jobId = tnode2.getNodeValue();
            }
            String jobType = attrs.getNamedItem("Type").getNodeValue();
            String jobCmd = null;
            String runAs = null;
            if (jobType.compareTo(TYPE_JOB) == 0 || jobType.compareTo(TYPE_SUBFLOW) == 0) {
                NodeList snodes = cnode.getChildNodes();
                int numSNodes = snodes.getLength();
                for (int y = 0; y < numSNodes; ++y) {
                    NamedNodeMap sattrs;
                    Node snode = snodes.item(y);
                    String stagname = snode.getNodeName();
                    if (stagname.compareTo("JobCmdLine") == 0) {
                        sattrs = snode.getAttributes();
                        jobCmd = sattrs.getNamedItem("Value").getNodeValue();
                        continue;
                    }
                    if (stagname.compareTo("UserName") != 0) continue;
                    sattrs = snode.getAttributes();
                    runAs = sattrs.getNamedItem("Value").getNodeValue();
                }
                job = new JobInfo(jobName, jobId, null);
                if (jobType.compareTo(TYPE_SUBFLOW) == 0) {
                    job.setAsSubflow();
                }
                job.setCommandLine(jobCmd, false);
                job.setRunAsDataBinding(runAs);
            }
            return job;
        }
        catch (NullPointerException npe) {
            SchedulerException se = new SchedulerException();
            se.initCause(npe);
            throw se;
        }
        catch (RuntimeException rte) {
            SchedulerException se = new SchedulerException();
            se.initCause(rte);
            throw se;
        }
    }

    public String generateDependenciesXML() {
        return this.generateDependenciesXML(false);
    }

    public String generateDependenciesXML(boolean exportFormat) {
        if (this.m_dependency == null) {
            return null;
        }
        if (this.m_name == null) {
            return null;
        }
        if (this.m_type == null) {
            return null;
        }
        StringBuffer depXML = new StringBuffer();
        String desc = this.m_dependency.getDescription();
        boolean reset = false;
        if (desc == null || desc.indexOf(60) >= 0 || desc.indexOf(34) >= 0) {
            reset = true;
            this.m_dependency.setDescription("");
        }
        depXML.append("<Dependencies  Name=\"" + this.m_dependency.toString() + "\" Type = \"" + this.m_type + "\" Reference=\"" + this.m_name + "\" Description=\"" + this.m_dependency.getDescription() + "\">\n");
        if (this.m_dependency instanceof GroupingEventInfo) {
            depXML.append(this.m_dependency.generateXML(exportFormat));
        } else {
            String xml = this.m_dependency.generateXML(exportFormat);
            if (xml != null) {
                depXML.append("<Events CombinationType=\"OR\">\n");
                depXML.append(xml);
                depXML.append("</Events>\n");
            }
        }
        depXML.append("</Dependencies>\n");
        if (reset) {
            this.m_dependency.setDescription(desc);
        }
        return depXML.toString();
    }

    public static JobDependency initDepFromNode(HashMap<String, DisplayInfo> jobs, Node node) throws SchedulerException {
        JobDependency dep;
        block6: {
            dep = new JobDependency();
            try {
                NamedNodeMap map = node.getAttributes();
                String jobName = map.getNamedItem("Reference").getNodeValue();
                String type = map.getNamedItem("Type").getNodeValue();
                if (type.compareTo(TYPE_JOB) == 0 || type.compareTo(TYPE_SUBFLOW) == 0) {
                    DisplayInfo job = jobs.get(jobName);
                    dep.setNodeId(job.getId());
                    NodeList snodes = node.getChildNodes();
                    int numSNodes = snodes.getLength();
                    for (int y = 0; y < numSNodes; ++y) {
                        Node snode = snodes.item(y);
                        String stagname = snode.getNodeName();
                        if (stagname.compareTo("Events") != 0) continue;
                        GroupingEventInfo event = JobDefinitionInfo.processEvents(snode, job, jobs);
                        if (event.getEvents().size() == 1) {
                            dep.setEvent(event.getEvents().get(0));
                            continue;
                        }
                        dep.setEvent(event);
                    }
                    break block6;
                }
                SchedulerException se = new SchedulerException("Invalid Type");
                throw se;
            }
            catch (NullPointerException npe) {
                SchedulerException se = new SchedulerException();
                se.initCause(npe);
                throw se;
            }
            catch (RuntimeException rte) {
                SchedulerException se = new SchedulerException();
                se.initCause(rte);
                throw se;
            }
        }
        return dep;
    }

    private static GroupingEventInfo processEvents(Node node, DisplayInfo job, HashMap<String, DisplayInfo> jobs) throws SchedulerException {
        NamedNodeMap sattrs = node.getAttributes();
        String mainCombination = sattrs.getNamedItem("CombinationType").getNodeValue();
        int condition = 1;
        if (mainCombination.compareToIgnoreCase("AND") == 0) {
            condition = 0;
        }
        GroupingEventInfo info = null;
        if (job instanceof JobInfo) {
            info = new GroupingEventInfo((JobInfo)job, condition);
        } else if (job instanceof FlowInfo) {
            info = new GroupingEventInfo((FlowInfo)job);
            info.setEventType(condition);
        }
        NodeList cnodes = node.getChildNodes();
        int numNodes = cnodes.getLength();
        for (int y = 0; y < numNodes; ++y) {
            Node cnode = cnodes.item(y);
            String tagname = cnode.getNodeName();
            if (tagname.compareTo("Events") == 0) {
                GroupingEventInfo event = JobDefinitionInfo.processEvents(cnode, job, jobs);
                info.addDependency(event);
                continue;
            }
            if (tagname.compareTo("Event") != 0) continue;
            NamedNodeMap attrs = cnode.getAttributes();
            String type = attrs.getNamedItem("Type").getNodeValue();
            if (type.compareTo(TYPE_JOB) == 0 || type.compareTo(TYPE_SUBFLOW) == 0) {
                JobEventInfo je = new JobEventInfo();
                je.initFromNode(cnode, jobs);
                info.addDependency(je);
                continue;
            }
            if (type.compareTo("Time") == 0) {
                TimeEventInfo te = new TimeEventInfo();
                te.initFromNode(cnode);
                info.addDependency(te);
                continue;
            }
            if (type.compareTo("File") != 0) continue;
            FileEventInfo fe = new FileEventInfo();
            fe.initFromNode(cnode);
            info.addDependency(fe);
        }
        return info;
    }

    @Override
    public boolean setDescription(String sDescription) {
        this.m_description = sDescription;
        return true;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    private String quoteIt(String text) {
        int strlen = text.length();
        StringBuffer newtext = new StringBuffer();
        for (int j = 0; j < strlen; ++j) {
            if (text.charAt(j) == '\"') {
                newtext.append("&quot;");
                continue;
            }
            newtext.append(text.charAt(j));
        }
        return newtext.toString();
    }

    @Override
    public String generateXML(boolean exportFormat) {
        return null;
    }

    @Override
    public boolean getDepCheckAlwaysFalse() {
        return this.m_depCheckAlwaysFalse;
    }

    @Override
    public void setDepCheckAlwaysFalse(boolean depCheckAlwaysFalse) {
        this.m_depCheckAlwaysFalse = depCheckAlwaysFalse;
    }
}

