/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GeneralUtilities {
    private GeneralUtilities() {
    }

    public static String replaceString(String s, String searchString, String replaceString) {
        if (s != null) {
            while (s.indexOf(searchString) != -1) {
                if (s.startsWith(searchString)) {
                    s = replaceString + s.substring(s.indexOf(searchString) + searchString.length());
                    continue;
                }
                s = s.substring(0, s.indexOf(searchString)) + replaceString + s.substring(s.indexOf(searchString) + searchString.length());
            }
        }
        return s;
    }

    public static String replaceFirstString(String s, String searchString, String replaceString) {
        int index = s.indexOf(searchString);
        if (index != -1) {
            s = s.substring(0, index) + replaceString + s.substring(index + searchString.length());
        }
        return s;
    }

    public static String normalize(String text) {
        return text.toLowerCase(Locale.US);
    }

    public static Document parseXML(String strXML) throws SchedulerException {
        StringReader strReader = new StringReader(strXML);
        Document doc = null;
        DocumentBuilder docBld = null;
        try {
            docBld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            SchedulerException ex = new SchedulerException();
            ex.initCause(e);
            throw ex;
        }
        try {
            doc = docBld.parse(new InputSource(strReader));
        }
        catch (IOException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getMessage());
            ex.initCause(ioe);
            throw ex;
        }
        catch (SAXException e) {
            SchedulerException ex = new SchedulerException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return doc;
    }

    public static String getOperatorSymbolString(int operator) {
        if (-1 == operator) {
            return "";
        }
        String opString = null;
        switch (operator) {
            case 21: {
                opString = FlowInfo.ArithmeticOperator_Equal_Symbol;
                break;
            }
            case 22: {
                opString = FlowInfo.ArithmeticOperator_NotEqual_Symbol;
                break;
            }
            case 23: {
                opString = FlowInfo.ArithmeticOperator_GreaterThan_Symbol;
                break;
            }
            case 24: {
                opString = FlowInfo.ArithmeticOperator_GreaterThanEqual_Symbol;
                break;
            }
            case 25: {
                opString = FlowInfo.ArithmeticOperator_LessThan_Symbol;
                break;
            }
            case 26: {
                opString = FlowInfo.ArithmeticOperator_LessThanEqual_Symbol;
            }
        }
        return opString;
    }

    public static String getOperatorString(int operator) {
        if (-1 == operator) {
            return "";
        }
        String opString = null;
        switch (operator) {
            case 21: {
                opString = FlowInfo.ArithmeticOperator_Equal_Text;
                break;
            }
            case 22: {
                opString = FlowInfo.ArithmeticOperator_NotEqual_Text;
                break;
            }
            case 23: {
                opString = FlowInfo.ArithmeticOperator_GreaterThan_Text;
                break;
            }
            case 24: {
                opString = FlowInfo.ArithmeticOperator_GreaterThanEqual_Text;
                break;
            }
            case 25: {
                opString = FlowInfo.ArithmeticOperator_LessThan_Text;
                break;
            }
            case 26: {
                opString = FlowInfo.ArithmeticOperator_LessThanEqual_Text;
            }
        }
        return opString;
    }

    public static int getOperatorFromString(String operator) {
        if (null == operator) {
            return -1;
        }
        int opvalue = -1;
        if (operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_Equal_Text) || operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_Equal_Symbol)) {
            opvalue = 21;
        } else if (operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_NotEqual_Text) || operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_NotEqual_Symbol)) {
            opvalue = 22;
        } else if (operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_GreaterThan_Text) || operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_GreaterThan_Symbol)) {
            opvalue = 23;
        } else if (operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_GreaterThanEqual_Text) || operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_GreaterThanEqual_Symbol)) {
            opvalue = 24;
        } else if (operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_LessThan_Text) || operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_LessThan_Symbol)) {
            opvalue = 25;
        } else if (operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_LessThanEqual_Text) || operator.equalsIgnoreCase(FlowInfo.ArithmeticOperator_LessThanEqual_Symbol)) {
            opvalue = 26;
        }
        return opvalue;
    }
}

