/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class FlowPFD
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private String m_text;
    private static char[] hexChar;
    private static byte[] correspondingNibble;

    public FlowPFD() {
    }

    public FlowPFD(ByteArrayOutputStream data) {
        byte[] bytes = data.toByteArray();
        this.m_text = FlowPFD.toHexString(bytes);
    }

    public FlowPFD(String data) {
        this.m_text = data;
    }

    public ByteArrayInputStream getData() {
        if (this.m_text != null) {
            ByteArrayInputStream input = new ByteArrayInputStream(FlowPFD.fromHexString(this.m_text));
            return input;
        }
        return null;
    }

    public String getTextData() {
        return this.m_text;
    }

    private static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    private static byte[] fromHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("FlowPFD.InvalidHexFormat.txt");
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = FlowPFD.charToNibble(s.charAt(i));
            int low = FlowPFD.charToNibble(s.charAt(i + 1));
            b[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return b;
    }

    private static int charToNibble(char c) {
        byte nibble = correspondingNibble[c];
        if (nibble < 0) {
            throw new IllegalArgumentException(MessageFormat.format(m_bundle.getString("FlowPFD.InvalidHexCharacter.fmt"), String.valueOf(c)));
        }
        return nibble;
    }

    static {
        int i;
        String strClassName = FlowPFD.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        correspondingNibble = new byte[103];
        for (i = 0; i <= 102; ++i) {
            FlowPFD.correspondingNibble[i] = -1;
        }
        for (i = 48; i <= 57; ++i) {
            FlowPFD.correspondingNibble[i] = (byte)(i - 48);
        }
        for (i = 65; i <= 70; ++i) {
            FlowPFD.correspondingNibble[i] = (byte)(i - 65 + 10);
        }
        for (i = 97; i <= 102; ++i) {
            FlowPFD.correspondingNibble[i] = (byte)(i - 97 + 10);
        }
    }
}

