/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.ColumnSelectorModelInterface;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class FlowColumnSelectorModel
implements ColumnSelectorModelInterface,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    public static final int DefaultColumns = 0;
    public static final int NameColumnOnly = 1;
    public static final int NAME_COLUMN = 0;
    public static final int SIZE_COLUMN = 1;
    public static final int DATE_CREATED_COLUMN = 2;
    public static final int DATE_MODIFIED_COLUMN = 3;
    public static final int LAST_EXECUTION_COLUMN = 4;
    public static final int ID_COLUMN = 5;
    public static final int SERVER_COLUMN = 6;
    public static final int APPLICATION_COLUMN = 7;
    public static final int USERNAME_COLUMN = 8;
    public static final int LOCATION_COLUMN = 9;
    public static final int MAXCOLUMNS = 10;
    protected Vector<String> m_columns = new Vector(3);
    protected Vector<String> m_hideColumns = new Vector(3);

    public FlowColumnSelectorModel(int type) {
        switch (type) {
            case 0: {
                this.addColumnToDisplay(0, false);
                this.addColumnToDisplay(1, true);
                this.addColumnToDisplay(2, false);
                this.addColumnToDisplay(3, false);
                this.addColumnToDisplay(4, true);
                this.addColumnToDisplay(5, true);
                this.addColumnToDisplay(6, true);
                this.addColumnToDisplay(8, true);
                this.addColumnToDisplay(9, true);
                break;
            }
            case 1: {
                this.addColumnToDisplay(0, false);
                break;
            }
        }
    }

    @Override
    public boolean addColumnToDisplay(int columnKey, boolean hide) {
        boolean rc = this.m_columns.add(String.valueOf(columnKey));
        if (hide) {
            this.m_hideColumns.add("true");
        } else {
            this.m_hideColumns.add("false");
        }
        return rc;
    }

    @Override
    public boolean isHidden(int index) {
        String flag = this.m_hideColumns.get(index);
        return flag.compareTo("true") == 0;
    }

    private int getColumnKey(int index) {
        return Integer.parseInt(this.m_columns.get(index));
    }

    @Override
    public String getColumnName(int index) {
        int columnKey = this.getColumnKey(index);
        return this.getColumnNameByKey(columnKey);
    }

    @Override
    public int getColumnType(String columnName) {
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.Name.txt")) == 0) {
            return 0;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Size.txt")) == 0) {
            return 1;
        }
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.CreationDate.txt")) == 0) {
            return 2;
        }
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.ModificationDate.txt")) == 0) {
            return 2;
        }
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.Location.txt")) == 0) {
            return 0;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.LastExecution.txt")) == 0) {
            return 0;
        }
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.Id.txt")) == 0) {
            return 0;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Server.txt")) == 0) {
            return 0;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Application.txt")) == 0) {
            return 0;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Username.txt")) == 0) {
            return 0;
        }
        return 0;
    }

    public static int getColumnKeyFromName(String columnName) {
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.Name.txt")) == 0) {
            return 0;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Size.txt")) == 0) {
            return 1;
        }
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.CreationDate.txt")) == 0) {
            return 2;
        }
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.ModificationDate.txt")) == 0) {
            return 3;
        }
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.Location.txt")) == 0) {
            return 9;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.LastExecution.txt")) == 0) {
            return 4;
        }
        if (columnName.compareTo(m_bundle.getString("ColumnSelectorModel.ColumnHeader.Id.txt")) == 0) {
            return 5;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Server.txt")) == 0) {
            return 6;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Application.txt")) == 0) {
            return 7;
        }
        if (columnName.compareTo(m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Username.txt")) == 0) {
            return 8;
        }
        return -1;
    }

    @Override
    public String getColumnNameByKey(int columnKey) {
        return FlowColumnSelectorModel.getColumnNameForKey(columnKey);
    }

    public static String getColumnNameForKey(int columnKey) {
        switch (columnKey) {
            case 0: {
                return m_bundle.getString("ColumnSelectorModel.ColumnHeader.Name.txt");
            }
            case 1: {
                return m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Size.txt");
            }
            case 2: {
                return m_bundle.getString("ColumnSelectorModel.ColumnHeader.CreationDate.txt");
            }
            case 3: {
                return m_bundle.getString("ColumnSelectorModel.ColumnHeader.ModificationDate.txt");
            }
            case 9: {
                return m_bundle.getString("ColumnSelectorModel.ColumnHeader.Location.txt");
            }
            case 4: {
                return m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.LastExecution.txt");
            }
            case 5: {
                return m_bundle.getString("ColumnSelectorModel.ColumnHeader.Id.txt");
            }
            case 6: {
                return m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Server.txt");
            }
            case 7: {
                return m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Application.txt");
            }
            case 8: {
                return m_bundle.getString("FlowColumnSelectorModel.ColumnHeader.Username.txt");
            }
        }
        return "UNKNOWN";
    }

    @Override
    public int getColumnWidth(int columnKey) {
        return 70;
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.size();
    }

    static {
        String strClassName = FlowColumnSelectorModel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

