/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.FlowEventInterface;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="FileEventInfo", propOrder={"schedulerDataBinding", "filenameDataBinding", "typeDataBinding", "operatorDataBinding", "valueDataBinding"})
public class FileEventInfo
extends AbstractEventInfo
implements Serializable,
FlowEventInterface,
AbstractEventInterface {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="SchedulerServer", required=true)
    protected SchedulerServerInfo schedulerDataBinding;
    @XmlElement(name="Filename", required=true)
    protected String filenameDataBinding;
    @XmlElement(name="Type", required=true)
    protected int typeDataBinding;
    @XmlElement(name="Operator")
    protected int operatorDataBinding;
    @XmlElement(name="Value")
    protected long valueDataBinding;
    private static final ResourceBundle m_bundle;
    private static final String FileEventTag = "PlatformIndependentFileEventV1:";
    private static final String FileEventDefinitionSeparator = "||";
    private static final String FileEventName = "Name:";
    private static final String FileEventEvent = "Event:";
    private static final String FILE_EXISTS_STRING = "exist";
    private static final String FILE_SIZE_STRING = "size";
    private static final String FILE_ARRIVES_STRING = "arrives";
    private static final String FILE_AGE_STRING = "age";
    public static final String IconName;
    public static final int FILE_MIN = 0;
    public static final int FILE_LOW = 1;
    public static final int FILE_MAX = 3;
    public static final int FILE_Unknown = -1;
    public static final int FILE_EXIST = 0;
    public static final int FILE_SIZE = 1;
    public static final int FILE_ARRIVES = 2;
    public static final int FILE_AGE = 3;
    public static final int OP_MIN = 21;
    public static final int OP_MAX = 27;
    public static final int NO_OP = -1;
    public static final int OP_EQ = 21;
    public static final int OP_GT = 23;
    public static final int OP_GTE = 24;
    public static final int OP_LT = 25;
    public static final int OP_LTE = 26;
    public static final int OP_NE = 22;
    public static final int OP_NEGATION = 27;
    public static final long VAL_NONE = 0L;
    public static final long VAL_TRUE = 1L;
    public static final long VAL_FALSE = 0L;

    public FileEventInfo() {
        super("", null, IconName);
        this.schedulerDataBinding = null;
        this.filenameDataBinding = null;
        this.typeDataBinding = -1;
        this.operatorDataBinding = -1;
        this.valueDataBinding = 0L;
    }

    public FileEventInfo(String fileName, int type, int operator, long value) {
        super(fileName, FileEventInfo.toString(fileName, type, operator, value, Locale.getDefault()), IconName);
        if (type < 0 || type > 3) {
            objectArray[0] = new Object[1];
            Object[] objectArray = objectArray[0];
            Object[] args = objectArray;
            args[0] = String.valueOf(type);
            String message = MessageFormat.format(m_bundle.getString("FileEventInfo.InvalidType.fmt"), args);
            InvalidParameterException ex = new InvalidParameterException(message);
            throw ex;
        }
        if ((operator < 21 || operator > 27) && (operator != -1 || type != 0 && type != 2)) {
            objectArray[0] = new Object[1];
            Object[] objectArray = objectArray[0];
            Object[] args = objectArray;
            args[0] = GeneralUtilities.getOperatorString(operator);
            String message = MessageFormat.format(m_bundle.getString("FileEventInfo.InvalidOperator.fmt"), args);
            InvalidParameterException ex = new InvalidParameterException(message);
            throw ex;
        }
        this.schedulerDataBinding = null;
        this.filenameDataBinding = fileName;
        this.typeDataBinding = type;
        this.operatorDataBinding = operator;
        this.valueDataBinding = value;
    }

    public FileEventInfo(SchedulerServerInfo scheduler, String fileName, int type, int operator, long value) {
        this(fileName, type, operator, value);
        this.schedulerDataBinding = scheduler;
    }

    public String getType() {
        return "FileEvent";
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        return FileEventInfo.toString(this.filenameDataBinding, this.typeDataBinding, this.operatorDataBinding, this.valueDataBinding, locale);
    }

    public static String toString(String filename, int type, int operator, long value, Locale locale) {
        if (filename != null) {
            String text = null;
            String formatString = "";
            switch (type) {
                case 0: {
                    if (value == 1L) {
                        formatString = m_bundle.getString("FileEventInfo.toString.Exists.fmt");
                        break;
                    }
                    formatString = m_bundle.getString("FileEventInfo.toString.NotExists.fmt");
                    break;
                }
                case 1: {
                    formatString = m_bundle.getString("FileEventInfo.toString.Size.fmt");
                    break;
                }
                case 2: {
                    formatString = m_bundle.getString("FileEventInfo.toString.Arrives.fmt");
                    break;
                }
                case 3: {
                    formatString = m_bundle.getString("FileEventInfo.toString.Ages.fmt");
                }
            }
            Object[] args = new Object[]{filename, GeneralUtilities.getOperatorString(operator), String.valueOf(value)};
            text = MessageFormat.format(formatString, args);
            return text;
        }
        return "";
    }

    public SchedulerServerInfo getScheduler() {
        return this.schedulerDataBinding;
    }

    public boolean setScheduler(SchedulerServerInfo scheduler) {
        this.schedulerDataBinding = scheduler;
        return true;
    }

    public String getFileName() {
        return this.filenameDataBinding;
    }

    public boolean setFileName(String name) {
        this.filenameDataBinding = name;
        return true;
    }

    public int getEventType() {
        return this.typeDataBinding;
    }

    public boolean setEventType(int type) {
        if (type < 0 || type > 3) {
            return false;
        }
        this.typeDataBinding = type;
        return true;
    }

    public int getOperator() {
        return this.operatorDataBinding;
    }

    public boolean setOperator(int operator) {
        if (operator != -1 && (operator < 21 || operator > 27)) {
            return false;
        }
        this.operatorDataBinding = operator;
        return true;
    }

    public long getValue() {
        return this.valueDataBinding;
    }

    public boolean setValue(long value) {
        this.valueDataBinding = value;
        return true;
    }

    public static String getTypeString(int type, long value) {
        String typeStr = null;
        switch (type) {
            case 0: {
                if (value == 0L) {
                    typeStr = m_bundle.getString("FileEventInfo.exist.txt");
                    break;
                }
                typeStr = m_bundle.getString("FileEventInfo.notexist.txt");
                break;
            }
            case 1: {
                typeStr = m_bundle.getString("FileEventInfo.size.txt");
                break;
            }
            case 2: {
                typeStr = m_bundle.getString("FileEventInfo.arrives.txt");
                break;
            }
            case 3: {
                typeStr = m_bundle.getString("FileEventInfo.age.txt");
                break;
            }
            default: {
                typeStr = String.valueOf(type);
            }
        }
        return typeStr;
    }

    public static int getFileTypeFromConditionString(String conditionString) {
        String age = m_bundle.getString("FileEventInfo.age.txt");
        String arrives = m_bundle.getString("FileEventInfo.arrives.txt");
        String exist = m_bundle.getString("FileEventInfo.exist.txt");
        String notexist = m_bundle.getString("FileEventInfo.notexist.txt");
        String size = m_bundle.getString("FileEventInfo.size.txt");
        try {
            String type = conditionString.substring(0, conditionString.indexOf(32));
            if (type.compareTo(age) == 0) {
                return 3;
            }
            if (type.compareTo(arrives) == 0) {
                return 2;
            }
            if (type.compareTo(exist) == 0) {
                return 0;
            }
            if (type.compareTo(size) == 0) {
                return 1;
            }
            if (type.compareTo(notexist) == 0) {
                return 0;
            }
            return -1;
        }
        catch (RuntimeException ex) {
            return -1;
        }
    }

    public static int getFileOperatorFromConditionString(String conditionString) {
        if (conditionString.indexOf(FlowInfo.ArithmeticOperator_Equal_Symbol) > 0) {
            return 21;
        }
        if (conditionString.indexOf(FlowInfo.ArithmeticOperator_GreaterThan_Symbol) > 0) {
            return 23;
        }
        if (conditionString.indexOf(FlowInfo.ArithmeticOperator_GreaterThanEqual_Symbol) > 0) {
            return 24;
        }
        if (conditionString.indexOf(FlowInfo.ArithmeticOperator_LessThan_Symbol) > 0) {
            return 25;
        }
        if (conditionString.indexOf(FlowInfo.ArithmeticOperator_LessThanEqual_Symbol) > 0) {
            return 26;
        }
        if (conditionString.indexOf(FlowInfo.ArithmeticOperator_NotEqual_Symbol) > 0) {
            return 22;
        }
        if (conditionString.indexOf(FlowInfo.ArithmeticOperator_Negation_Symbol) >= 0) {
            return 27;
        }
        return -1;
    }

    public static long getFileValueFromConditionString(String conditionString) {
        try {
            String value = null;
            int index = -1;
            index = conditionString.indexOf(FlowInfo.ArithmeticOperator_Equal_Symbol);
            if (index > 0) {
                value = conditionString.substring(index + 2);
            } else {
                index = conditionString.indexOf(FlowInfo.ArithmeticOperator_GreaterThan_Symbol);
                if (index > 0) {
                    value = conditionString.substring(index + 2);
                } else {
                    index = conditionString.indexOf(FlowInfo.ArithmeticOperator_GreaterThanEqual_Symbol);
                    if (index > 0) {
                        value = conditionString.substring(index + 2);
                    } else {
                        index = conditionString.indexOf(FlowInfo.ArithmeticOperator_LessThan_Symbol);
                        if (index > 0) {
                            value = conditionString.substring(index + 2);
                        } else {
                            index = conditionString.indexOf(FlowInfo.ArithmeticOperator_LessThanEqual_Symbol);
                            if (index > 0) {
                                value = conditionString.substring(index + 2);
                            } else {
                                index = conditionString.indexOf(FlowInfo.ArithmeticOperator_NotEqual_Symbol);
                                if (index > 0) {
                                    value = conditionString.substring(index + 2);
                                } else {
                                    switch (FileEventInfo.getFileTypeFromConditionString(conditionString)) {
                                        case 0: {
                                            if (conditionString.indexOf("!") >= 0) {
                                                return 0L;
                                            }
                                            return 1L;
                                        }
                                    }
                                    return 0L;
                                }
                            }
                        }
                    }
                }
            }
            return Integer.parseInt(value);
        }
        catch (RuntimeException ex) {
            return 0L;
        }
    }

    public String generateDefinition() {
        if (this.filenameDataBinding == null) {
            return "";
        }
        if (this.typeDataBinding == -1) {
            return "";
        }
        StringBuffer fileDefinition = new StringBuffer(FileEventTag);
        fileDefinition.append(FileEventName);
        fileDefinition.append("<file Name=\"" + this.filenameDataBinding + "\"/>");
        fileDefinition.append(FileEventDefinitionSeparator);
        fileDefinition.append(FileEventEvent);
        block0 : switch (this.typeDataBinding) {
            case 0: {
                if (this.valueDataBinding == 1L) {
                    fileDefinition.append("<exist Value=\"true\"/>");
                    break;
                }
                fileDefinition.append("<exist Value=\"false\"/>");
                break;
            }
            case 1: {
                switch (this.operatorDataBinding) {
                    case 21: {
                        fileDefinition.append("<size Operator=\"EQ\" Value=\"" + this.valueDataBinding + "\"/>");
                        break;
                    }
                    case 23: {
                        fileDefinition.append("<size Operator=\"GT\" Value=\"" + this.valueDataBinding + "\"/>");
                        break;
                    }
                    case 24: {
                        fileDefinition.append("<size Operator=\"GTE\" Value=\"" + this.valueDataBinding + "\"/>");
                        break;
                    }
                    case 25: {
                        fileDefinition.append("<size Operator=\"LT\" Value=\"" + this.valueDataBinding + "\"/>");
                        break;
                    }
                    case 26: {
                        fileDefinition.append("<size Operator=\"LTE\" Value=\"" + this.valueDataBinding + "\"/>");
                        break;
                    }
                    case 22: {
                        fileDefinition.append("<size Operator=\"NE\" Value=\"" + this.valueDataBinding + "\"/>");
                    }
                }
                break;
            }
            case 2: {
                fileDefinition.append("<arrives/>");
                break;
            }
            case 3: {
                switch (this.operatorDataBinding) {
                    case 21: {
                        fileDefinition.append("<age Operator=\"EQ\" Value=\"" + this.valueDataBinding + "\"/>");
                        break block0;
                    }
                    case 23: {
                        fileDefinition.append("<age Operator=\"GT\" Value=\"" + this.valueDataBinding + "\"/>");
                        break block0;
                    }
                    case 24: {
                        fileDefinition.append("<age Operator=\"GTE\" Value=\"" + this.valueDataBinding + "\"/>");
                        break block0;
                    }
                    case 25: {
                        fileDefinition.append("<age Operator=\"LT\" Value=\"" + this.valueDataBinding + "\"/>");
                        break block0;
                    }
                    case 26: {
                        fileDefinition.append("<age Operator=\"LTE\" Value=\"" + this.valueDataBinding + "\"/>");
                        break block0;
                    }
                    case 22: {
                        fileDefinition.append("<age Operator=\"NE\" Value=\"" + this.valueDataBinding + "\"/>");
                    }
                }
            }
        }
        fileDefinition.append(FileEventDefinitionSeparator);
        return fileDefinition.toString();
    }

    public boolean initFromDefinition(String content) {
        NamedNodeMap map;
        Node node;
        NodeList nodes;
        Document doc;
        if (content == null) {
            return false;
        }
        boolean isFileEvent = content.startsWith(FileEventTag);
        if (!isFileEvent) {
            return false;
        }
        String nameString = this.getString(content, FileEventName);
        if (nameString == null) {
            return false;
        }
        String fileString = this.getString(content, FileEventEvent);
        if (fileString == null) {
            return false;
        }
        String filename = null;
        int type = -1;
        int operator = -1;
        long value = 0L;
        try {
            doc = GeneralUtilities.parseXML(nameString);
            nodes = doc.getElementsByTagName("file");
            node = nodes.item(0);
            map = node.getAttributes();
            Node node1 = map.getNamedItem("Name");
            if (node1 != null) {
                filename = node1.getNodeValue();
            }
        }
        catch (SchedulerException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
        try {
            doc = GeneralUtilities.parseXML(fileString);
            nodes = null;
            nodes = doc.getElementsByTagName(FILE_EXISTS_STRING);
            if (nodes != null && nodes.getLength() > 0) {
                node = nodes.item(0);
                map = node.getAttributes();
                type = 0;
                String flag = map.getNamedItem("Value").getNodeValue();
                value = flag.equalsIgnoreCase("FALSE") ? 0L : 1L;
            } else {
                String opName;
                nodes = doc.getElementsByTagName(FILE_SIZE_STRING);
                if (nodes != null && nodes.getLength() > 0) {
                    node = nodes.item(0);
                    map = node.getAttributes();
                    type = 1;
                    opName = map.getNamedItem("Operator").getNodeValue();
                    if (opName.equals("LT")) {
                        operator = 25;
                    } else if (opName.equals("GT")) {
                        operator = 23;
                    } else if (opName.equals("LTE")) {
                        operator = 26;
                    } else if (opName.equals("GTE")) {
                        operator = 24;
                    } else if (opName.equals("EQ")) {
                        operator = 21;
                    } else if (opName.equals("NE")) {
                        operator = 22;
                    }
                    value = Integer.parseInt(map.getNamedItem("Value").getNodeValue());
                } else {
                    nodes = doc.getElementsByTagName(FILE_AGE_STRING);
                    if (nodes != null && nodes.getLength() > 0) {
                        node = nodes.item(0);
                        map = node.getAttributes();
                        type = 3;
                        opName = map.getNamedItem("Operator").getNodeValue();
                        if (opName.equals("LT")) {
                            operator = 25;
                        } else if (opName.equals("GT")) {
                            operator = 23;
                        } else if (opName.equals("LTE")) {
                            operator = 26;
                        } else if (opName.equals("GTE")) {
                            operator = 24;
                        } else if (opName.equals("EQ")) {
                            operator = 21;
                        } else if (opName.equals("NE")) {
                            operator = 22;
                        }
                        value = Integer.parseInt(map.getNamedItem("Value").getNodeValue());
                    } else {
                        nodes = doc.getElementsByTagName(FILE_ARRIVES_STRING);
                        if (nodes != null && nodes.getLength() > 0) {
                            type = 2;
                        }
                    }
                }
            }
        }
        catch (SchedulerException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
        catch (NumberFormatException ex) {
            return false;
        }
        this.filenameDataBinding = filename;
        this.typeDataBinding = type;
        this.operatorDataBinding = operator;
        this.valueDataBinding = value;
        return true;
    }

    public void initFromNode(Node node) throws SchedulerException {
        try {
            NamedNodeMap map = node.getAttributes();
            String type = map.getNamedItem("Type").getNodeValue();
            if (type.compareTo("File") != 0) {
                SchedulerException se = new SchedulerException("Invalid Type");
                throw se;
            }
            NodeList cnodes = node.getChildNodes();
            int numCNodes = cnodes.getLength();
            for (int x = 0; x < numCNodes; ++x) {
                Node cnode = cnodes.item(x);
                String ctagname = cnode.getNodeName();
                NamedNodeMap cmap = cnode.getAttributes();
                if (ctagname.compareTo("file") == 0) {
                    this.filenameDataBinding = cmap.getNamedItem("Name").getNodeValue();
                    continue;
                }
                if (ctagname.compareTo(FILE_EXISTS_STRING) == 0) {
                    this.typeDataBinding = 0;
                    String value = cmap.getNamedItem("Value").getNodeValue();
                    if (value.compareToIgnoreCase("true") == 0) {
                        this.valueDataBinding = 1L;
                        continue;
                    }
                    this.valueDataBinding = 0L;
                    continue;
                }
                if (ctagname.compareTo(FILE_SIZE_STRING) == 0) {
                    this.typeDataBinding = 1;
                    this.operatorDataBinding = this.getOperatorFromXML(cmap.getNamedItem("Operator").getNodeValue());
                    this.valueDataBinding = Integer.parseInt(cmap.getNamedItem("Value").getNodeValue());
                    continue;
                }
                if (ctagname.compareTo(FILE_ARRIVES_STRING) == 0) {
                    this.typeDataBinding = 2;
                    continue;
                }
                if (ctagname.compareTo(FILE_AGE_STRING) != 0) continue;
                this.typeDataBinding = 3;
                this.operatorDataBinding = this.getOperatorFromXML(cmap.getNamedItem("Operator").getNodeValue());
                this.valueDataBinding = Integer.parseInt(cmap.getNamedItem("Value").getNodeValue());
            }
        }
        catch (NullPointerException npe) {
            SchedulerException se = new SchedulerException();
            se.initCause(npe);
            throw se;
        }
        catch (RuntimeException rte) {
            SchedulerException se = new SchedulerException();
            se.initCause(rte);
            throw se;
        }
    }

    @Override
    public String generateXML(boolean exportFormat) {
        return this.generateXML();
    }

    @Override
    public String generateXML() {
        if (this.filenameDataBinding == null) {
            return null;
        }
        if (this.typeDataBinding == -1) {
            return null;
        }
        StringBuffer fileXML = new StringBuffer();
        String desc = this.toString();
        if (desc == null || desc.contains("<")) {
            desc = "";
        }
        fileXML.append("<Event Type=\"File\" Description=\"" + desc + "\">\n");
        fileXML.append("<file Name=\"" + this.filenameDataBinding + "\"/>\n");
        block0 : switch (this.typeDataBinding) {
            case 0: {
                if (this.valueDataBinding == 1L) {
                    fileXML.append("<exist Value=\"true\"/>\n");
                    break;
                }
                fileXML.append("<exist Value=\"false\"/>\n");
                break;
            }
            case 1: {
                switch (this.operatorDataBinding) {
                    case 21: {
                        fileXML.append("<size Operator=\"EQ\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break;
                    }
                    case 23: {
                        fileXML.append("<size Operator=\"GT\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break;
                    }
                    case 24: {
                        fileXML.append("<size Operator=\"GTE\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break;
                    }
                    case 25: {
                        fileXML.append("<size Operator=\"LT\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break;
                    }
                    case 26: {
                        fileXML.append("<size Operator=\"LTE\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break;
                    }
                    case 22: {
                        fileXML.append("<size Operator=\"NE\" Value=\"" + this.valueDataBinding + "\"/>\n");
                    }
                }
                break;
            }
            case 2: {
                fileXML.append("<arrives/>\n");
                break;
            }
            case 3: {
                switch (this.operatorDataBinding) {
                    case 21: {
                        fileXML.append("<age Operator=\"EQ\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break block0;
                    }
                    case 23: {
                        fileXML.append("<age Operator=\"GT\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break block0;
                    }
                    case 24: {
                        fileXML.append("<age Operator=\"GTE\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break block0;
                    }
                    case 25: {
                        fileXML.append("<age Operator=\"LT\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break block0;
                    }
                    case 26: {
                        fileXML.append("<age Operator=\"LTE\" Value=\"" + this.valueDataBinding + "\"/>\n");
                        break block0;
                    }
                    case 22: {
                        fileXML.append("<age Operator=\"NE\" Value=\"" + this.valueDataBinding + "\"/>\n");
                    }
                }
            }
        }
        fileXML.append("</Event>\n");
        return fileXML.toString();
    }

    private int getOperatorFromXML(String xml) {
        if (xml.compareTo("EQ") == 0) {
            return 21;
        }
        if (xml.compareTo("GT") == 0) {
            return 23;
        }
        if (xml.compareTo("GTE") == 0) {
            return 24;
        }
        if (xml.compareTo("LT") == 0) {
            return 25;
        }
        if (xml.compareTo("LTE") == 0) {
            return 26;
        }
        if (xml.compareTo("NE") == 0) {
            return 22;
        }
        return -1;
    }

    private String getString(String definition, String type) {
        int start = definition.indexOf(type, 0);
        if (start < 0) {
            return null;
        }
        int end = definition.indexOf(FileEventDefinitionSeparator, start);
        if (end < 0) {
            return null;
        }
        String result = definition.substring(start + type.length(), end).trim();
        return result;
    }

    public SchedulerServerInfo getSchedulerDataBinding() {
        return this.schedulerDataBinding;
    }

    public void setSchedulerDataBinding(SchedulerServerInfo value) {
        this.schedulerDataBinding = value;
    }

    public String getFilenameDataBinding() {
        return this.filenameDataBinding;
    }

    public void setFilenameDataBinding(String value) {
        this.filenameDataBinding = value;
    }

    public int getTypeDataBinding() {
        return this.typeDataBinding;
    }

    public void setTypeDataBinding(int value) {
        this.typeDataBinding = value;
    }

    public int getOperatorDataBinding() {
        return this.operatorDataBinding;
    }

    public void setOperatorDataBinding(int value) {
        this.operatorDataBinding = value;
    }

    public long getValueDataBinding() {
        return this.valueDataBinding;
    }

    public void setValueDataBinding(long value) {
        this.valueDataBinding = value;
    }

    static {
        String strClassName = FileEventInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("FileEvent.image");
    }
}

