/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BatchServerInfo", propOrder={"classidDataBinding", "typeDataBinding", "subTypeDataBinding", "operatingSystemDataBinding", "directoriesDataBinding", "workspaceNameDataBinding", "jclDirectoryDataBinding", "hostDataBinding", "connectionIdDataBinding"})
public class BatchServerInfo
extends DisplayInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="ClassId", required=true)
    protected String classidDataBinding;
    @XmlElement(name="Type", required=true)
    protected int typeDataBinding;
    @XmlElement(name="SubType")
    protected int subTypeDataBinding;
    @XmlElement(name="OperatingSystem")
    protected int operatingSystemDataBinding;
    @XmlElement(name="Directory")
    protected List<DirectoryInfo> directoriesDataBinding;
    @XmlElement(name="WorkspaceName")
    protected String workspaceNameDataBinding;
    @XmlElement(name="JclDirectory")
    protected String jclDirectoryDataBinding;
    @XmlElement(name="Host", required=true)
    protected String hostDataBinding;
    @XmlElement(name="ConnectionId")
    protected String connectionIdDataBinding;
    private static final ResourceBundle m_bundle;
    public static final String IconName;
    public static final String BATCHSERVER_DataStepServerID = "e20e54b3-e5f4-47ed-b21d-03109bf9a4b8";
    public static final String BATCHSERVER_JavaServerID = "0069e914-b58c-4094-a686-a87df433ec4b";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_MACampaign = "MarketingAutomation";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_BIReport = "BusinessReportManager";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_MO = "MarketingOptimization";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_OpRisk = "OpRisk";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_BIL = "BILineage";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_BILScraper = "BILineageScraper";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_MI = "MetadataInvestigator";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_JobExecutionService = "JobExecutionService";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_WorkflowService = "WorkflowService";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_EDO = "EnergyDistribution";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_FM = "BusinessPlanning";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_WarrantyAnalysis = "WarrantyAnalysis";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_DigitalMarketing = "DigitalMarketing";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_RelationshipLoader = "RelationshipLoader";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_VADesigner = "VADesigner";
    public static final String BATCHSERVER_JavaServerID_SUBTYPE_StoredProcess = "StoredProcess";
    public static final String BATCHSERVER_DMPExecServerID = "d6644527-7a09-4fe2-8bac-1caca2f6a46c";
    public static final String BATCHSERVER_GenericServerID = "a1ff485f-9e44-4c82-90b5-062916cfa9b9";
    public static final int MIN_MAIN = 0;
    public static final int MAX_MAIN = 2;
    public static final int NO_BATCH_SERVER = -2;
    public static final int ANY_BATCH_SERVER = -1;
    public static final int GENERIC_BATCH_SERVER = 0;
    public static final int DATA_STEP_BATCH_SERVER = 1;
    public static final int JAVA_BATCH_SERVER = 2;
    public static final int DMPEXEC_BATCH_SERVER = 3;
    public static final int MIN_SUB = 10;
    public static final int MAX_SUB = 26;
    public static final int NO_SUBTYPE = 0;
    public static final int JAVA_BATCH_CampaignManager = 10;
    public static final int JAVA_BATCH_BusinessReportManager = 11;
    public static final int JAVA_BATCH_MarketingOptimization = 12;
    public static final int JAVA_BATCH_DO_NOT_USE = 13;
    public static final int JAVA_BATCH_BusinessPlanning = 14;
    public static final int JAVA_BATCH_StoredProcess = 15;
    public static final int JAVA_BATCH_BILineage = 16;
    public static final int JAVA_BATCH_MetadataInvestigator = 17;
    public static final int JAVA_BATCH_JobExecutionService = 18;
    public static final int JAVA_BATCH_WorkflowService = 19;
    public static final int JAVA_BATCH_BILineageScraper = 20;
    public static final int JAVA_BATCH_OpRisk = 21;
    public static final int JAVA_BATCH_EnergyDistribution = 22;
    public static final int JAVA_BATCH_WarrantyAnalysis = 23;
    public static final int JAVA_BATCH_RelationshipLoader = 24;
    public static final int JAVA_BATCH_DigitalMarketing = 25;
    public static final int JAVA_BATCH_VADesigner = 26;
    public static final int TargetOS_Unknown = -1;
    public static final int TargetOS_zOS = 2;
    public static final int TargetOS_Windows = 0;
    public static final int TargetOS_UNIX = 1;
    public static final int TargetOS_VMS = 3;

    public String getClassidDataBinding() {
        return this.classidDataBinding;
    }

    public void setClassidDataBinding(String value) {
        this.classidDataBinding = value;
    }

    public int getTypeDataBinding() {
        return this.typeDataBinding;
    }

    public void setTypeDataBinding(int value) {
        this.typeDataBinding = value;
    }

    public int getSubTypeDataBinding() {
        return this.subTypeDataBinding;
    }

    public void setSubTypeDataBinding(int value) {
        this.subTypeDataBinding = value;
    }

    public int getOperatingSystemDataBinding() {
        return this.operatingSystemDataBinding;
    }

    public void setOperatingSystemDataBinding(int value) {
        this.operatingSystemDataBinding = value;
    }

    public List<DirectoryInfo> getDirectoriesDataBinding() {
        if (this.directoriesDataBinding == null) {
            this.directoriesDataBinding = new ArrayList<DirectoryInfo>();
        }
        return this.directoriesDataBinding;
    }

    public String getWorkspaceNameDataBinding() {
        return this.workspaceNameDataBinding;
    }

    public void setWorkspaceNameDataBinding(String value) {
        this.workspaceNameDataBinding = value;
    }

    public String getJclDirectoryDataBinding() {
        return this.jclDirectoryDataBinding;
    }

    public void setJclDirectoryDataBinding(String value) {
        this.jclDirectoryDataBinding = value;
    }

    public String getHostDataBinding() {
        return this.hostDataBinding;
    }

    public void setHostDataBinding(String value) {
        this.hostDataBinding = value;
    }

    public String getConnectionIdDataBinding() {
        return this.connectionIdDataBinding;
    }

    public void setConnectionIdDataBinding(String value) {
        this.connectionIdDataBinding = value;
    }

    public void setDirectoriesDataBinding(List<DirectoryInfo> directoriesDataBinding) {
        this.directoriesDataBinding = directoriesDataBinding;
    }

    public BatchServerInfo() {
        this.directoriesDataBinding = new ArrayList<DirectoryInfo>();
    }

    public BatchServerInfo(String name) {
        super(name, null, IconName);
        this.classidDataBinding = BATCHSERVER_DataStepServerID;
        this.typeDataBinding = 1;
        this.subTypeDataBinding = -1;
        this.operatingSystemDataBinding = -1;
        this.directoriesDataBinding = new ArrayList<DirectoryInfo>();
    }

    public BatchServerInfo(String name, String classid) {
        super(name, null, IconName);
        this.classidDataBinding = classid;
        this.typeDataBinding = BatchServerInfo.getType(classid);
        this.subTypeDataBinding = -1;
        this.operatingSystemDataBinding = -1;
        this.directoriesDataBinding = new ArrayList<DirectoryInfo>();
    }

    public BatchServerInfo(String name, String classid, int operatingsystem) {
        super(name, null, IconName);
        this.classidDataBinding = classid;
        this.typeDataBinding = BatchServerInfo.getType(classid);
        this.subTypeDataBinding = -1;
        this.operatingSystemDataBinding = operatingsystem;
        this.directoriesDataBinding = new ArrayList<DirectoryInfo>();
    }

    public BatchServerInfo(String name, int type, int subtype) {
        super(name, null, IconName);
        this.classidDataBinding = BatchServerInfo.getClassId(type);
        this.typeDataBinding = type;
        this.subTypeDataBinding = subtype;
        this.operatingSystemDataBinding = -1;
        this.directoriesDataBinding = new ArrayList<DirectoryInfo>();
    }

    public BatchServerInfo(String name, int type, int subtype, int operatingsystem) {
        super(name, null, IconName);
        this.classidDataBinding = BatchServerInfo.getClassId(type);
        this.typeDataBinding = type;
        this.subTypeDataBinding = subtype;
        this.operatingSystemDataBinding = operatingsystem;
        this.directoriesDataBinding = new ArrayList<DirectoryInfo>();
    }

    public List<DirectoryInfo> getDirectories() {
        return this.directoriesDataBinding;
    }

    public boolean addDirectory(DirectoryInfo dir) {
        return this.directoriesDataBinding.add(dir);
    }

    public boolean setDirectories(List<DirectoryInfo> list) {
        this.directoriesDataBinding.clear();
        return this.directoriesDataBinding.addAll(list);
    }

    public String getJCLDirectory() {
        return this.jclDirectoryDataBinding;
    }

    public boolean setJCLDirectory(String path) {
        this.jclDirectoryDataBinding = path;
        return true;
    }

    public String getHost() {
        return this.hostDataBinding;
    }

    public boolean setHost(String host) {
        this.hostDataBinding = host;
        return true;
    }

    public String getClassId() {
        return this.classidDataBinding;
    }

    public static String getClassId(int type) {
        String classid = null;
        switch (type) {
            case 2: {
                classid = BATCHSERVER_JavaServerID;
                break;
            }
            case 3: {
                classid = BATCHSERVER_DMPExecServerID;
                break;
            }
            case 0: {
                classid = BATCHSERVER_GenericServerID;
                break;
            }
            default: {
                classid = BATCHSERVER_DataStepServerID;
            }
        }
        return classid;
    }

    public static String getTypeName(int type) {
        String name = null;
        switch (type) {
            case 2: {
                name = m_bundle.getString("BatchServerInfo.Java.DisplayName.txt");
                break;
            }
            case 3: {
                name = m_bundle.getString("BatchServerInfo.DMPExec.DisplayName.txt");
                break;
            }
            case 0: {
                name = m_bundle.getString("BatchServerInfo.Generic.DisplayName.txt");
                break;
            }
            default: {
                name = m_bundle.getString("BatchServerInfo.SASDataStep.DisplayName.txt");
            }
        }
        return name;
    }

    public int getType() {
        return this.typeDataBinding;
    }

    public static int getType(String classid) {
        if (classid.equalsIgnoreCase(BATCHSERVER_DataStepServerID)) {
            return 1;
        }
        if (classid.equalsIgnoreCase(BATCHSERVER_JavaServerID)) {
            return 2;
        }
        if (classid.equalsIgnoreCase(BATCHSERVER_DMPExecServerID)) {
            return 3;
        }
        if (classid.equalsIgnoreCase(BATCHSERVER_GenericServerID)) {
            return 0;
        }
        return -2;
    }

    public int getSubType() {
        return this.subTypeDataBinding;
    }

    public void setSubType(int subType) {
        this.subTypeDataBinding = subType;
    }

    public static String getSubTypeName(int type, int subtype) {
        String name = null;
        block0 : switch (type) {
            case 2: {
                switch (subtype) {
                    case 10: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.MA.xmlKey.txt");
                        break block0;
                    }
                    case 11: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.BRM.xmlKey.txt");
                        break block0;
                    }
                    case 12: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.MO.xmlKey.txt");
                        break block0;
                    }
                    case 21: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.OpRisk.xmlKey.txt");
                        break block0;
                    }
                    case 16: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.BIL.xmlKey.txt");
                        break block0;
                    }
                    case 20: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.BILScraper.xmlKey.txt");
                        break block0;
                    }
                    case 18: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.JES.xmlKey.txt");
                        break block0;
                    }
                    case 22: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.EDO.xmlKey.txt");
                        break block0;
                    }
                    case 14: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.FM.xmlKey.txt");
                        break block0;
                    }
                    case 17: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.MI.xmlKey.txt");
                        break block0;
                    }
                    case 19: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.WF.xmlKey.txt");
                        break block0;
                    }
                    case 15: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.SP.xmlKey.txt");
                        break block0;
                    }
                    case 23: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.WA.xmlKey.txt");
                        break block0;
                    }
                    case 24: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.RL.xmlKey.txt");
                        break block0;
                    }
                    case 25: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.DM.xmlKey.txt");
                        break block0;
                    }
                    case 26: {
                        name = m_bundle.getString("BatchServerInfo.Java.Property.SubType.VAD.xmlKey.txt");
                        break block0;
                    }
                }
                name = "";
                break;
            }
            default: {
                name = "";
            }
        }
        return name;
    }

    public static String getSubTypeId(int type, int subtype) {
        switch (type) {
            case 2: {
                switch (subtype) {
                    case 10: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_MACampaign;
                    }
                    case 11: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_BIReport;
                    }
                    case 12: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_MO;
                    }
                    case 21: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_OpRisk;
                    }
                    case 16: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_BIL;
                    }
                    case 20: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_BILScraper;
                    }
                    case 18: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_JobExecutionService;
                    }
                    case 22: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_EDO;
                    }
                    case 14: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_FM;
                    }
                    case 17: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_MI;
                    }
                    case 19: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_WorkflowService;
                    }
                    case 23: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_WarrantyAnalysis;
                    }
                    case 25: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_DigitalMarketing;
                    }
                    case 24: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_RelationshipLoader;
                    }
                    case 26: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_VADesigner;
                    }
                    case 15: {
                        return BATCHSERVER_JavaServerID_SUBTYPE_StoredProcess;
                    }
                }
                return null;
            }
        }
        return "";
    }

    public int getOperatingSystem() {
        return this.operatingSystemDataBinding;
    }

    public static boolean requiresSourceFile(BatchServerInfo bsinfo) throws InvalidParameterException {
        switch (bsinfo.getType()) {
            case 2: {
                return false;
            }
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        InvalidParameterException ex = new InvalidParameterException();
        throw ex;
    }

    public static boolean requiresSourceFile(String classid) {
        if (classid.equalsIgnoreCase(BATCHSERVER_DataStepServerID)) {
            return true;
        }
        if (classid.equalsIgnoreCase(BATCHSERVER_JavaServerID)) {
            return false;
        }
        if (classid.equalsIgnoreCase(BATCHSERVER_DMPExecServerID)) {
            return true;
        }
        if (classid.equalsIgnoreCase(BATCHSERVER_GenericServerID)) {
            return false;
        }
        InvalidParameterException ex = new InvalidParameterException();
        throw ex;
    }

    public static boolean requiresJCLFile(BatchServerInfo bsinfo) {
        switch (bsinfo.getType()) {
            case 2: {
                return bsinfo.getOperatingSystem() == 2 && bsinfo.getSubType() == 11;
            }
            case 0: {
                return false;
            }
            case 3: {
                return false;
            }
            case 1: {
                return bsinfo.getOperatingSystem() == 2;
            }
        }
        InvalidParameterException ex = new InvalidParameterException();
        throw ex;
    }

    public static boolean requiresJCLFile(String classid, int operatingsystem) {
        if (classid.equalsIgnoreCase(BATCHSERVER_DataStepServerID)) {
            return operatingsystem == 2;
        }
        if (classid.equalsIgnoreCase(BATCHSERVER_JavaServerID)) {
            return operatingsystem == 2;
        }
        if (classid.equalsIgnoreCase(BATCHSERVER_DMPExecServerID)) {
            return false;
        }
        if (classid.equalsIgnoreCase(BATCHSERVER_GenericServerID)) {
            return false;
        }
        InvalidParameterException ex = new InvalidParameterException();
        throw ex;
    }

    public String getConnectionId() {
        return this.connectionIdDataBinding;
    }

    public void setConnectionId(String connectionId) {
        this.connectionIdDataBinding = connectionId;
    }

    static {
        String strClassName = BatchServerInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("BatchServer.image");
    }
}

