/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.util.LocalizableString;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistConstants;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class LocalizedText
extends AbstractPersistence {
    private Locale locale;
    private String text;

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String locString = provider.consumeAttr("xml:lang");
        if (null != locString) {
            this.getLogger2().debug("locale is: ", locString);
            this.setLocale(XmlUtil.xmlToLocale(locString));
        } else {
            this.setLocale(PersistConstants.DEFAULT_LOCALE);
        }
    }

    @Override
    public String getDefinitionElementName() {
        return "Text";
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.getText()) {
            if (null != this.getLocale()) {
                String localeValue = XmlUtil.localeToXml(this.getLocale());
                element.setAttribute("xml:lang", localeValue);
            }
            Document doc = element.getOwnerDocument();
            Text theText = doc.createTextNode(this.getText());
            element.appendChild(theText);
        }
    }

    @Override
    public void consumeElementText(String text) {
        super.consumeElementText(text);
        this.setText(text);
        this.getLogger2().debug("consumeElementText(),text is:", text);
    }

    public String toString() {
        String loc = null;
        if (null != this.locale) {
            loc = this.locale.toString();
        }
        return "Locale= " + loc + " text= " + this.text;
    }

    public static List getPersistableList(LocalizableString localizableString, LoggerFactoryInterface factory) {
        ArrayList<LocalizedText> list = new ArrayList<LocalizedText>();
        List locales = localizableString.getLocales();
        if (locales != null) {
            for (Locale locale : locales) {
                String text = localizableString.getText(locale);
                LocalizedText t = new LocalizedText();
                t.setLocale(locale);
                t.setText(text);
                list.add(t);
            }
        }
        return list;
    }

    public static LocalizableString fromPersistableList(List list) {
        LocalizableString label = new LocalizableString();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            LocalizedText text = (LocalizedText)list.get(i);
            label.setText(text.getText(), text.getLocale());
        }
        return label;
    }
}

