/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

final class EqualsEqualsList {
    private Object[] _elementData;
    private int _size;

    public EqualsEqualsList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this._elementData = new Object[initialCapacity];
    }

    public EqualsEqualsList() {
        this(10);
    }

    public EqualsEqualsList(Collection c) {
        this._size = c.size();
        this._elementData = new Object[(int)Math.min((long)this._size * 110L / 100L, Integer.MAX_VALUE)];
        c.toArray(this._elementData);
    }

    public int indexOf(Object obj) {
        int size = this._size;
        for (int i = 0; i < size; ++i) {
            if (this._elementData[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    public Object get(int index) {
        this.RangeCheck(index);
        return this._elementData[index];
    }

    public Object set(int index, Object element) {
        this.RangeCheck(index);
        Object oldValue = this._elementData[index];
        this._elementData[index] = element;
        return oldValue;
    }

    private void RangeCheck(int index) {
        if (index >= this._size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this._size);
        }
    }

    public boolean add(Object o) {
        this.ensureCapacity(this._size + 1);
        this._elementData[this._size++] = o;
        return true;
    }

    public void addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public boolean addButNoDuplicates(Object o) {
        boolean added = false;
        if (this.indexOf(o) == -1) {
            this.add(o);
            added = true;
        }
        return added;
    }

    public void remove(Object obj) {
        int index = this.indexOf(obj);
        int numMoved = this._size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this._elementData, index + 1, this._elementData, index, numMoved);
        }
        this._elementData[--this._size] = null;
    }

    public ArrayList toList() {
        ArrayList<Object> out = new ArrayList<Object>(this._size);
        for (int i = 0; i < this._size; ++i) {
            out.add(this._elementData[i]);
        }
        return out;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this._elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this._elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this._elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this._elementData, 0, this._size);
        }
    }

    public int size() {
        return this._size;
    }
}

