/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist;

import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.util.ValidateArg;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlUtil {
    private static final String FOUR_SPACES = "    ";
    private static int MAX_CACHED_INDENTATIONS = 20;
    private static Map<String, String[]> indentationCache = new ConcurrentHashMap<String, String[]>();

    private XmlUtil() {
    }

    public static String localeToXml(Locale locale) {
        String out = null;
        if (null != locale && !"".equals(locale.getLanguage())) {
            out = null != locale.getCountry() && !"".equals(locale.getCountry()) ? (null != locale.getVariant() && !"".equals(locale.getVariant()) ? locale.getLanguage() + "-" + locale.getCountry() + "-" + locale.getVariant() : locale.getLanguage() + "-" + locale.getCountry()) : locale.getLanguage();
        }
        return out;
    }

    public static Locale xmlToLocale(String input) {
        Locale locale = null;
        if (null != input) {
            if (input.indexOf("-") > 0) {
                String[] array = input.split("-");
                locale = XmlUtil.tokenize(array);
            } else if (input.indexOf("_") > 0) {
                String[] array = input.split("_");
                locale = XmlUtil.tokenize(array);
            } else if (input.trim().length() > 0) {
                locale = new Locale(input.trim());
            }
        }
        return locale;
    }

    private static Locale tokenize(String[] tokens) {
        Locale locale = null;
        switch (tokens.length) {
            case 1: {
                locale = new Locale(tokens[0], "");
                break;
            }
            case 2: {
                locale = new Locale(tokens[0], tokens[1]);
                break;
            }
            case 3: {
                locale = new Locale(tokens[0], tokens[1], tokens[2]);
                break;
            }
            case 4: {
                locale = new Locale(tokens[0], tokens[1], tokens[2] + '_' + tokens[3]);
            }
        }
        return locale;
    }

    public static void setAttr(Element element, String attrName, String attrValue) {
        if (attrValue != null) {
            element.setAttribute(attrName, attrValue);
        }
    }

    public static void setAttrWithEmptyDefault(Element element, String attrName, String attrValue) {
        if (attrValue == null) {
            element.setAttribute(attrName, "");
        } else if (!"".equals(attrValue)) {
            element.setAttribute(attrName, attrValue);
        }
    }

    public static void setAttrWithEmptyAsNull(Element element, String attrName, String attrValue) {
        if (attrValue != null && !"".equals(attrValue)) {
            element.setAttribute(attrName, attrValue);
        }
    }

    public static void setBooleanAttr(Element element, String attrName, boolean attrValue, boolean dontWriteValue) {
        if (attrValue != dontWriteValue) {
            XmlUtil.setAttr(element, attrName, attrValue ? "true" : "false");
        }
    }

    public static void setIntAttr(Element element, String attrName, int attrValue) {
        XmlUtil.setAttr(element, attrName, Integer.toString(attrValue));
    }

    public static void setIntAttr(Element element, String attrName, int attrValue, int defaultPersistenceValue) {
        if (attrValue != defaultPersistenceValue) {
            XmlUtil.setAttr(element, attrName, Integer.toString(attrValue));
        }
    }

    public static void setLongAttr(Element element, String attrName, long attrValue) {
        XmlUtil.setAttr(element, attrName, Long.toString(attrValue));
    }

    public static void setLongAttr(Element element, String attrName, long attrValue, long defaultPersistenceValue) {
        if (attrValue != defaultPersistenceValue) {
            XmlUtil.setAttr(element, attrName, Long.toString(attrValue));
        }
    }

    public static void setDoubleAttr(Element element, String attrName, double attrValue) {
        XmlUtil.setAttr(element, attrName, Double.toString(attrValue));
    }

    public static void setDoubleAttr(Element element, String attrName, double attrValue, double defaultPersistenceValue) {
        if (Double.compare(attrValue, defaultPersistenceValue) != 0) {
            XmlUtil.setDoubleAttr(element, attrName, attrValue);
        }
    }

    public static String documentToString(Document document) {
        StringBuffer sb = new StringBuffer();
        XmlUtil.serializeNode(document.getDocumentElement(), sb, false);
        return sb.toString();
    }

    public static String documentToString(Node node) {
        StringBuffer sb = new StringBuffer();
        XmlUtil.serializeNode(node, sb, false);
        return sb.toString();
    }

    public static String documentToPrettyString(Document document) {
        StringBuffer sb = new StringBuffer();
        XmlUtil.serializeNode(document.getDocumentElement(), sb, true);
        return sb.toString();
    }

    public static String documentToPrettyString(Node node) {
        StringBuffer sb = new StringBuffer();
        XmlUtil.serializeNode(node, sb, true);
        return sb.toString();
    }

    public static String promptModelToPrettyString(PersistenceInterface promptModel) throws ParserConfigurationException, BackingStoreException {
        ValidateArg.notNull((Object)promptModel, (String)"promptModel");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        LoggerFactoryInterface loggerFactory = null;
        PromptsWritingContext wc = PersistenceFactory.newWritingContext(promptModel, loggerFactory);
        promptModel.write(doc, wc);
        return XmlUtil.documentToPrettyString(doc);
    }

    public static void serializeNode(Node node, StringBuffer sb, boolean indent, boolean prettyPrint) {
        XmlUtil.serializeNode(node, sb, 0, prettyPrint);
    }

    public static void serializeNode(Node node, StringBuffer sb, boolean prettyPrint) {
        XmlUtil.serializeNode(node, sb, 0, prettyPrint);
    }

    private static void serializeNode(Node node, StringBuffer sb, int indentCount, boolean prettyPrint) {
        String lineSeparator = "\n";
        String indentation = null;
        switch (node.getNodeType()) {
            case 9: {
                sb.append("<?xml version=\"1.0\"?>");
                sb.append(lineSeparator);
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    XmlUtil.serializeNode(nodes.item(i), sb, indentCount + 1, prettyPrint);
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                if (prettyPrint) {
                    indentation = XmlUtil.getIndentationSpaces(indentCount);
                    sb.append(indentation);
                }
                sb.append("<").append(name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    if (null == current.getNodeValue()) continue;
                    String out = current.getNodeValue();
                    out = Strings.quoteForXMLComplete((String)out);
                    sb.append(" ").append(current.getNodeName()).append("=\"").append(out).append("\"");
                }
                sb.append(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    if (prettyPrint && children.item(0) != null && children.item(0).getNodeType() == 1) {
                        sb.append(lineSeparator);
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        XmlUtil.serializeNode(children.item(i), sb, indentCount + 1, prettyPrint);
                    }
                    if (prettyPrint && children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        sb.append(indentation);
                    }
                }
                sb.append("</").append(name).append(">");
                if (!prettyPrint) break;
                sb.append(lineSeparator);
                break;
            }
            case 3: {
                if (null == node.getNodeValue()) break;
                String out = node.getNodeValue();
                out = Strings.quoteForXMLComplete((String)out);
                sb.append(out);
                break;
            }
            case 4: {
                sb.append("<![CDATA[").append(node.getNodeValue()).append("]]>");
                break;
            }
            case 8: {
                if (prettyPrint) {
                    indentation = XmlUtil.getIndentationSpaces(indentCount);
                    sb.append(indentation);
                }
                sb.append("<!-- ").append(node.getNodeValue()).append(" -->");
                if (!prettyPrint) break;
                sb.append(lineSeparator);
                break;
            }
            case 7: {
                sb.append("<?").append(node.getNodeName()).append(" ").append(node.getNodeValue()).append("?>");
                if (!prettyPrint) break;
                sb.append(lineSeparator);
                break;
            }
            case 5: {
                sb.append("&").append(node.getNodeName()).append(";");
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                sb.append("<!DOCTYPE ").append(docType.getName());
                if (docType.getPublicId() != null) {
                    System.out.print(" PUBLIC \"" + docType.getPublicId() + "\" ");
                } else {
                    sb.append(" SYSTEM ");
                }
                sb.append("\"").append(docType.getSystemId()).append("\">");
                if (!prettyPrint) break;
                sb.append(lineSeparator);
            }
        }
    }

    private static String getIndentationSpaces(int indentCount) {
        if (indentCount <= 0) {
            return "";
        }
        if (indentCount <= MAX_CACHED_INDENTATIONS) {
            String indentation;
            String[] indentations = indentationCache.get(FOUR_SPACES);
            if (indentations == null) {
                indentations = new String[MAX_CACHED_INDENTATIONS];
                indentationCache.put(FOUR_SPACES, indentations);
            }
            if ((indentation = indentations[indentCount - 1]) != null) {
                return indentation;
            }
            StringBuffer sb = new StringBuffer(4 * indentCount + 1);
            for (int i = 0; i < indentCount; ++i) {
                sb.append(FOUR_SPACES);
            }
            indentations[indentCount - 1] = sb.toString();
            return indentations[indentCount - 1];
        }
        StringBuffer buf = new StringBuffer(4 * indentCount + 1);
        for (int i = 0; i < indentCount; ++i) {
            buf.append(FOUR_SPACES);
        }
        return buf.toString();
    }

    public static List getSubelements(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList kids = node.getChildNodes();
        if (kids != null) {
            int kidCount = kids.getLength();
            for (int i = 0; i < kidCount; ++i) {
                Node kidNode = kids.item(i);
                if (!(kidNode instanceof Element)) continue;
                list.add(kidNode);
            }
        }
        return list;
    }

    public static int compareVersionStrings(String version1, String version2) throws ParseException {
        ValidateArg.notBlank((String)version1, (String)"version1");
        ValidateArg.notBlank((String)version2, (String)"version2");
        UsageVersion oneUV = UsageVersion.parseVersion((String)version1);
        UsageVersion twoUV = UsageVersion.parseVersion((String)version2);
        return oneUV.compareTo((Object)twoUV);
    }
}

