/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueretriever;

import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.util.UsageVersion;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class LanguageSet
extends AbstractPersistence {
    private static final long serialVersionUID = 1L;
    private static final String Rows = "Rows";
    private Locale locale = Locale.getDefault();
    private List<BasePersistedValue> _list = new ArrayList<BasePersistedValue>();

    Locale getLocale() {
        return this.locale;
    }

    void setLocale(@NotNull Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        this.locale = locale;
    }

    void setRows(List<BasePersistedValue> list) {
        if (list != null) {
            this._list.clear();
            this._list.addAll(list);
        }
    }

    List<BasePersistedValue> getRows() {
        return this._list;
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String locString = provider.consumeAttr("xml:lang");
        if (null != locString) {
            this.getLogger2().debug("consuming attribute- locale: ", locString);
            this.setLocale(XmlUtil.xmlToLocale(locString));
        }
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects(Rows);
        if (!list.isEmpty()) {
            Iterator iter = list.iterator();
            this.getLogger2().debug("consumeRelObjects, for BasePersistedValues ");
            while (iter.hasNext()) {
                BasePersistedValue value = (BasePersistedValue)iter.next();
                this._list.add(value);
            }
        }
    }

    @Override
    public String getDefinitionElementName() {
        return "LanguageSet";
    }

    @Override
    public String getVersion() {
        return new UsageVersion(2, 0).toString();
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.getLocale()) {
            String localeValue = XmlUtil.localeToXml(this.locale);
            element.setAttribute("xml:lang", localeValue);
            this.getLogger2().debug("Writing localized labels for locale", localeValue);
        }
        if (!this._list.isEmpty()) {
            ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
            list.addAll(this._list);
            LanguageSet.writeRelatedObjects(list, element, writingContext, Rows);
        }
    }
}

