/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueprovider;

import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.prompts.util.AttributeValue;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ValueItemPersister
extends AbstractPersistence {
    private ValueItem valueItem;

    public ValueItemPersister() {
        this.valueItem = new ValueItem();
    }

    public ValueItemPersister(ValueItem valueItem) {
        this.valueItem = valueItem;
    }

    public ValueItem getValueItem() {
        return this.valueItem;
    }

    public void setValueItem(ValueItem valueItem) {
        this.valueItem = valueItem;
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String label = provider.consumeAttr("label");
        this.getValueItem().setLabel(label);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList attributeList;
        ArrayList valueList;
        super.consumeRelatedObjects(roHolder);
        ArrayList labelList = roHolder.consumeObjects("LabelObject");
        if (labelList != null && labelList.size() > 0) {
            BasePersistedValue persistedValue = (BasePersistedValue)labelList.get(0);
            this.getValueItem().setLabelObject(persistedValue.getValue());
        }
        if ((valueList = roHolder.consumeObjects("Value")) != null && valueList.size() > 0) {
            BasePersistedValue persistedValue = (BasePersistedValue)valueList.get(0);
            this.getValueItem().setValue(persistedValue.getValue());
        }
        if ((attributeList = roHolder.consumeObjects("Attributes")) != null && attributeList.size() > 0) {
            for (AttributeValue attributeValue : attributeList) {
                this.getValueItem().setAttribute(attributeValue.getName(), attributeValue.getValue());
            }
        }
    }

    @Override
    public String getDefinitionElementName() {
        return "ValueItemPersister";
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr(element, "label", this.getValueItem().getLabel());
        ArrayList<PersistenceInterface> labelList = new ArrayList<PersistenceInterface>(1);
        labelList.add(ValueUtil.getPersistableValue(this.getValueItem().getLabelObject()));
        ValueItemPersister.writeRelatedObjects(labelList, element, writingContext, "LabelObject");
        ArrayList<PersistenceInterface> valueList = new ArrayList<PersistenceInterface>(1);
        valueList.add(ValueUtil.getPersistableValue(this.getValueItem().getValue()));
        ValueItemPersister.writeRelatedObjects(valueList, element, writingContext, "Value");
        Collection atts = this.getValueItem().getAttributesNames();
        if (atts != null && !atts.isEmpty()) {
            ArrayList<PersistenceInterface> attList = new ArrayList<PersistenceInterface>(atts.size());
            for (String attribute : atts) {
                attList.add(new AttributeValue(attribute, this.getValueItem().getAttribute(attribute)));
            }
            ValueItemPersister.writeRelatedObjects(attList, element, writingContext, "Attributes");
        }
    }
}

