/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueprovider;

import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueretriever.LocalizableColumn;
import com.sas.storage.valueretriever.StaticValueRetrieverConfiguration;
import com.sas.storage.vr.dto.ColumnValueItem;
import com.sas.storage.vr.dto.QueryProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class ConverterUtil {
    public static final String QUERY_PROPERTY_KEY_DISPLAY_VALUE = "DISPLAY_VALUE";

    public static boolean isStaticValueRetrieverConvertableToStaticValueProvider(StaticValueRetrieverConfiguration valueRetriever) {
        return true;
    }

    public static StaticValueProvider convertStaticValueRetrieverToStaticValueProvider(StaticValueRetrieverConfiguration valueRetriever) {
        Iterator labelColumnsIterator;
        StaticValueProvider valueProvider = new StaticValueProvider();
        ColumnValueItem valueColumn = valueRetriever.getValueColumn();
        List valueColumnData = valueColumn.getRowData();
        List<QueryProperty> queryProperties = valueRetriever.getQueryProperties();
        valueProvider.setValueDisplayed(ConverterUtil.getBooleanQueryPropertyValue(QUERY_PROPERTY_KEY_DISPLAY_VALUE, queryProperties, false));
        ArrayList<ColumnValueItem> labelColumns = null;
        List<LocalizableColumn> localizableColumns = valueRetriever.getWritableLabelColumns();
        if (localizableColumns != null && localizableColumns.size() > 0) {
            LocalizableColumn localizableColumn = localizableColumns.get(0);
            labelColumns = new ArrayList<ColumnValueItem>();
            Collection locales = localizableColumn.getLocales();
            for (Locale locale : locales) {
                labelColumns.add(localizableColumn.getColumnValueItem(locale));
            }
        }
        if (labelColumns != null && labelColumns.size() > 0) {
            labelColumnsIterator = labelColumns.iterator();
        } else {
            ArrayList fakeColumnsList = new ArrayList(1);
            fakeColumnsList.add(null);
            labelColumnsIterator = fakeColumnsList.iterator();
        }
        while (labelColumnsIterator.hasNext()) {
            List labelColumnData = new ArrayList(1);
            ColumnValueItem labelColumn = (ColumnValueItem)labelColumnsIterator.next();
            if (labelColumn != null) {
                labelColumnData = labelColumn.getRowData();
            }
            String labelColumnLocaleName = "en_US";
            if (labelColumn != null) {
                labelColumnLocaleName = labelColumn.getLocale();
            }
            Locale labelColumnLocale = new Locale(labelColumnLocaleName);
            Iterator valueColumnDataIterator = valueColumnData.iterator();
            Iterator labelColumnDataIterator = labelColumnData.iterator();
            while (valueColumnDataIterator.hasNext()) {
                Object value = valueColumnDataIterator.next();
                String label = null;
                if (labelColumnDataIterator.hasNext()) {
                    label = (String)labelColumnDataIterator.next();
                }
                if (label == null) {
                    label = value.toString();
                }
                if (!(label instanceof String)) {
                    label = label.toString();
                }
                valueProvider.setValueForLabel(value, label, labelColumnLocale);
            }
        }
        return valueProvider;
    }

    public static QueryProperty findQueryProperty(String name, List<QueryProperty> queryProperties) {
        for (QueryProperty queryProperty : queryProperties) {
            if (queryProperty.getName() == null || !queryProperty.getName().equals(name)) continue;
            return queryProperty;
        }
        return null;
    }

    public static boolean getBooleanQueryPropertyValue(String name, List<QueryProperty> queryProperties, boolean defaultOnNotFoundOrError) {
        String value;
        QueryProperty booleanQueryProperty = ConverterUtil.findQueryProperty(name, queryProperties);
        if (booleanQueryProperty != null && (value = booleanQueryProperty.getValue()) != null) {
            Boolean booleanValue = Boolean.valueOf(value);
            return booleanValue;
        }
        return defaultOnNotFoundOrError;
    }
}

