/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.storage.simplesqlmodel.BaseOperator;
import com.sas.storage.simplesqlmodel.Evaluator;
import com.sas.storage.simplesqlmodel.FormattedOperator;
import com.sas.storage.simplesqlmodel.OperatorInterface;
import com.sas.storage.simplesqlmodel.RB;
import com.sas.storage.simplesqlmodel.StringOperand;
import com.sas.storage.simplesqlmodel.ValueOperandV2Interface;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class MultiValueFormattedOperator
extends BaseOperator
implements Evaluator {
    private OperatorInterface operator;
    private int constantInitialOperandCount;
    private int operatorOperandCount;
    private String combination;
    public static final MultiValueFormattedOperator EQUAL_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.EQUAL_OPERATOR, 1, 1, " OR ");
    public static final MultiValueFormattedOperator LESS_THAN_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.LESS_THAN_OPERATOR, 1, 1, " AND ");
    public static final MultiValueFormattedOperator GREATER_THAN_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.GREATER_THAN_OPERATOR, 1, 1, " AND ");
    public static final MultiValueFormattedOperator LESS_THAN_EQUAL_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.LESS_THAN_EQUAL_OPERATOR, 1, 1, " AND ");
    public static final MultiValueFormattedOperator GREATER_THAN_EQUAL_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.GREATER_THAN_EQUAL_OPERATOR, 1, 1, " AND ");
    public static final MultiValueFormattedOperator NOT_EQUAL_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.NOT_EQUAL_OPERATOR, 1, 1, " AND ");
    public static final MultiValueFormattedOperator LIKE_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.LIKE_OPERATOR, 1, 1, " OR ");
    public static final MultiValueFormattedOperator CONTAINS_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.CONTAINS_OPERATOR, 1, 1, " OR ");
    public static final MultiValueFormattedOperator DATE_EQUAL_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.BETWEEN_OPERATOR, 1, 2, " OR ");
    public static final MultiValueFormattedOperator DATE_LESS_THAN_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.LESS_THAN_DATE_START_OPERATOR, 1, 2, " AND ");
    public static final MultiValueFormattedOperator DATE_GREATER_THAN_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.GREATER_THAN_DATE_END_OPERATOR, 1, 2, " AND ");
    public static final MultiValueFormattedOperator DATE_LESS_THAN_EQUAL_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.LESS_THAN_EQUAL_DATE_END_OPERATOR, 1, 2, " AND ");
    public static final MultiValueFormattedOperator DATE_GREATER_THAN_EQUAL_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.GREATER_THAN_EQUAL_DATE_START_OPERATOR, 1, 2, " AND ");
    public static final MultiValueFormattedOperator DATE_NOT_EQUAL_OPERATOR = new MultiValueFormattedOperator(FormattedOperator.NOT_BETWEEN_OPERATOR, 1, 2, " AND ");
    private static Map operatorMap = null;

    public static Map getOperatorMap() {
        if (operatorMap == null) {
            HashMap<String, MultiValueFormattedOperator> map = new HashMap<String, MultiValueFormattedOperator>();
            map.put("MultiValueFormattedOperator:Equal", EQUAL_OPERATOR);
            map.put("MultiValueFormattedOperator:LessThan", LESS_THAN_OPERATOR);
            map.put("MultiValueFormattedOperator:GreaterThan", GREATER_THAN_OPERATOR);
            map.put("MultiValueFormattedOperator:LessThanEqual", LESS_THAN_EQUAL_OPERATOR);
            map.put("MultiValueFormattedOperator:GreaterThanEqual", GREATER_THAN_EQUAL_OPERATOR);
            map.put("MultiValueFormattedOperator:NotEqual", NOT_EQUAL_OPERATOR);
            map.put("MultiValueFormattedOperator:Like", LIKE_OPERATOR);
            map.put("MultiValueFormattedOperator:Contains", CONTAINS_OPERATOR);
            map.put("MultiValueFormattedOperator:DateEqual", DATE_EQUAL_OPERATOR);
            map.put("MultiValueFormattedOperator:DateLessThan", DATE_LESS_THAN_OPERATOR);
            map.put("MultiValueFormattedOperator:DateGreaterThan", DATE_GREATER_THAN_OPERATOR);
            map.put("MultiValueFormattedOperator:DateLessThanEqual", DATE_LESS_THAN_EQUAL_OPERATOR);
            map.put("MultiValueFormattedOperator:DateGreaterThanEqual", DATE_GREATER_THAN_EQUAL_OPERATOR);
            map.put("MultiValueFormattedOperator:DateNotEqual", DATE_NOT_EQUAL_OPERATOR);
            operatorMap = map;
        }
        return operatorMap;
    }

    public static List getNumericComparisonOperators() {
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>();
        valueItemList.add(new ValueItem((Object)"=", (Object)EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)">", (Object)GREATER_THAN_OPERATOR));
        valueItemList.add(new ValueItem((Object)"<", (Object)LESS_THAN_OPERATOR));
        valueItemList.add(new ValueItem((Object)">=", (Object)GREATER_THAN_EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)"<=", (Object)LESS_THAN_EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)"!=", (Object)NOT_EQUAL_OPERATOR));
        return valueItemList;
    }

    public static List getCharComparisonOperators() {
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>();
        valueItemList.add(new ValueItem((Object)RB.getStringResource("MVFO.contains.txt"), (Object)CONTAINS_OPERATOR));
        valueItemList.add(new ValueItem((Object)RB.getStringResource("MVFO.equal.txt"), (Object)EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)RB.getStringResource("MVFO.like.txt"), (Object)LIKE_OPERATOR));
        valueItemList.add(new ValueItem((Object)RB.getStringResource("MVFO.notequal.txt"), (Object)NOT_EQUAL_OPERATOR));
        return valueItemList;
    }

    public static List getDateComparisonOperators() {
        ArrayList<ValueItem> valueItemList = new ArrayList<ValueItem>();
        valueItemList.add(new ValueItem((Object)"=", (Object)DATE_EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)">", (Object)DATE_GREATER_THAN_OPERATOR));
        valueItemList.add(new ValueItem((Object)"<", (Object)DATE_LESS_THAN_OPERATOR));
        valueItemList.add(new ValueItem((Object)">=", (Object)DATE_GREATER_THAN_EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)"<=", (Object)DATE_LESS_THAN_EQUAL_OPERATOR));
        valueItemList.add(new ValueItem((Object)"!=", (Object)DATE_NOT_EQUAL_OPERATOR));
        return valueItemList;
    }

    public MultiValueFormattedOperator() {
        this.constantInitialOperandCount = 1;
        this.operator = FormattedOperator.EQUAL_OPERATOR;
        this.operatorOperandCount = 1;
        this.combination = " OR ";
    }

    public MultiValueFormattedOperator(OperatorInterface operator, int constantInitialOperandCount, int operatorOperandCount, String combination) {
        this.constantInitialOperandCount = constantInitialOperandCount;
        this.operator = operator;
        this.operatorOperandCount = operatorOperandCount;
        this.combination = combination;
    }

    @Override
    public String formatOperands(List operands, Map context) {
        StringBuffer formattedOperands = new StringBuffer();
        operands = this.expandOperands(operands, context);
        boolean nottedOperandPresent = FormattedOperator.isNotFlagOperandInList(operands);
        int index = 1;
        boolean done = false;
        while (!done) {
            ArrayList partialOperands = new ArrayList();
            partialOperands.addAll(operands.subList(0, this.constantInitialOperandCount));
            partialOperands.addAll(operands.subList(index, index + this.operatorOperandCount));
            String partialOutput = this.operator.formatOperands(partialOperands, context);
            formattedOperands.append(" ( ");
            formattedOperands.append(partialOutput);
            formattedOperands.append(" ) ");
            if ((index += this.operatorOperandCount) + this.operatorOperandCount > operands.size()) {
                done = true;
            }
            if (done) continue;
            formattedOperands.append(this.combination);
        }
        String output = formattedOperands.toString();
        if (nottedOperandPresent) {
            StringOperand toBeNottedOperand = new StringOperand(output, false);
            ArrayList<StringOperand> toBeNottedOperands = new ArrayList<StringOperand>(1);
            toBeNottedOperands.add(toBeNottedOperand);
            output = FormattedOperator.NOT_OPERATOR.formatOperands(toBeNottedOperands, context);
        }
        return output;
    }

    public String getCombination() {
        return this.combination;
    }

    public int getConstantInitialOperandCount() {
        return this.constantInitialOperandCount;
    }

    public OperatorInterface getOperator() {
        return this.operator;
    }

    public int getOperatorOperandCount() {
        return this.operatorOperandCount;
    }

    @Override
    public String getDefinitionElementName() {
        return "MultiValueFormattedOperator";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.combination = provider.consumeAttr("combination");
        this.constantInitialOperandCount = provider.consumeIntAttr("constantInitialOperandCount", 1);
        this.operatorOperandCount = provider.consumeIntAttr("operatorOperandCount", 1);
        this.getLogger2().debug("Ran consumeAttributes().");
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.combination) {
            XmlUtil.setAttr(element, "combination", this.getCombination());
        }
        XmlUtil.setIntAttr(element, "constantInitialOperandCount", this.constantInitialOperandCount);
        XmlUtil.setIntAttr(element, "operatorOperandCount", this.operatorOperandCount);
    }

    @Override
    public boolean evaluateOperandsAsBoolean(List<ValueOperandV2Interface> list, Locale locale, Map context) {
        return false;
    }

    @Override
    public Object evaluateOperands(List<ValueOperandV2Interface> list, Locale locale, Map context) {
        return false;
    }
}

