/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.util.Strings;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class ColumnInfo
extends AbstractPersistence
implements OperandInterface {
    public static String DEFAULT_FORMAT = "-Default-";
    public static final String SORT_ASCENDING = "ASCENDING";
    public static final String SORT_DESCENDING = "DESCENDING";
    private String name = "";
    private String sortOrder = "";
    private String format = "";
    private boolean needQuoting;

    public ColumnInfo(String name, String sortOrder, String format) {
        this.setName(name);
        this.sortOrder = sortOrder;
        this.format = format;
    }

    public ColumnInfo(String name, String sortOrder) {
        this(name, sortOrder, "");
    }

    public ColumnInfo(String name) {
        this(name, "", "");
    }

    public ColumnInfo() {
    }

    @Override
    public String getDefinitionElementName() {
        return "ColumnInfo";
    }

    private String getNameWithQuotes() {
        StringBuffer nameWithQuote = new StringBuffer(this.name.length() + 3);
        nameWithQuote.append("'");
        nameWithQuote.append(this.name);
        nameWithQuote.append("'n");
        this.getLogger2().debug("getNameWithQuotes() is:", nameWithQuote.toString());
        return nameWithQuote.toString();
    }

    public String getNameWithFormat() {
        if (this.format == "" || this.format == null || this.format.length() == 0 || this.format.trim().length() == 0) {
            return this.needQuoting ? this.getNameWithQuotes() : this.name;
        }
        StringBuffer nameWithFormat = new StringBuffer(this.name.length() + 20);
        nameWithFormat.append("put(");
        if (this.needQuoting) {
            nameWithFormat.append(this.getNameWithQuotes());
        } else {
            nameWithFormat.append(this.name);
        }
        nameWithFormat.append(", ");
        nameWithFormat.append(this.format);
        nameWithFormat.append(")");
        this.getLogger2().debug("getNameWithFormat() is:", nameWithFormat.toString());
        return nameWithFormat.toString();
    }

    public void setNeedQuoting(boolean needQuotes) {
        this.needQuoting = needQuotes;
        if (null != this.name && this.nameNeedsQuoting(this.name)) {
            this.needQuoting = true;
        }
    }

    private boolean nameNeedsQuoting(String name) {
        if (name == null) {
            return false;
        }
        if (name.equals("*")) {
            return false;
        }
        if (Strings.needsQuoting((String)name)) {
            return true;
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (!Character.isSpaceChar(c) && c != '/' && c != '&' && c != '{' && c != '}' && c != '*') continue;
            return true;
        }
        return false;
    }

    public boolean needQuoting() {
        return this.needQuoting;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (Strings.needsQuoting((String)name)) {
            this.needQuoting = true;
        }
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public String getOperandAsString(Map context) {
        return this.getNameWithFormat();
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String sort;
        String name;
        super.consumeAttributes(provider);
        String format = provider.consumeAttr("format");
        if (null != format) {
            this.setFormat(format);
        }
        if (null != (name = provider.consumeAttr("name"))) {
            this.setName(name);
        }
        if (null != (sort = provider.consumeAttr("sortOrder"))) {
            this.setSortOrder(sort);
        }
        this.getLogger2().debug("Ran consumeAttributes().");
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing definition.");
        XmlUtil.setAttrWithEmptyAsNull(element, "format", this.getFormat());
        XmlUtil.setAttrWithEmptyAsNull(element, "name", this.getName());
        XmlUtil.setAttrWithEmptyAsNull(element, "sortOrder", this.getSortOrder());
    }
}

