/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever.dto;

import com.sas.PublicClonable;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.BaseAbstractPersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class QueryProperties
extends BaseAbstractPersistence
implements PublicClonable {
    private static final long serialVersionUID = 1002989943714093416L;
    private Map<String, Object> _queryProperties = new HashMap<String, Object>();
    private boolean _distinct;
    private Collection<Object> _filterExpressions;
    public static String VALUE_DISPLAYED = "DISPLAY_VALUE";

    public QueryProperties() {
        this.setDistinct(true);
    }

    public boolean getDistinct() {
        return this._distinct;
    }

    public void setDistinct(boolean distinct) {
        this._distinct = distinct;
    }

    public Map<String, Object> getUserDefinedProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.putAll(this._queryProperties);
        return m;
    }

    public void setUserDefinedProperties(Map<String, Object> prop) {
        this._queryProperties.putAll(prop);
    }

    public Collection<Object> getFilterExpressions() {
        return this._filterExpressions;
    }

    public void setFilterExpressions(Collection<Object> filterExps) {
        if (this._filterExpressions == null) {
            this._filterExpressions = new CopyOnWriteArrayList<Object>();
        }
        this._filterExpressions.addAll(filterExps);
    }

    public Object clone() throws CloneNotSupportedException {
        Map<String, Object> m;
        QueryProperties clone = (QueryProperties)super.clone();
        clone.setDistinct(this.getDistinct());
        Collection<Object> c = this.getFilterExpressions();
        if (c != null && !c.isEmpty()) {
            ArrayList<Object> clonedColl = new ArrayList<Object>();
            Iterator<Object> iter = c.iterator();
            while (iter.hasNext()) {
                clonedColl.add(iter.next());
            }
            clone.setFilterExpressions(clonedColl);
        }
        if ((m = this.getUserDefinedProperties()) != null && !m.isEmpty()) {
            Map clonedMap = (Map)((HashMap)m).clone();
            clone.setUserDefinedProperties(clonedMap);
        }
        return clone;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList keyList = roHolder.consumeObjects("key");
        ArrayList valueList = roHolder.consumeObjects("value");
        this.processValuesLabels(keyList, valueList);
    }

    final void processValuesLabels(List<PersistenceInterface> keyList, List<PersistenceInterface> valueList) {
        HashMap<String, BasePersistedValue> keyMap = new HashMap<String, BasePersistedValue>();
        for (BasePersistedValue basePersistedValue : keyList) {
            keyMap.put(basePersistedValue.getIndex(), basePersistedValue);
        }
        for (BasePersistedValue basePersistedValue : valueList) {
            keyMap.put(basePersistedValue.getIndex(), basePersistedValue);
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.getLogger2().debug("Running consumeAttributes().");
        this.setDistinct(provider.consumeBooleanAttr("distinct", true));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing definition.");
        XmlUtil.setBooleanAttr(element, "distinct", this.getDistinct(), true);
        if (this._queryProperties != null && !this._queryProperties.isEmpty()) {
            List<PersistenceInterface> keyList = this.getWritableItems(this._queryProperties.keySet());
            QueryProperties.writeRelatedObjects(keyList, element, writingContext, "key");
            List<PersistenceInterface> valueList = this.getWritableValues(this._queryProperties.values());
            QueryProperties.writeRelatedObjects(valueList, element, writingContext, "value");
        }
    }

    private List<PersistenceInterface> getWritableItems(Set<String> keySet) {
        ArrayList<PersistenceInterface> keys = new ArrayList<PersistenceInterface>();
        Iterator<String> iter = keySet.iterator();
        while (iter.hasNext()) {
            PersistenceInterface key = ValueUtil.getPersistableValue(iter.next());
            keys.add(key);
        }
        return keys;
    }

    private List<PersistenceInterface> getWritableValues(Collection<Object> collection) {
        ArrayList<PersistenceInterface> values = new ArrayList<PersistenceInterface>();
        Iterator<Object> iter = collection.iterator();
        while (iter.hasNext()) {
            PersistenceInterface value = ValueUtil.getPersistableValue(iter.next());
            values.add(value);
        }
        return values;
    }
}

