/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever.dto;

import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.storage.retriever.dto.MetadataItemInterface;
import com.sas.storage.retriever.dto.ValueDataType;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.BaseAbstractPersistence;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MetadataItem
extends BaseAbstractPersistence
implements MetadataItemInterface {
    private static final long serialVersionUID = -6914828273537613168L;
    private DataSourceInterface _dataSource;
    private ValueDataType _itemTypeToRetrieve;

    public MetadataItem() {
    }

    public MetadataItem(DataSourceInterface ds) {
        this._dataSource = ds;
    }

    public void setDataSource(DataSourceInterface ds) {
        this._dataSource = ds;
    }

    @Override
    public DataSourceInterface getDataSource() {
        return this._dataSource;
    }

    @Override
    public ValueDataType getItemTypeToRetrieve() {
        return this._itemTypeToRetrieve;
    }

    public void setItemTypeToRetrieve(ValueDataType itemType) {
        this._itemTypeToRetrieve = itemType;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        this.setDataSource((DataSourceInterface)roHolder.consumeObject("DataSource"));
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String dtString = provider.consumeAttr("dataType");
        if (null != dtString) {
            this.setItemTypeToRetrieve(ValueDataType.valueOf(dtString));
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr(element, "dataType", this.getItemTypeToRetrieve().toString());
        DataSourceInterface ds = this.getDataSource();
        ArrayList<PersistenceInterface> valueObjects = new ArrayList<PersistenceInterface>();
        PersistenceInterface itemValue = ValueUtil.getPersistableValue(ds);
        valueObjects.add(itemValue);
        MetadataItem.writeRelatedObjects(valueObjects, element, writingContext, "DataSource");
    }

    public Object clone() throws CloneNotSupportedException {
        MetadataItem clone = (MetadataItem)super.clone();
        DataSourceInterface ds = this.getDataSource();
        if (ds != null) {
            clone.setDataSource((DataSourceInterface)ds.clone());
        }
        clone.setItemTypeToRetrieve(this.getItemTypeToRetrieve());
        return clone;
    }
}

