/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever;

import com.sas.PublicClonable;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.storage.retriever.dto.ColumnValueItem;
import com.sas.storage.retriever.dto.ValueDataType;
import com.sas.uiconfig.ResourceBundleDelegate;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.BaseAbstractPersistence;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class BaseLocalizableColumn
extends BaseAbstractPersistence
implements PublicClonable,
MultiLocaleProperties {
    private static final long serialVersionUID = 1L;
    private LocalizablePersistableString columnLabel = new LocalizablePersistableString();
    protected ColumnValueItem item = new ColumnValueItem();
    private transient ResourceBundleDelegate resourceBundleDelegate;

    public void setData(ColumnValueItem item) {
        ValidateArg.notNull((Object)item, (String)"item");
        ValidateArg.notBlank((String)item.getName(), (String)"item.getColumnName");
        ValidateArg.notBlank((String)item.getLocale(), (String)"item.getLocale");
        ValidateArg.notNull((Object)((Object)item.getDataType()), (String)"item.getDataType");
        this.item = item;
        this.columnLabel.clearAll();
        if (item.getLabel() != null) {
            Locale locale = XmlUtil.xmlToLocale(item.getLocale());
            this.columnLabel.setText(item.getLabel(), locale);
        }
    }

    public void setColumnLabel(Locale locale, String columnLabel) {
        this.columnLabel.setText(columnLabel, locale);
    }

    protected final ColumnValueItem copyColumnValueItem(Locale locale) {
        String delText;
        ValidateArg.notNull((Object)locale, (String)"locale");
        ColumnValueItem retVal = new ColumnValueItem();
        String text = this.columnLabel.getText(locale);
        if (null != this.getResourceBundleDelegate() && null != (delText = this.getResourceBundleDelegate().getText(text, locale))) {
            text = delText;
        }
        retVal.setLabel(text);
        retVal.setName(this.item.getName());
        retVal.setLocale(locale.toString());
        retVal.setDataType(this.item.getDataType());
        return retVal;
    }

    public String toString() {
        return this.item.toString();
    }

    public boolean matches(ColumnValueItem obj) {
        return this.item.matches(obj);
    }

    String getColumnName() {
        return this.item.getName();
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String dtString;
        super.consumeAttributes(provider);
        String nameString = provider.consumeAttr("columnName");
        if (null != nameString) {
            this.getLogger2().debug("consumeAttributes(), ", nameString);
            this.item.setName(nameString);
        }
        if (null != (dtString = provider.consumeAttr("dataType"))) {
            this.getLogger2().debug("consumeAttributes(), make dataType:", dtString);
            this.item.setDataType(ValueDataType.valueOf(dtString));
        }
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList valuesList;
        super.consumeRelatedObjects(roHolder);
        ArrayList msgList = roHolder.consumeObjects("HeaderText");
        if (!msgList.isEmpty()) {
            this.columnLabel = (LocalizablePersistableString)msgList.get(0);
            this.getLogger2().debug("consumeRelatedObjects() for columnLabel");
        }
        if (!(valuesList = roHolder.consumeObjects("Values")).isEmpty()) {
            this.getLogger2().debug("consumeRelatedObjects() for rowData");
            LinkedList<Object> list = new LinkedList<Object>();
            for (BasePersistedValue valueObj : valuesList) {
                list.add(Integer.parseInt(valueObj.getIndex()), valueObj.getValue());
            }
            this.item.setRowData(list);
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.item.getDataType()) {
            XmlUtil.setAttr(element, "dataType", this.item.getDataType().toString());
        }
        XmlUtil.setAttr(element, "columnName", this.item.getName());
        if (!this.columnLabel.getLocales().isEmpty()) {
            ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
            list.add(this.columnLabel);
            this.getLogger2().debug("Writing labels.");
            BaseLocalizableColumn.writeRelatedObjects(list, element, writingContext, "HeaderText");
        }
        int i = 0;
        ArrayList<PersistenceInterface> listValues = new ArrayList<PersistenceInterface>();
        Iterator<Object> iter = this.item.getRowData().iterator();
        while (iter.hasNext()) {
            String index = Integer.toString(i);
            try {
                BasePersistedValue t = PersistenceFactory.newPersistedValue(this.item.getDataType().getEquivalentPersistedValue(), null);
                t.setIndex(index);
                t.setValue(iter.next());
                listValues.add(t);
                ++i;
            }
            catch (ClassNotFoundException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        BaseLocalizableColumn.writeRelatedObjects(listValues, element, writingContext, "Values");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected final void configureClone(BaseLocalizableColumn retVal) throws CloneNotSupportedException {
        retVal.item.setDataType(this.item.getDataType());
        retVal.item.setRowData(this.item.getRowData());
        retVal.item.setName(this.item.getName());
        retVal.item.setLocale(this.item.getLocale());
        retVal.columnLabel = (LocalizablePersistableString)this.columnLabel.clone();
    }

    @Override
    public void beginLocalization() throws UnexpectedLocalizationException {
    }

    @Override
    public void endLocalization() throws UnexpectedLocalizationException {
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        ValidateArg.notNull((Object)locale, (String)"locale");
        ValidateArg.notNull((Object)map, (String)"property map");
        this.getLogger2().debug("setLocalizableProperties on :", this.item.getName());
        this.columnLabel.setLocalizableProperties(locale, map);
    }

    public Collection getLocales() throws UnexpectedLocalizationException {
        return this.columnLabel.getLocales();
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        return this.columnLabel.getLocalizableProperties(locale);
    }

    @Override
    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        return this.getLocalizableProperties(Locale.getDefault());
    }

    @Override
    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        this.setLocalizableProperties(Locale.getDefault(), map);
    }

    public final ResourceBundleDelegate getResourceBundleDelegate() {
        return this.resourceBundleDelegate;
    }

    public final void setResourceBundleDelegate(ResourceBundleDelegate resourceBundleDelegate) {
        this.resourceBundleDelegate = resourceBundleDelegate;
    }
}

