/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.sasmdx.TupleElement;
import com.sas.storage.olap.tree.DimensionNode;
import com.sas.storage.olap.tree.HierarchyNode;
import com.sas.storage.olap.tree.LevelNode;
import com.sas.storage.olap.tree.MemberNode;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import com.sas.storage.olap.tree.OLAPDataTreeNode;
import com.sas.storage.olap.tree.TupleElementNode;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class MetadataTreeModel
extends DefaultTreeModel {
    private MetadataInterface metadata;
    private String cubeName;
    private int treeType;
    private boolean displayAllMember;
    private int threshold;

    public MetadataTreeModel(OLAPDataTreeNode rootNode) {
        super(rootNode, true);
        this.threshold = -1;
        this.setAsksAllowsChildren(false);
    }

    public MetadataTreeModel(MetadataEntityTreeNode rootNode, int treeType, boolean displayAllMember) {
        super(rootNode, true);
        this.setAsksAllowsChildren(false);
        this.treeType = treeType;
        this.displayAllMember = displayAllMember;
        rootNode.setTreeType(treeType);
        rootNode.setDisplayAllMember(displayAllMember);
        rootNode.setThreshold(-1);
    }

    public MetadataTreeModel(MetadataEntityTreeNode rootNode) {
        this(rootNode, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public MetadataTreeModel(MetadataEntityTreeNode rootNode, int treeType) {
        this(rootNode, treeType, false);
    }

    public MetadataTreeModel(MetadataEntityTreeNode rootNode, boolean displayAllMember) {
        this(rootNode, MetadataEntityTreeNode.DEFAULT_TREE, displayAllMember);
    }

    public void setRoot(Object rootNode) {
        if (rootNode != null) {
            if (rootNode instanceof MetadataEntityTreeNode) {
                super.setRoot((MetadataEntityTreeNode)rootNode);
            } else {
                DefaultMutableTreeNode root = null;
                root = rootNode instanceof DimensionInterface ? new DimensionNode((DimensionInterface)rootNode, this.treeType, this.displayAllMember) : (rootNode instanceof HierarchyInterface ? new HierarchyNode((HierarchyInterface)rootNode, this.treeType, this.displayAllMember) : (rootNode instanceof LevelInterface ? new LevelNode((LevelInterface)rootNode, this.treeType, this.displayAllMember) : (rootNode instanceof MemberInterface ? new MemberNode((MemberInterface)rootNode, this.treeType, this.displayAllMember) : new DefaultMutableTreeNode("Dummy Node"))));
                if (root instanceof MetadataEntityTreeNode) {
                    ((MetadataEntityTreeNode)root).setThreshold(this.threshold);
                }
                super.setRoot(root);
            }
        }
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public void setMetadata(MetadataInterface metadata) {
        this.metadata = metadata;
    }

    public void setDimensionNodes(List nodes) {
        if (nodes != null) {
            int i = 0;
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                DimensionNode node = null;
                Object n = iter.next();
                if (n instanceof String) {
                    if (this.metadata == null) {
                        return;
                    }
                    node = new DimensionNode(this.metadata, this.cubeName, (String)n, this.treeType, this.displayAllMember);
                } else if (n instanceof DimensionInterface) {
                    node = new DimensionNode((DimensionInterface)n, this.treeType, this.displayAllMember);
                }
                if (node == null || this.root == null) continue;
                this.insertNodeInto(node, (MutableTreeNode)this.root, i++);
            }
        }
    }

    public void setHierarchyNodes(List nodes) {
        if (nodes != null) {
            int i = 0;
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                HierarchyNode node = null;
                Object n = iter.next();
                if (n instanceof String) {
                    if (this.metadata == null) {
                        return;
                    }
                    node = new HierarchyNode(this.metadata, this.cubeName, (String)n, this.treeType, this.displayAllMember);
                } else if (n instanceof HierarchyInterface) {
                    node = new HierarchyNode((HierarchyInterface)n, this.treeType, this.displayAllMember);
                }
                if (node == null || this.root == null) continue;
                this.insertNodeInto(node, (MutableTreeNode)this.root, i++);
            }
        }
    }

    public void setLevelNodes(List nodes) {
        if (nodes != null) {
            int i = 0;
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                LevelNode node = null;
                Object n = iter.next();
                if (n instanceof String) {
                    if (this.metadata == null) {
                        return;
                    }
                    node = new LevelNode(this.metadata, this.cubeName, (String)n, this.treeType, this.displayAllMember);
                } else if (n instanceof DimensionInterface) {
                    node = new LevelNode((LevelInterface)n, this.treeType, this.displayAllMember);
                }
                if (node == null || this.root == null) continue;
                this.insertNodeInto(node, (MutableTreeNode)this.root, i++);
            }
        }
    }

    public void setMemberNodes(List nodes) {
        if (nodes != null) {
            int i = 0;
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                MemberNode node = null;
                Object n = iter.next();
                if (n instanceof String) {
                    if (this.metadata == null) {
                        return;
                    }
                    node = new MemberNode(this.metadata, this.cubeName, (String)n, this.treeType, this.displayAllMember);
                } else if (n instanceof MemberInterface) {
                    node = new MemberNode((MemberInterface)n, this.treeType, this.displayAllMember);
                }
                if (node == null || this.root == null) continue;
                this.insertNodeInto(node, (MutableTreeNode)this.root, i++);
            }
        }
    }

    public void setTupleElementNodes(List nodes) {
        if (nodes != null) {
            int i = 0;
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                TupleElementNode node = null;
                Object n = iter.next();
                if (!(n instanceof String) && (n instanceof TupleElement || n instanceof TupleElementInterface)) {
                    node = new TupleElementNode((TupleElementInterface)n);
                }
                if (node == null || this.root == null) continue;
                this.insertNodeInto(node, (MutableTreeNode)this.root, i++);
            }
        }
    }

    public void setNodes(List nodes) {
        if (nodes != null) {
            int i = 0;
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                MetadataEntityTreeNode node = null;
                Object n = iter.next();
                if (n instanceof DimensionInterface) {
                    node = new DimensionNode((DimensionInterface)n, this.treeType, this.displayAllMember);
                }
                if (n instanceof HierarchyInterface) {
                    node = new HierarchyNode((HierarchyInterface)n, this.treeType, this.displayAllMember);
                }
                if (n instanceof LevelInterface) {
                    node = new LevelNode((LevelInterface)n, this.treeType, this.displayAllMember);
                }
                if (n instanceof MemberInterface) {
                    node = new MemberNode((MemberInterface)n, this.treeType, this.displayAllMember);
                }
                if (node != null && this.root != null) {
                    this.insertNodeInto(node, (MutableTreeNode)this.root, i++);
                    continue;
                }
                if (!(n instanceof MutableTreeNode) || this.root == null) continue;
                this.insertNodeInto(node, (MutableTreeNode)this.root, i++);
            }
        }
    }
}

