/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import javax.swing.tree.TreeNode;

public class MemberNode
extends MetadataEntityTreeNode {
    private MemberInterface member;
    private boolean isRagged;

    public MemberNode(MemberInterface member) {
        this(member, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public MemberNode(MemberInterface member, int treeType) {
        this(member, treeType, false);
    }

    public MemberNode(MemberInterface member, int treeType, boolean displayAllMember) {
        this.member = member;
        this.userObject = member;
        this.setTreeType(treeType);
        this.setDisplayAllMember(displayAllMember);
        this.setIsRagged();
        this.setThreshold(-1);
    }

    public MemberNode(MetadataInterface metadata, String cubeName, String memberUniqueName) {
        this(metadata, cubeName, memberUniqueName, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public MemberNode(MetadataInterface metadata, String cubeName, String memberUniqueName, int treeType) {
        this(metadata, cubeName, memberUniqueName, treeType, false);
    }

    public MemberNode(MetadataInterface metadata, String cubeName, String memberUniqueName, int treeType, boolean displayAllMember) {
        if (this.findMember(metadata, cubeName, memberUniqueName) == null) {
            this.createDummyNode(memberUniqueName);
        }
        this.setTreeType(treeType);
        this.setDisplayAllMember(displayAllMember);
        this.setIsRagged();
    }

    private void setIsRagged() {
        try {
            if (this.member != null) {
                this.isRagged = this.member.getLevel().getHierarchy().getStructure() == 2 || this.member.getLevel().getHierarchy().getStructure() == 3;
            }
        }
        catch (OLAPException oe) {
            this.isRagged = false;
        }
    }

    @Override
    public String getUniqueName() {
        try {
            return this.member != null ? this.member.getUniqueName() : this.name;
        }
        catch (OLAPException oe) {
            return null;
        }
    }

    @Override
    public int getChildCount() {
        try {
            if (this.childCount == -1 && (this.treeType & MEMBER_TREE) == MEMBER_TREE) {
                this.childCount = this.member.getChildCount();
                this.populateChildren(0);
            } else if (this.childCount == -1 && MEMBER_TREE != (this.treeType & MEMBER_TREE)) {
                this.childCount = 0;
            }
        }
        catch (OLAPException oe) {
            return 0;
        }
        return this.childCount;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (!this.initialized) {
            this.populateChildren(index);
        }
        if (index >= 0 && index < this.getChildCount()) {
            this.initialized = true;
            if (super.getChildAt(index) == null) {
                this.populateChildren(index);
            }
        }
        return super.getChildAt(index);
    }

    protected synchronized boolean populateChildren(int index) {
        try {
            if (this.getChildCount() > 0) {
                MemberInterface[] members = this.getChildren(index, this.threshold);
                this.childCount = members.length;
                for (int j = 0; j < members.length; ++j) {
                    MemberNode m = new MemberNode(members[j], this.treeType, this.displayAllMember());
                    super.insert(m, j);
                    m.setParent(this);
                }
            }
            this.initialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.initialized;
    }

    private MemberInterface[] getChildren(int index, int count) throws OLAPException {
        Filter inFilter = new Filter();
        inFilter.setCubeName(this.member.getCube().getName());
        inFilter.setUniqueMemberName(this.member.getUniqueName());
        inFilter.setTreeOperator(Filter.CHILDREN_TREE_OPERATOR);
        return this.member.getMetadata().getMembers(inFilter, index, count);
    }

    private MemberInterface findMember(MetadataInterface metadata, String cubeName, String uniqueName) {
        try {
            Filter filter = new Filter();
            filter.setCubeName(cubeName);
            filter.setUniqueLevelName(uniqueName);
            this.member = metadata.getMembers(filter, 0, 1)[0];
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return this.member;
    }
}

