/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.tree.HierarchyNode;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;

public class DimensionNode
extends MetadataEntityTreeNode {
    private DimensionInterface dimension;

    public DimensionNode(DimensionInterface dimension) {
        this(dimension, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public DimensionNode(DimensionInterface dimension, int treeType) {
        this(dimension, treeType, false);
    }

    public DimensionNode(DimensionInterface dimension, int treeType, boolean displayAllMember) {
        this.dimension = dimension;
        this.userObject = dimension;
        this.setTreeType(treeType);
        this.setDisplayAllMember(displayAllMember);
    }

    public DimensionNode(MetadataInterface metadata, String cubeName, String dimensionUniqueName) {
        this(metadata, cubeName, dimensionUniqueName, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public DimensionNode(MetadataInterface metadata, String cubeName, String dimensionUniqueName, int treeType) {
        this(metadata, cubeName, dimensionUniqueName, treeType, false);
    }

    public DimensionNode(MetadataInterface metadata, String cubeName, String dimensionUniqueName, int treeType, boolean displayAllMember) {
        if (this.findDimension(metadata, cubeName, dimensionUniqueName) == null) {
            this.createDummyNode(dimensionUniqueName);
        }
        this.setTreeType(treeType);
        this.setDisplayAllMember(displayAllMember);
    }

    @Override
    public int getChildCount() {
        try {
            if (this.childCount == -1) {
                this.childCount = this.dimension.getHierarchies().length;
            }
        }
        catch (OLAPException oe) {
            return 0;
        }
        return this.childCount;
    }

    @Override
    protected synchronized boolean populateChildren() {
        try {
            if (this.getChildCount() > 0) {
                HierarchyInterface[] hierarchies = this.dimension.getHierarchies();
                this.childCount = hierarchies.length;
                for (int j = 0; j < hierarchies.length; ++j) {
                    HierarchyNode h = new HierarchyNode(hierarchies[j], this.treeType, this.displayAllMember());
                    super.insert(h, j);
                    h.setParent(this);
                    h.setThreshold(this.threshold);
                }
            }
            this.initialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.initialized;
    }

    private DimensionInterface findDimension(MetadataInterface metadata, String cubeName, String uniqueName) {
        try {
            Filter filter = new Filter();
            filter.setCubeName(cubeName);
            filter.setUniqueDimensionName(uniqueName);
            this.dimension = metadata.getDimension(filter);
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return this.dimension;
    }
}

