/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.util.Map;

@SASScope(value="ALL")
public class TupleElement
implements TupleElementInterface {
    @SASScope
    protected TupleInterface tuple;
    @SASScope
    protected String label;
    @SASScope
    protected String name;
    @SASScope
    protected boolean isDrilledDown;
    @SASScope
    protected boolean isContinued;
    @SASScope
    protected String levelUniqueName;
    @SASScope
    protected int levelDepth;
    @SASScope
    protected int childCount;
    @SASScope
    protected int minimumCoordinate;
    @SASScope
    protected int maximumCoordinate;
    @SASScope
    protected Map properties;
    @SASScope
    protected boolean isContextual;
    @SASScope
    protected int elementIndex;
    private String displayInfo;
    private TupleElementType type;
    private int span;
    private int spanDepth;

    @SASScope
    public TupleElement(TupleInterface tuple, int elementIndex, String memberUniqueName, String memberLabel, String levelUniqueName, String levelDepth, String displayInfo, Map properties) throws OLAPException {
        this(tuple, elementIndex, memberUniqueName, memberLabel, levelUniqueName, levelDepth, displayInfo, properties, TupleElementType.UNSPECIFIED);
    }

    public TupleElement(TupleInterface tuple, int elementIndex, String memberUniqueName, String memberLabel, String levelUniqueName, String levelDepth, String displayInfo, Map properties, TupleElementType type) throws OLAPException {
        this.tuple = tuple;
        this.label = memberLabel;
        this.name = memberUniqueName;
        this.displayInfo = displayInfo;
        int displayBits = Integer.parseInt(displayInfo);
        this.isContinued = false;
        this.isDrilledDown = false;
        if (displayBits > 131071) {
            this.isContinued = true;
            displayBits -= 131072;
        }
        if (displayBits > 65535) {
            this.isDrilledDown = true;
            displayBits -= 65536;
        }
        this.childCount = displayBits;
        this.elementIndex = elementIndex;
        this.properties = properties;
        this.levelDepth = Integer.parseInt(levelDepth);
        this.levelUniqueName = levelUniqueName;
        this.span = 1;
        this.spanDepth = 1;
        this.type = type == null ? TupleElementType.UNSPECIFIED : type;
    }

    @SASScope
    public TupleElement(TupleInterface tuple) throws OLAPException {
        this.tuple = tuple;
    }

    String getDisplayInfo() {
        return this.displayInfo;
    }

    @Override
    public int getSpan() {
        return this.span;
    }

    @Override
    public void setSpan(int span) {
        this.span = span;
    }

    @Override
    public TupleInterface getTuple() throws OLAPException {
        return this.tuple;
    }

    @Override
    public String getLabel() throws OLAPException {
        return this.label;
    }

    @Override
    public String getName() throws OLAPException {
        return this.name;
    }

    @Override
    public int getTupleElementIndex() throws OLAPException {
        return this.elementIndex;
    }

    @Override
    public boolean isDrilledDown() throws OLAPException {
        return this.isDrilledDown;
    }

    @Override
    public boolean isContinued() throws OLAPException {
        return this.isContinued;
    }

    @Override
    public boolean isContextual() throws OLAPException {
        return this.isContextual;
    }

    @Override
    public String getUniqueLevelName() throws OLAPException {
        return this.levelUniqueName;
    }

    @Override
    public int getLevelDepth() throws OLAPException {
        return this.levelDepth;
    }

    @Override
    public int getChildCount() throws OLAPException {
        return this.childCount;
    }

    @Override
    public Map getProperties() throws OLAPException {
        return this.properties;
    }

    @Override
    public int getMinimumCoordinate() throws OLAPException {
        return this.minimumCoordinate;
    }

    @Override
    public int getMaximumCoordinate() throws OLAPException {
        return this.maximumCoordinate;
    }

    @Override
    public void setMinimumCoordinate(int minimumCoordinate) throws OLAPException {
        this.minimumCoordinate = minimumCoordinate;
    }

    @Override
    public void setMaximumCoordinate(int maximumCoordinate) throws OLAPException {
        this.maximumCoordinate = maximumCoordinate;
    }

    @Override
    public String getFormat() throws OLAPException {
        return null;
    }

    @Override
    public int getSpanDepth() throws OLAPException {
        return this.spanDepth;
    }

    @Override
    public TupleElementType getType() throws OLAPException {
        return this.type;
    }

    @Override
    public void setSpanDepth(int depth) {
        this.spanDepth = depth;
    }

    void setTuple(TupleInterface tuple) {
        this.tuple = tuple;
    }

    void setLabel(String label) {
        this.label = label;
    }

    void setName(String name) {
        this.name = name;
    }

    void setContextual(boolean isContextual) {
        this.isContextual = isContextual;
    }

    void setTupleElementIndex(int index) {
        this.elementIndex = index;
    }

    void setDrilledDown(boolean isDrilledDown) {
        this.isDrilledDown = isDrilledDown;
    }

    void setContinued(boolean isContinued) {
        this.isContinued = isContinued;
    }

    void setUniqueLevelName(String levelUniqueName) {
        this.levelUniqueName = levelUniqueName;
    }

    void setLevelDepth(int levelDepth) {
        this.levelDepth = levelDepth;
    }

    void setChildCount(int childCount) {
        this.childCount = childCount;
    }

    void setProperties(Map properties) {
        this.properties = properties;
    }

    void setType(TupleElementType type) {
        this.type = type;
    }

    public String toString() {
        try {
            String label = this.getLabel();
            if (label != null) {
                label = label.trim();
            }
            return label;
        }
        catch (OLAPException oe) {
            return super.toString();
        }
    }
}

