/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.IMDXServerHelper;
import com.sas.iom.SASMDX.ISession;
import com.sas.models.CacheException;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.MetadataPerformanceTuning;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.SchemaInterface;
import com.sas.storage.olap.sasmdx.RemoteMetadata;
import com.sas.storage.olap.sasmdx.Schema;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;

@SASScope(value="ALL")
public class Metadata
implements MetadataInterface {
    @SASScope
    protected IMDXServer _connection;
    @SASScope
    protected boolean isConnected;
    @SASScope
    protected String username;
    @SASScope
    protected String password;
    @SASScope
    protected String host;
    @SASScope
    protected int port;
    @SASScope
    protected ISession _session;
    @SASScope
    protected Locale locale;
    public static final int MEMBER_CACHE = 0;
    public static final int NON_MEMBER_CACHE = 1;
    public static final int ALL_CACHE = 2;

    public Metadata() throws OLAPException {
    }

    public Metadata(IMDXServer connection) throws OLAPException {
        this.isConnected = false;
        this.setConnection(connection);
    }

    public Metadata(String host, int port, String username, String password) throws OLAPException {
        this.isConnected = false;
        this.setConnection(null);
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public Metadata(ISession session) throws OLAPException {
        if (session != null) {
            this.isConnected = true;
        }
        this._session = session;
    }

    public Metadata(IMDXServer connection, Locale locale) throws OLAPException {
        this.isConnected = false;
        this.setConnection(connection);
        this.locale = locale;
    }

    public Metadata(String host, int port, String username, String password, Locale locale) throws OLAPException {
        this.isConnected = false;
        this.setConnection(null);
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.locale = locale;
    }

    public MetadataPerformanceTuning getPerformanceTuning() throws OLAPException {
        return RemoteMetadata.getPerformanceTuning();
    }

    public void setPerformanceTuning(MetadataPerformanceTuning performanceTuning) throws OLAPException {
        try {
            RemoteMetadata.setPerformanceTuning(performanceTuning);
        }
        catch (CacheException ce) {
            throw new OLAPException(ce);
        }
    }

    public static void clearCache(java.lang.Object connObject, int cacheType) throws OLAPException {
        try {
            RemoteMetadata.clearCache(null, connObject, cacheType);
        }
        catch (CacheException ce) {
            throw new OLAPException(ce);
        }
    }

    public static void clearCache(Filter filter, java.lang.Object connObject, int cacheType) throws OLAPException {
        try {
            RemoteMetadata.clearCache(filter, connObject, cacheType);
        }
        catch (CacheException ce) {
            throw new OLAPException(ce);
        }
    }

    @Override
    public java.lang.Object getConnection() throws OLAPException {
        if (this._connection == null) {
            return this._session;
        }
        return this._connection;
    }

    @Override
    public void setConnection(java.lang.Object con) throws OLAPException {
        if (con != null && con instanceof ISession) {
            this._session = (ISession)con;
            this.isConnected = true;
        } else if (con != null) {
            this._connection = (IMDXServer)con;
            this.isConnected = true;
        }
    }

    @Override
    public void setLocale(Locale locale) throws OLAPException {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() throws OLAPException {
        return this.locale;
    }

    @Override
    public SchemaInterface[] getSchemas() throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        Filter filter = new Filter();
        return this.getSchemas(filter);
    }

    @Override
    public SchemaInterface[] getSchemas(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        StringSeqHolder schemaNames = new StringSeqHolder();
        ISession _nsession = RemoteMetadata.createSession(this);
        int nSchemas = RemoteMetadata.SchemaMetadata(_nsession, filter.getCatalogName(), filter.getSchemaName(), schemaNames);
        RemoteMetadata.closeSession(_nsession);
        SchemaInterface[] schemas = new SchemaInterface[nSchemas];
        for (int i = 0; i < nSchemas; ++i) {
            schemas[i] = new Schema(this, this._session, schemaNames.value[i]);
        }
        return schemas;
    }

    @Override
    public SchemaInterface getSchema(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        StringSeqHolder schemaNames = new StringSeqHolder();
        int nSchemas = RemoteMetadata.SchemaMetadata(this._session, filter.getCatalogName(), filter.getSchemaName(), schemaNames);
        if (nSchemas >= 1) {
            return new Schema(this, this._session, schemaNames.value[0]);
        }
        throw new OLAPException("Schema cannot be found for the specified restriction");
    }

    @Override
    public CubeInterface[] getCubes(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.CubeMetadata(this, this._session, filter);
    }

    @Override
    public CubeInterface getCube(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.getCube(this, this._session, filter);
    }

    @Override
    public DimensionInterface[] getDimensions(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.DimMetadata(this, this._session, filter);
    }

    @Override
    public DimensionInterface getDimension(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.getDimension(this, this._session, filter);
    }

    @Override
    public HierarchyInterface[] getHierarchies(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.HierMetadata(this, this._session, filter);
    }

    @Override
    public HierarchyInterface getHierarchy(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.getHierarchy(this, this._session, filter);
    }

    @Override
    public LevelInterface[] getLevels(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.LvlMetadata(this, this._session, filter);
    }

    @Override
    public LevelInterface getLevel(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.getLevel(this, this._session, filter);
    }

    @Override
    public MeasureInterface[] getMeasures(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.MeasureMetadata(this, this._session, filter);
    }

    @Override
    public MeasureInterface getMeasure(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.getMeasure(this, this._session, filter);
    }

    @Override
    public PropertyInterface[] getProperties(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.PropMetadata(this, this._session, filter);
    }

    @Override
    public PropertyInterface getProperty(Filter filter) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.getProperty(this, this._session, filter);
    }

    @Override
    public MemberInterface[] getMembers(Filter filter, int start, int count) throws OLAPException {
        if (!this.isConnected) {
            this.establishConnection();
        }
        return RemoteMetadata.MemMetadata(this, this._session, filter, start, count);
    }

    @SASScope
    protected void establishConnection() throws OLAPException {
        if (this.isConnected) {
            return;
        }
        try {
            if (this._connection == null) {
                if (this.host == null || this.port == 0) {
                    throw new IllegalStateException("Host and Port are required to create connection");
                }
                String classID = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
                BridgeServer server = new BridgeServer(classID, this.host, this.port);
                ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)server);
                String loggerName = ConnectionFactoryManager.getConnectionFactoryLoggerName((ConnectionFactoryConfiguration)cxfConfig);
                Logger logger = Logger.getLogger(loggerName);
                logger.setLevel(Level.OFF);
                ConnectionFactoryInterface cxf = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
                ConnectionInterface cx = cxf.getConnection(this.username, this.password);
                Object obj = cx.getObject();
                this._connection = IMDXServerHelper.narrow((Object)obj);
            }
        }
        catch (Exception ex) {
            throw new OLAPException(ex.getMessage());
        }
        this.isConnected = true;
    }
}

