/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.ISession;
import com.sas.models.CacheException;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.sasmdx.CacheableInfo;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SASScope
public class MembersCache
extends LinkedHashMap {
    private static int CATALOG_NAME_WEIGHT = 2;
    private static int SCHEMA_NAME_WEIGHT = 4;
    private static int CUBE_NAME_WEIGHT = 8;
    private static int DIMENSION_NAME_WEIGHT = 16;
    private static int UNIQUE_DIMENSION_NAME_WEIGHT = 32;
    private static int HIERARCHY_NAME_WEIGHT = 64;
    private static int UNIQUE_HIERARCHY_NAME_WEIGHT = 128;
    private static int LEVEL_NAME_WEIGHT = 256;
    private static int UNIQUE_LEVEL_NAME_WEIGHT = 512;
    private static int LEVEL_NUMBER_WEIGHT = 1024;
    private static int MEASURE_NAME_WEIGHT = 2048;
    private static int UNIQUE_MEASURE_NAME_WEIGHT = 4096;
    private static int MEMBER_NAME_WEIGHT = 8192;
    private static int UNIQUE_MEMBER_NAME_WEIGHT = 16384;
    private static int MEMBER_LABEL_WEIGHT = 32768;
    private static int TYPE_WEIGHT = 65536;
    private static int TREE_OPERATOR_WEIGHT = 131072;
    private static int PROPERTY_NAME_WEIGHT = 262144;
    private static int PROPERTY_TYPE_WEIGHT = 524288;
    private int bufferSize;
    private int lookAhead;
    private int maxFilters;
    private int filtersCounter;

    public MembersCache(int bufferSize, int lookAhead, int maxFilters) {
        super(16, 0.75f, true);
        this.maxFilters = maxFilters;
        this.lookAhead = lookAhead;
        this.bufferSize = bufferSize;
    }

    public List getMembers(MetadataInterface metadata, ISession _session, Filter filter, int start, int count) throws CacheException {
        LinkedHashMap currentContainer = this.getContainer(filter, false);
        CacheableInfo currentCacheableInfo = this.getCacheableInfo(metadata, _session, currentContainer, filter, start, count);
        return currentCacheableInfo.getMatch(start, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap getContainer(Filter filter, boolean existingOnly) {
        Integer key = this.getKeyFromFilter(filter);
        LinkedHashMap currentContainer = null;
        MembersCache membersCache = this;
        synchronized (membersCache) {
            if (this.containsKey(key)) {
                currentContainer = (LinkedHashMap)this.get(key);
            } else if (!existingOnly) {
                currentContainer = new LinkedHashMap(16, 0.75f, true);
                this.put(key, currentContainer);
            }
        }
        return currentContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheableInfo getCacheableInfo(MetadataInterface metadata, ISession _session, LinkedHashMap container, Filter filter, int start, int count) throws CacheException {
        LinkedHashMap linkedHashMap = container;
        synchronized (linkedHashMap) {
            for (CacheableInfo currentCacheableInfo : container.values()) {
                if (!currentCacheableInfo.doRestrictionsMatch(_session, filter, start, count)) continue;
                return currentCacheableInfo;
            }
        }
        if (this.filtersCounter == this.maxFilters) {
            this.removeEldestCacheableInfo();
        }
        CacheableInfo currentCacheableInfo = new CacheableInfo(metadata, _session, filter, this.bufferSize, this.lookAhead);
        LinkedHashMap linkedHashMap2 = container;
        synchronized (linkedHashMap2) {
            container.put(currentCacheableInfo, currentCacheableInfo);
        }
        ++this.filtersCounter;
        return currentCacheableInfo;
    }

    public void remove(Filter filter, Object connObject) {
        if (filter == null || connObject == null) {
            this.removeCacheableInfos(filter, connObject);
        } else {
            LinkedHashMap container = this.getContainer(filter, true);
            if (container != null) {
                this.removeCacheableInfos(container, filter, connObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCacheableInfos(LinkedHashMap container, Filter filter, Object connObject) {
        LinkedHashMap linkedHashMap = container;
        synchronized (linkedHashMap) {
            Set entrySet = container.entrySet();
            for (Map.Entry entry : entrySet) {
                CacheableInfo cacheableInfo = (CacheableInfo)entry.getValue();
                if (cacheableInfo.getConnection() != connObject || !cacheableInfo.getFilter().isMatch(filter)) continue;
                entrySet.remove(entry);
                --this.filtersCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeCacheableInfos(Filter filter, Object connObject) {
        Iterator iter = this.values().iterator();
        while (iter.hasNext()) {
            LinkedHashMap container;
            LinkedHashMap linkedHashMap = container = (LinkedHashMap)iter.next();
            synchronized (linkedHashMap) {
                Set entrySet = container.entrySet();
                Iterator iterator = entrySet.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    CacheableInfo cacheableInfo = (CacheableInfo)entry.getValue();
                    if (!(connObject != null && cacheableInfo.getConnection() == connObject || filter != null && cacheableInfo.getFilter().isMatch(filter)) && (filter != null || connObject != null)) continue;
                    iterator.remove();
                    --this.filtersCounter;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeEldestCacheableInfo() {
        Iterator iter1 = this.values().iterator();
        if (iter1.hasNext()) {
            LinkedHashMap container;
            LinkedHashMap linkedHashMap = container = (LinkedHashMap)iter1.next();
            synchronized (linkedHashMap) {
                Iterator iter2 = container.keySet().iterator();
                if (iter2.hasNext()) {
                    container.remove(iter2.next());
                    --this.filtersCounter;
                }
            }
        }
    }

    private int getKeyFromFilter(Filter filter) {
        int key = 0;
        if (!filter.getCatalogName().equals("")) {
            key |= CATALOG_NAME_WEIGHT;
        }
        if (!filter.getSchemaName().equals("")) {
            key |= SCHEMA_NAME_WEIGHT;
        }
        if (!filter.getCubeName().equals("")) {
            key |= CUBE_NAME_WEIGHT;
        }
        if (!filter.getDimensionName().equals("")) {
            key |= DIMENSION_NAME_WEIGHT;
        }
        if (!filter.getUniqueDimensionName().equals("")) {
            key |= UNIQUE_DIMENSION_NAME_WEIGHT;
        }
        if (!filter.getHierarchyName().equals("")) {
            key |= HIERARCHY_NAME_WEIGHT;
        }
        if (!filter.getUniqueHierarchyName().equals("")) {
            key |= UNIQUE_HIERARCHY_NAME_WEIGHT;
        }
        if (!filter.getLevelName().equals("")) {
            key |= LEVEL_NAME_WEIGHT;
        }
        if (!filter.getUniqueLevelName().equals("")) {
            key |= UNIQUE_LEVEL_NAME_WEIGHT;
        }
        if (filter.getLevelNumber() != -1) {
            key |= LEVEL_NUMBER_WEIGHT;
        }
        if (!filter.getMeasureName().equals("")) {
            key |= MEASURE_NAME_WEIGHT;
        }
        if (!filter.getUniqueMeasureName().equals("")) {
            key |= UNIQUE_MEASURE_NAME_WEIGHT;
        }
        if (!filter.getMemberName().equals("")) {
            key |= MEMBER_NAME_WEIGHT;
        }
        if (!filter.getUniqueMemberName().equals("")) {
            key |= UNIQUE_MEMBER_NAME_WEIGHT;
        }
        if (!filter.getMemberLabel().equals("")) {
            key |= MEMBER_LABEL_WEIGHT;
        }
        if (filter.getMemberType() != 0) {
            key |= TYPE_WEIGHT;
        }
        if (filter.getTreeOperator() != 0) {
            key |= TREE_OPERATOR_WEIGHT;
        }
        if (!filter.getPropertyName().equals("")) {
            key |= PROPERTY_NAME_WEIGHT;
        }
        if (filter.getPropertyType() != 0) {
            key |= PROPERTY_TYPE_WEIGHT;
        }
        return key;
    }

    public void configureCache(int bufferSize, int lookAhead, int maxFilters) throws CacheException {
        if (maxFilters != this.maxFilters) {
            this.maxFilters = maxFilters;
            this.configureMaxFilters();
        }
        if (bufferSize != this.bufferSize && lookAhead != this.lookAhead) {
            this.bufferSize = bufferSize;
            this.lookAhead = lookAhead;
            this.configureCacheableInfo(bufferSize, lookAhead);
        } else if (bufferSize != this.bufferSize) {
            this.bufferSize = bufferSize;
            this.configureCacheableInfo(bufferSize, -1);
        } else if (lookAhead != this.lookAhead) {
            this.lookAhead = lookAhead;
            this.configureCacheableInfo(-1, lookAhead);
        }
    }

    private void configureMaxFilters() {
        while (this.filtersCounter > this.maxFilters) {
            this.removeEldestCacheableInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void configureCacheableInfo(int bufferSize, int lookAhead) throws CacheException {
        Iterator iter1 = this.values().iterator();
        while (iter1.hasNext()) {
            LinkedHashMap container;
            LinkedHashMap linkedHashMap = container = (LinkedHashMap)iter1.next();
            synchronized (linkedHashMap) {
                for (CacheableInfo ca : container.values()) {
                    ca.configureCache(bufferSize, lookAhead);
                }
            }
        }
    }

    @Override
    public String toString() {
        String returnString = "";
        for (LinkedHashMap currentContainer : this.values()) {
            returnString = returnString + "\n" + currentContainer.toString();
        }
        return returnString;
    }
}

