/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.ISession;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.RB;
import java.util.Date;

@SASScope(value="ALL")
public class Measure
implements MeasureInterface {
    @SASScope
    public static final String RB_KEY = "Measure.";
    @SASScope
    protected String catalogName;
    @SASScope
    protected String schemaName;
    @SASScope
    protected String cubeName;
    @SASScope
    protected String name;
    @SASScope
    protected String uniqueName;
    @SASScope
    protected String label;
    @SASScope
    protected String description;
    @SASScope
    protected int dataType;
    @SASScope
    protected int aggregator;
    protected int precision;
    protected int scale;
    @SASScope
    protected String unit;
    protected String format;
    @SASScope
    protected MetadataInterface metadata;
    @SASScope
    protected ISession _session;
    @SASScope
    protected Filter filter;
    protected Class dataTypeClass;

    public Measure(MetadataInterface metadata, ISession _session, String catalogName, String schemaName, String cubeName, String name, String uniqueName, String label, int dataType, int aggregator, String unit, String description) throws OLAPException {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.cubeName = cubeName;
        this.name = name;
        this.uniqueName = uniqueName;
        this.label = label;
        this.description = description;
        this.dataType = dataType;
        this.aggregator = aggregator;
        this.unit = unit;
        this.metadata = metadata;
        this._session = _session;
        this.filter = null;
    }

    @SASScope
    public Measure(MetadataInterface metadata, ISession _session, String catalogName, String schemaName, String cubeName, String name, String uniqueName, String label, int dataType, int aggregator, int precision, int scale, String unit, String description) throws OLAPException {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.cubeName = cubeName;
        this.name = name;
        this.uniqueName = uniqueName;
        this.label = label;
        this.description = description;
        this.dataType = dataType;
        this.aggregator = aggregator;
        this.precision = precision;
        this.scale = scale;
        this.unit = unit;
        this.metadata = metadata;
        this._session = _session;
        this.filter = null;
    }

    @Override
    public String getName() throws OLAPException {
        return this.name;
    }

    @Override
    public String getLabel() throws OLAPException {
        return this.label;
    }

    @Override
    public String getUniqueName() throws OLAPException {
        return this.uniqueName;
    }

    @Override
    public String getDescription() throws OLAPException {
        return this.description;
    }

    @Override
    public CubeInterface getCube() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource("nullMetadata.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCatalogName(this.catalogName);
        inFilter.setSchemaName(this.schemaName);
        inFilter.setCubeName(this.cubeName);
        return this.metadata.getCube(inFilter);
    }

    @Override
    public Class getDataType() throws OLAPException {
        if (this.dataTypeClass == null && this.dataType != 0) {
            try {
                this.dataTypeClass = this.dataType == 1 ? Class.forName("java.lang.String") : (this.dataType == 2 ? Class.forName("java.lang.Double") : (this.dataType == 3 ? Class.forName("java.lang.Long") : (this.dataType == 4 ? Class.forName("java.lang.Short") : (this.dataType == 5 ? Class.forName("java.lang.Boolean") : null))));
            }
            catch (ClassNotFoundException ce) {
                this.dataTypeClass = null;
            }
        }
        return this.dataTypeClass;
    }

    @Override
    public int getAggregator() throws OLAPException {
        return this.aggregator;
    }

    @Override
    @SASScope
    public int getPrecision() throws OLAPException {
        return this.precision;
    }

    @Override
    @SASScope
    public int getScale() throws OLAPException {
        return this.scale;
    }

    @Override
    public String getUnit() throws OLAPException {
        return this.unit;
    }

    @Override
    @SASScope
    public String getFormat() throws OLAPException {
        if (this.format == null) {
            StringBuffer buffer = new StringBuffer();
            if (this.unit != null && this.unit.length() > 0) {
                buffer.append(this.unit);
                if (this.scale >= 0) {
                    buffer.append(this.scale);
                    buffer.append(".");
                    if (this.precision >= 0) {
                        buffer.append(this.precision);
                    }
                }
            }
            this.format = buffer.toString();
        }
        return this.format;
    }

    @Override
    public Filter getFilter() throws OLAPException {
        if (this.filter == null) {
            this.filter = new Filter();
            this.filter.setCatalogName(this.catalogName);
            this.filter.setSchemaName(this.schemaName);
            this.filter.setCubeName(this.cubeName);
            this.filter.setMeasureName(this.name);
            this.filter.setUniqueMeasureName(this.uniqueName);
        }
        return this.filter;
    }

    @Override
    public MetadataInterface getMetadata() throws OLAPException {
        return this.metadata;
    }

    @Override
    public Date getCreationDateTime() throws OLAPException {
        throw new OLAPException(RB.getStringResource("methodNotSupported.ex.txt"));
    }

    @Override
    public Date getUpdateDateTime() throws OLAPException {
        throw new OLAPException(RB.getStringResource("methodNotSupported.ex.txt"));
    }
}

