/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.ISession;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.SchemaInterface;
import com.sas.storage.olap.sasmdx.RB;
import com.sas.storage.olap.sasmdx.Schema;
import java.util.Date;

@SASScope(value="ALL")
public class Cube
implements CubeInterface {
    @SASScope
    protected ISession _session;
    @SASScope
    protected String label;
    @SASScope
    protected String name;
    @SASScope
    protected String type;
    @SASScope
    protected String description;
    @SASScope
    protected String schemaName;
    @SASScope
    protected String catalogName;
    @SASScope
    protected Date creationDateTime;
    @SASScope
    protected Date updateDateTime;
    @SASScope
    protected MetadataInterface metadata;
    @SASScope
    protected Filter filter;
    @SASScope
    protected SchemaInterface schema;
    @SASScope
    protected boolean isDrillthroughEnabled;
    private String normalizedName;

    public Cube(MetadataInterface metadata, ISession _session, String catalogName, String schemaName, String cubeName, String cubeType, Date creationDateTime, Date updateDateTime, String cubeDescription, boolean isDrillthroughEnabled) throws OLAPException {
        this.metadata = metadata;
        this._session = _session;
        this.catalogName = catalogName;
        this.normalizedName = cubeName.toLowerCase();
        this.label = this.name = cubeName;
        this.type = cubeType;
        this.schemaName = schemaName;
        this.filter = null;
        this.description = cubeDescription;
        this.isDrillthroughEnabled = isDrillthroughEnabled;
        this.creationDateTime = creationDateTime;
        this.updateDateTime = updateDateTime;
    }

    @Override
    public String getName() throws OLAPException {
        return this.name;
    }

    @Override
    public String getUniqueName() throws OLAPException {
        return this.name;
    }

    @Override
    public String getNormalizedName() throws OLAPException {
        return this.normalizedName;
    }

    @Override
    public String getLabel() throws OLAPException {
        return this.label;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Date getCreationDateTime() throws OLAPException {
        return this.creationDateTime;
    }

    @Override
    public Date getUpdateDateTime() throws OLAPException {
        return this.updateDateTime;
    }

    @Override
    public String getDescription() throws OLAPException {
        return this.description;
    }

    @Override
    public boolean isDrillThroughEnabled() {
        return this.isDrillthroughEnabled;
    }

    @Override
    public synchronized SchemaInterface getSchema() throws OLAPException {
        if (this.schema == null) {
            if (this.metadata == null) {
                throw new IllegalStateException(RB.getStringResource("Metadata is null"));
            }
            this.schema = new Schema(this.metadata, this._session, this.schemaName);
        }
        return this.schema;
    }

    @Override
    public DimensionInterface[] getDimensions() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource("Metadata is null"));
        }
        Filter inFilter = new Filter();
        inFilter.setCubeName(this.name);
        return this.metadata.getDimensions(inFilter);
    }

    @Override
    public MeasureInterface[] getMeasures() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource("Metadata is null"));
        }
        Filter inFilter = new Filter();
        inFilter.setCatalogName(this.catalogName);
        inFilter.setSchemaName(this.schemaName);
        inFilter.setCubeName(this.name);
        return this.metadata.getMeasures(inFilter);
    }

    @Override
    public synchronized Filter getFilter() {
        if (this.filter == null) {
            this.filter = new Filter();
            this.filter.setCatalogName(this.catalogName);
            this.filter.setSchemaName(this.schemaName);
            this.filter.setCubeName(this.name);
        }
        return this.filter;
    }

    @Override
    public MetadataInterface getMetadata() throws OLAPException {
        return this.metadata;
    }

    public String toString() {
        return this.name;
    }
}

