/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.iom.SASMDX.IMemSet;
import com.sas.iom.SASMDX.ISession;
import com.sas.iom.SASMDX.MemType;
import com.sas.models.BufferHints;
import com.sas.models.CacheException;
import com.sas.models.CacheInterface;
import com.sas.models.SequentialCache;
import com.sas.models.StaticCacheInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Member;
import com.sas.storage.olap.sasmdx.RemoteMetadata;
import java.util.Arrays;
import java.util.List;

@SASScope
public class CacheableInfo {
    private Filter filter;
    private MetadataInterface metadata;
    private ISession _session;
    private CacheInterface cache;
    private int cardinality;
    private StaticCacheInterface secondaryCache;

    public CacheableInfo(MetadataInterface metadata, ISession _session, Filter filter, int bufferSize, int lookAhead) {
        this.filter = filter;
        this.metadata = metadata;
        this._session = _session;
        this.cardinality = -1;
        this.secondaryCache = new MembersSecondaryCache();
        this.cache = new SequentialCache(this.secondaryCache, bufferSize, lookAhead);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Object getConnection() {
        return this._session;
    }

    public boolean doRestrictionsMatch(ISession session, Filter filter, int start, int count) throws CacheException {
        boolean match = false;
        if (session != null && this._session == session && filter.isMatch(this.filter) && !this.isRangeExternal(start, count)) {
            match = true;
        }
        return match;
    }

    private boolean isRangeExternal(int start, int count) throws CacheException {
        long[] keys;
        if (count == -1) {
            if (this.cardinality != -1) {
                count = this.cardinality;
            } else {
                return true;
            }
        }
        return (keys = this.cache.getCacheKeys()).length <= 0 || ((long)start < keys[0] - 1L || (long)start > keys[keys.length - 1] + 1L) && ((long)(start + count - 1) < keys[0] - 1L || (long)(start + count - 1) > keys[keys.length - 1] + 1L);
    }

    public List getMatch(int start, int count) throws CacheException {
        Object[] mems;
        if (count == -1) {
            if (this.cardinality != -1) {
                count = this.cardinality - 1;
            }
            mems = this.cache.getFromCache((long)start, (long)count, true);
        } else {
            mems = this.cache.getFromCache((long)start, (long)(start + count - 1), true);
        }
        return Arrays.asList(mems);
    }

    public void configureCache(int bufferSize, int lookAhead) throws CacheException {
        this.cache.configureCache(bufferSize, lookAhead, -1, -1, -1);
    }

    @SASScope
    public class MembersSecondaryCache
    implements StaticCacheInterface {
        MemberInterface[] allMembers = null;
        boolean haveAllMembers = false;

        public Object getFromCache(long arg0) throws CacheException {
            return this.getFromCache(arg0, arg0, true);
        }

        public Object[] getFromCache(long[] arg0, boolean arg1) throws CacheException {
            return this.getFromCache(arg0[0], arg0[arg0.length - 1], arg1);
        }

        public Object[] getFromCache(long start, long end, boolean arg2) throws CacheException {
            if (this.haveAllMembers) {
                this.haveAllMembers = false;
                return this.allMembers;
            }
            return this.getMembersFromServer((int)start, (int)(end - start + 1L));
        }

        private MemberInterface[] getMembersFromServer(int start, int count) throws CacheException {
            MemberInterface[] members = null;
            int nMembers = 0;
            ISession _nsession = null;
            try {
                _nsession = RemoteMetadata.createSession(CacheableInfo.this.metadata);
                StringSeqHolder catalogNames = new StringSeqHolder();
                StringSeqHolder schemaNames = new StringSeqHolder();
                StringSeqHolder cubeNames = new StringSeqHolder();
                StringSeqHolder uniqueDimensionNames = new StringSeqHolder();
                StringSeqHolder uniqueHierarchyNames = new StringSeqHolder();
                StringSeqHolder uniqueLevelNames = new StringSeqHolder();
                LongSeqHolder lvlDepths = new LongSeqHolder();
                StringSeqHolder names = new StringSeqHolder();
                StringSeqHolder uniqueNames = new StringSeqHolder();
                StringSeqHolder labels = new StringSeqHolder();
                LongSeqHolder types = new LongSeqHolder();
                LongSeqHolder nChildren = new LongSeqHolder();
                StringSeqHolder parentMembers = new StringSeqHolder();
                LongSeqHolder propertyDataTypes = new LongSeqHolder();
                VariableArray2dOfStringHolder propertyNames = new VariableArray2dOfStringHolder();
                StringSeqHolder excludedStringProp = new StringSeqHolder();
                LongSeqHolder excludedLongProp = new LongSeqHolder();
                UUIDSeqHolder excludedUUIDProp = new UUIDSeqHolder();
                RemoteMetadata.memberFieldInclusion[RemoteMetadata.memberFieldInclusion.length - 1] = CacheableInfo.this.filter.hasIncludeSharedDimensions();
                IMemSet _memSet = _nsession.MemMetadata(CacheableInfo.this.filter.getCatalogName(), CacheableInfo.this.filter.getSchemaName(), CacheableInfo.this.filter.getCubeName(), CacheableInfo.this.filter.getUniqueDimensionName(), CacheableInfo.this.filter.getUniqueHierarchyName(), CacheableInfo.this.filter.getUniqueLevelName(), CacheableInfo.this.filter.getLevelNumber(), CacheableInfo.this.filter.getMemberName(), CacheableInfo.this.filter.getUniqueMemberName(), CacheableInfo.this.filter.getMemberLabel(), MemType.from_int((int)CacheableInfo.this.filter.getMemberType()), CacheableInfo.this.filter.getTreeOperator(), RemoteMetadata.memberFieldInclusion);
                nMembers = _memSet.ReadRows(start, count, catalogNames, schemaNames, cubeNames, uniqueDimensionNames, uniqueHierarchyNames, uniqueLevelNames, lvlDepths, excludedLongProp, names, uniqueNames, types, excludedUUIDProp, labels, nChildren, excludedLongProp, parentMembers, excludedLongProp, excludedStringProp, propertyDataTypes, propertyNames);
                _memSet.Close();
                RemoteMetadata.memberFieldInclusion[RemoteMetadata.memberFieldInclusion.length - 1] = false;
                members = new MemberInterface[nMembers];
                for (int i = 0; i < nMembers; ++i) {
                    Member member = new Member(CacheableInfo.this.metadata, CacheableInfo.this._session, catalogNames.value[i], schemaNames.value[i], cubeNames.value[i], uniqueDimensionNames.value[i], uniqueHierarchyNames.value[i], uniqueLevelNames.value[i], lvlDepths.value[i], names.value[i], uniqueNames.value[i], labels.value[i], types.value[i], nChildren.value[i], parentMembers.value[i], 0, null);
                    members[i] = member;
                }
            }
            catch (Exception ex) {
                throw new CacheException(ex);
            }
            finally {
                try {
                    RemoteMetadata.closeSession(_nsession);
                }
                catch (OLAPException oe) {
                    System.out.println("Unable to close the Session");
                }
            }
            return members;
        }

        public long[] computeCacheKeyRange(long start, long end, int lookAhead) throws CacheException {
            if (end == -1L) {
                this.allMembers = this.getMembersFromServer((int)start, (int)end);
                this.haveAllMembers = true;
                CacheableInfo.this.cardinality = (int)start + this.allMembers.length;
                end = CacheableInfo.this.cardinality - 1;
                lookAhead = 0;
            }
            return SequentialCache.computeSequentialKeyRange((long)start, (long)end, (int)lookAhead);
        }

        public long[] getCacheKeys() throws CacheException {
            return null;
        }

        public boolean cacheContainsKey(long arg0) throws CacheException {
            return true;
        }

        public int getCacheKeyUse() {
            return 0;
        }

        public void configureCache(int arg0, int arg1, int arg2, int arg3, int arg4) throws CacheException {
        }

        public StaticCacheInterface getSecondaryCache() {
            return null;
        }

        public void useBufferHints(BufferHints hints) {
        }

        public int count() {
            return 0;
        }
    }
}

